/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Quaternionfc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;
import org.joml.internal.MemUtil;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Vector4f
implements Externalizable,
Vector4fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 1.0f;
    }

    public Vector4f(Vector4fc v) {
        if (v instanceof Vector4f) {
            MemUtil.INSTANCE.copy((Vector4f)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
    }

    public Vector4f(Vector4ic v) {
        this(v.x(), v.y(), v.z(), v.w());
    }

    public Vector4f(Vector3fc v, float w) {
        this(v.x(), v.y(), v.z(), w);
    }

    public Vector4f(Vector3ic v, float w) {
        this(v.x(), v.y(), v.z(), w);
    }

    public Vector4f(Vector2fc v, float z, float w) {
        this(v.x(), v.y(), z, w);
    }

    public Vector4f(Vector2ic v, float z, float w) {
        this(v.x(), v.y(), z, w);
    }

    public Vector4f(float d) {
        MemUtil.INSTANCE.broadcast(d, this);
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector4f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    private Vector4f thisOrNew() {
        return this;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Vector4f set(Vector4fc v) {
        if (v instanceof Vector4f) {
            MemUtil.INSTANCE.copy((Vector4f)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
        return this;
    }

    public Vector4f set(Vector4ic v) {
        return this.set(v.x(), v.y(), v.z(), v.w());
    }

    public Vector4f set(Vector4dc v) {
        return this.set((float)v.x(), (float)v.y(), (float)v.z(), (float)v.w());
    }

    public Vector4f set(Vector3fc v, float w) {
        return this.set(v.x(), v.y(), v.z(), w);
    }

    public Vector4f set(Vector3ic v, float w) {
        return this.set(v.x(), v.y(), v.z(), w);
    }

    public Vector4f set(Vector2fc v, float z, float w) {
        return this.set(v.x(), v.y(), z, w);
    }

    public Vector4f set(Vector2ic v, float z, float w) {
        return this.set(v.x(), v.y(), z, w);
    }

    public Vector4f set(float d) {
        MemUtil.INSTANCE.broadcast(d, this);
        return this;
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(double d) {
        return this.set(d, d, d, d);
    }

    public Vector4f set(double x, double y, double z, double w) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.w = (float)w;
        return this;
    }

    public Vector4f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4f setFromAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.get(this, address);
        return this;
    }

    public Vector4f setComponent(int component, float value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector4fc getToAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.put(this, address);
        return this;
    }

    public Vector4f sub(Vector4fc v) {
        return this.sub(v, this.thisOrNew());
    }

    public Vector4f sub(float x, float y, float z, float w) {
        return this.sub(x, y, z, w, this.thisOrNew());
    }

    public Vector4f sub(Vector4fc v, Vector4f dest) {
        return this.sub(v.x(), v.y(), v.z(), v.w(), dest);
    }

    public Vector4f sub(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4f add(Vector4fc v) {
        return this.add(v, this.thisOrNew());
    }

    public Vector4f add(Vector4fc v, Vector4f dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        dest.w = this.w + v.w();
        return dest;
    }

    public Vector4f add(float x, float y, float z, float w) {
        return this.add(x, y, z, w, this.thisOrNew());
    }

    public Vector4f add(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4f fma(Vector4fc a, Vector4fc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector4f fma(float a, Vector4fc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector4f fma(Vector4fc a, Vector4fc b, Vector4f dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        dest.z = this.z + a.z() * b.z();
        dest.w = this.w + a.w() * b.w();
        return dest;
    }

    public Vector4f fma(float a, Vector4fc b, Vector4f dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        dest.z = this.z + a * b.z();
        dest.w = this.w + a * b.w();
        return dest;
    }

    public Vector4f mul(Vector4fc v) {
        return this.mul(v, this.thisOrNew());
    }

    public Vector4f mul(Vector4fc v, Vector4f dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        dest.w = this.w * v.w();
        return dest;
    }

    public Vector4f div(Vector4fc v) {
        return this.div(v, this.thisOrNew());
    }

    public Vector4f div(Vector4fc v, Vector4f dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        dest.w = this.w / v.w();
        return dest;
    }

    public Vector4f mul(Matrix4fc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector4f mul(Matrix4fc mat, Vector4f dest) {
        if ((mat.properties() & 2) != 0) {
            return this.mulAffine(mat, dest);
        }
        return this.mulGeneric(mat, dest);
    }

    public Vector4f mulAffine(Matrix4fc mat, Vector4f dest) {
        float rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w;
        float ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w;
        float rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        dest.w = this.w;
        return dest;
    }

    private Vector4f mulGeneric(Matrix4fc mat, Vector4f dest) {
        float rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w;
        float ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w;
        float rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w;
        float rw = mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        dest.w = rw;
        return dest;
    }

    public Vector4f mul(Matrix4x3fc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector4f mul(Matrix4x3fc mat, Vector4f dest) {
        float rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w;
        float ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w;
        float rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        dest.w = this.w;
        return dest;
    }

    public Vector4f mulProject(Matrix4fc mat, Vector4f dest) {
        float invW = 1.0f / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        float rx = (mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w) * invW;
        float ry = (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w) * invW;
        float rz = (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w) * invW;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        dest.w = 1.0f;
        return dest;
    }

    public Vector4f mulProject(Matrix4fc mat) {
        return this.mulProject(mat, this.thisOrNew());
    }

    public Vector3f mulProject(Matrix4fc mat, Vector3f dest) {
        float invW = 1.0f / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        float rx = (mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w) * invW;
        float ry = (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w) * invW;
        float rz = (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w) * invW;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector4f mul(float scalar) {
        return this.mul(scalar, this.thisOrNew());
    }

    public Vector4f mul(float scalar, Vector4f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        dest.w = this.w * scalar;
        return dest;
    }

    public Vector4f mul(float x, float y, float z, float w) {
        return this.mul(x, y, z, w, this.thisOrNew());
    }

    public Vector4f mul(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        dest.w = this.w * w;
        return dest;
    }

    public Vector4f div(float scalar) {
        return this.div(scalar, this.thisOrNew());
    }

    public Vector4f div(float scalar, Vector4f dest) {
        float inv = 1.0f / scalar;
        dest.x = this.x * inv;
        dest.y = this.y * inv;
        dest.z = this.z * inv;
        dest.w = this.w * inv;
        return dest;
    }

    public Vector4f div(float x, float y, float z, float w) {
        return this.div(x, y, z, w, this.thisOrNew());
    }

    public Vector4f div(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        dest.w = this.w / w;
        return dest;
    }

    public Vector4f rotate(Quaternionfc quat) {
        return this.rotate(quat, this.thisOrNew());
    }

    public Vector4f rotate(Quaternionfc quat, Vector4f dest) {
        return quat.transform(this, dest);
    }

    public Vector4f rotateAbout(float angle, float x, float y, float z) {
        return this.rotateAxis(angle, x, y, z, this.thisOrNew());
    }

    public Vector4f rotateAxis(float angle, float aX, float aY, float aZ, Vector4f dest) {
        if (aY == 0.0f && aZ == 0.0f && Math.abs(aX) == 1.0f) {
            return this.rotateX(aX * angle, dest);
        }
        if (aX == 0.0f && aZ == 0.0f && Math.abs(aY) == 1.0f) {
            return this.rotateY(aY * angle, dest);
        }
        if (aX == 0.0f && aY == 0.0f && Math.abs(aZ) == 1.0f) {
            return this.rotateZ(aZ * angle, dest);
        }
        return this.rotateAxisInternal(angle, aX, aY, aZ, dest);
    }

    private Vector4f rotateAxisInternal(float angle, float aX, float aY, float aZ, Vector4f dest) {
        float hangle = angle * 0.5f;
        float sinAngle = (float)Math.sin(hangle);
        float qx = aX * sinAngle;
        float qy = aY * sinAngle;
        float qz = aZ * sinAngle;
        float qw = (float)Math.cosFromSin(sinAngle, hangle);
        float w2 = qw * qw;
        float x2 = qx * qx;
        float y2 = qy * qy;
        float z2 = qz * qz;
        float zw = qz * qw;
        float xy = qx * qy;
        float xz = qx * qz;
        float yw = qy * qw;
        float yz = qy * qz;
        float xw = qx * qw;
        float nx = (w2 + x2 - z2 - y2) * this.x + (-zw + xy - zw + xy) * this.y + (yw + xz + xz + yw) * this.z;
        float ny = (xy + zw + zw + xy) * this.x + (y2 - z2 + w2 - x2) * this.y + (yz + yz - xw - xw) * this.z;
        float nz = (xz - yw + xz - yw) * this.x + (yz + yz + xw + xw) * this.y + (z2 - y2 - x2 + w2) * this.z;
        dest.x = nx;
        dest.y = ny;
        dest.z = nz;
        return dest;
    }

    public Vector4f rotateX(float angle) {
        return this.rotateX(angle, this.thisOrNew());
    }

    public Vector4f rotateX(float angle, Vector4f dest) {
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cosFromSin(sin, angle);
        float y = this.y * cos - this.z * sin;
        float z = this.y * sin + this.z * cos;
        dest.x = this.x;
        dest.y = y;
        dest.z = z;
        dest.w = this.w;
        return dest;
    }

    public Vector4f rotateY(float angle) {
        return this.rotateY(angle, this.thisOrNew());
    }

    public Vector4f rotateY(float angle, Vector4f dest) {
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cosFromSin(sin, angle);
        float x = this.x * cos + this.z * sin;
        float z = -this.x * sin + this.z * cos;
        dest.x = x;
        dest.y = this.y;
        dest.z = z;
        dest.w = this.w;
        return dest;
    }

    public Vector4f rotateZ(float angle) {
        return this.rotateZ(angle, this.thisOrNew());
    }

    public Vector4f rotateZ(float angle, Vector4f dest) {
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cosFromSin(sin, angle);
        float x = this.x * cos - this.y * sin;
        float y = this.x * sin + this.y * cos;
        dest.x = x;
        dest.y = y;
        dest.z = this.z;
        dest.w = this.w;
        return dest;
    }

    public float lengthSquared() {
        return Vector4f.lengthSquared(this.x, this.y, this.z, this.w);
    }

    public static float lengthSquared(float x, float y, float z, float w) {
        return x * x + y * y + z * z + w * w;
    }

    public static float lengthSquared(int x, int y, int z, int w) {
        return x * x + y * y + z * z + w * w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public static float length(float x, float y, float z, float w) {
        return (float)Math.sqrt(x * x + y * y + z * z + w * w);
    }

    public Vector4f normalize() {
        return this.normalize(this.thisOrNew());
    }

    public Vector4f normalize(Vector4f dest) {
        float invLength = 1.0f / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4f normalize(float length) {
        return this.normalize(length, this.thisOrNew());
    }

    public Vector4f normalize(float length, Vector4f dest) {
        float invLength = 1.0f / this.length() * length;
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4f normalize3() {
        return this.normalize3(this.thisOrNew());
    }

    public Vector4f normalize3(Vector4f dest) {
        float invLength = 1.0f / (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public float distance(Vector4fc v) {
        return this.distance(v.x(), v.y(), v.z(), v.w());
    }

    public float distance(float x, float y, float z, float w) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    public float distanceSquared(Vector4fc v) {
        return this.distanceSquared(v.x(), v.y(), v.z(), v.w());
    }

    public float distanceSquared(float x, float y, float z, float w) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        float dw = this.w - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public static float distance(float x1, float y1, float z1, float w1, float x2, float y2, float z2, float w2) {
        return (float)Math.sqrt(Vector4f.distanceSquared(x1, y1, z1, w1, x2, y2, z2, w2));
    }

    public static float distanceSquared(float x1, float y1, float z1, float w1, float x2, float y2, float z2, float w2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        float dz = z1 - z2;
        float dw = w1 - w2;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public float dot(Vector4fc v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public float angleCos(Vector4fc v) {
        double length1Squared = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        double length2Squared = v.x() * v.x() + v.y() * v.y() + v.z() * v.z() + v.w() * v.w();
        double dot = this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
        return (float)(dot / Math.sqrt(length1Squared * length2Squared));
    }

    public float angle(Vector4fc v) {
        float cos = this.angleCos(v);
        cos = cos < 1.0f ? cos : 1.0f;
        cos = cos > -1.0f ? cos : -1.0f;
        return (float)Math.acos(cos);
    }

    public Vector4f zero() {
        Vector4f dest = this.thisOrNew();
        MemUtil.INSTANCE.zero(dest);
        return dest;
    }

    public Vector4f negate() {
        return this.negate(this.thisOrNew());
    }

    public Vector4f negate(Vector4f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public Vector4f min(Vector4fc v) {
        return this.min(v, this.thisOrNew());
    }

    public Vector4f min(Vector4fc v, Vector4f dest) {
        dest.x = this.x < v.x() ? this.x : v.x();
        dest.y = this.y < v.y() ? this.y : v.y();
        dest.z = this.z < v.z() ? this.z : v.z();
        dest.w = this.w < v.w() ? this.w : v.w();
        return dest;
    }

    public Vector4f max(Vector4fc v) {
        return this.max(v, this.thisOrNew());
    }

    public Vector4f max(Vector4fc v, Vector4f dest) {
        dest.x = this.x > v.x() ? this.x : v.x();
        dest.y = this.y > v.y() ? this.y : v.y();
        dest.z = this.z > v.z() ? this.z : v.z();
        dest.w = this.w > v.w() ? this.w : v.w();
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.w);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4f other = (Vector4f)obj;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(other.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public boolean equals(Vector4fc v, float delta) {
        if (this == v) {
            return true;
        }
        if (v == null) {
            return false;
        }
        if (!(v instanceof Vector4fc)) {
            return false;
        }
        if (!Runtime.equals(this.x, v.x(), delta)) {
            return false;
        }
        if (!Runtime.equals(this.y, v.y(), delta)) {
            return false;
        }
        if (!Runtime.equals(this.z, v.z(), delta)) {
            return false;
        }
        return Runtime.equals(this.w, v.w(), delta);
    }

    public boolean equals(float x, float y, float z, float w) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(y)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(z)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(w);
    }

    public Vector4f smoothStep(Vector4fc v, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v.x() - v.x()) * t3 + (3.0f * v.x() - 3.0f * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y() - v.y()) * t3 + (3.0f * v.y() - 3.0f * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z() - v.z()) * t3 + (3.0f * v.z() - 3.0f * this.z) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v.w() - v.w()) * t3 + (3.0f * v.w() - 3.0f * this.w) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f hermite(Vector4fc t0, Vector4fc v1, Vector4fc t1, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x() - v1.x() + t1.x() + t0.x()) * t3 + (3.0f * v1.x() - 3.0f * this.x - t0.x() - t0.x() - t1.x()) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y() - v1.y() + t1.y() + t0.y()) * t3 + (3.0f * v1.y() - 3.0f * this.y - t0.y() - t0.y() - t1.y()) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z() - v1.z() + t1.z() + t0.z()) * t3 + (3.0f * v1.z() - 3.0f * this.z - t0.z() - t0.z() - t1.z()) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v1.w() - v1.w() + t1.w() + t0.w()) * t3 + (3.0f * v1.w() - 3.0f * this.w - t0.w() - t0.w() - t1.w()) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f lerp(Vector4fc other, float t) {
        return this.lerp(other, t, this.thisOrNew());
    }

    public Vector4f lerp(Vector4fc other, float t, Vector4f dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        dest.z = this.z + (other.z() - this.z) * t;
        dest.w = this.w + (other.w() - this.w) * t;
        return dest;
    }

    public float get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4f get(Vector4f dest) {
        return dest.set(this);
    }

    public Vector4d get(Vector4d dest) {
        return dest.set(this);
    }

    public int maxComponent() {
        float absX = Math.abs(this.x);
        float absY = Math.abs(this.y);
        float absZ = Math.abs(this.z);
        float absW = Math.abs(this.w);
        if (absX >= absY && absX >= absZ && absX >= absW) {
            return 0;
        }
        if (absY >= absZ && absY >= absW) {
            return 1;
        }
        if (absZ >= absW) {
            return 2;
        }
        return 3;
    }

    public int minComponent() {
        float absX = Math.abs(this.x);
        float absY = Math.abs(this.y);
        float absZ = Math.abs(this.z);
        float absW = Math.abs(this.w);
        if (absX < absY && absX < absZ && absX < absW) {
            return 0;
        }
        if (absY < absZ && absY < absW) {
            return 1;
        }
        if (absZ < absW) {
            return 2;
        }
        return 3;
    }

    public Vector4f floor() {
        return this.floor(this.thisOrNew());
    }

    public Vector4f floor(Vector4f dest) {
        dest.x = Math.floor(this.x);
        dest.y = Math.floor(this.y);
        dest.z = Math.floor(this.z);
        dest.w = Math.floor(this.w);
        return dest;
    }

    public Vector4f ceil() {
        return this.ceil(this.thisOrNew());
    }

    public Vector4f ceil(Vector4f dest) {
        dest.x = Math.ceil(this.x);
        dest.y = Math.ceil(this.y);
        dest.z = Math.ceil(this.z);
        dest.w = Math.ceil(this.w);
        return dest;
    }

    public Vector4f round() {
        return this.round(this.thisOrNew());
    }

    public Vector4f round(Vector4f dest) {
        dest.x = Math.round(this.x);
        dest.y = Math.round(this.y);
        dest.z = Math.round(this.z);
        dest.w = Math.round(this.w);
        return dest;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }
}

