/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.event.MouseEvent;
import processing.opengl.PGraphics3D;
import processing.opengl.PJOGL;
import processing.opengl.PSurfaceJOGL;

public class Avalanche
extends PApplet {
    ArrayList<Vertex> vertices;
    ArrayList<Face> faces;
    ArrayList<Window> windows;
    HashMap<String, Material> materials;
    Button snapToGridCheckbox;
    Button showVerticesCheckbox;
    Button centerOfMassCheckbox;
    Button darkModeCheckbox;
    Vertex centerOfMass;
    Vertex singleSelectedVertex;
    Face singleSelectedFace;
    Button showEdgesCheckbox;
    Button showFacesCheckbox;
    Button showLightingCheckbox;
    Button showNormalsCheckbox;
    Button showTexturesCheckbox;
    Button selectBackFacingCheckbox;
    Button fullScreenCheckbox;
    UIImage materialDiffuseImage;
    UIGroup vertexEditGroup;
    UIGroup multipleVertexEditGroup;
    UIGroup faceEditGroup;
    UIGroup materialEditGroup;
    UIGroup newMaterialGroup;
    VectorEditor vEditor;
    VectorEditor n1Editor;
    VectorEditor n2Editor;
    VectorEditor n3Editor;
    VectorEditor t1Editor;
    VectorEditor t2Editor;
    VectorEditor t3Editor;
    VectorEditor kaEditor;
    VectorEditor kdEditor;
    VectorEditor ksEditor;
    TextBox commandBox;
    Label editLabel;
    DropDownList materialSelector;
    int mode;
    boolean saveNextDraw;
    float oldWidth;
    float oldHeight;
    boolean ctrlPressed = false;
    boolean dragWithoutPressInvalidatesClick = false;
    boolean[] keyDown;
    boolean[] lastKeyDown;
    boolean[] keyCodeDown;
    boolean[] lastKeyCodeDown;
    Preferences prefs;
    static final int MODE_PLACE = 1;
    static final int MODE_SELECT_VERTEX = 2;
    static final int MODE_SELECT_FACE = 3;
    static final int MODE_MOVE = 4;
    static final int MODE_SCALE_ALL = 5;
    static final int MODE_SCALE = 6;
    static final int MODE_ROTATE = 7;
    static final int VIEW_Z = 1;
    static final int VIEW_Y = 2;
    static final int VIEW_X = 3;
    static final int VIEW_3D = 4;
    static final String[] VIEW_NAMES = new String[]{"", "FRONT", "TOP ", "LEFT", "PERSPECTIVE"};
    static final float VIEW_SCALE = 0.1f;
    static final float STARTING_SCALE = 5.0f;
    static final float SCROLL_MULTIPLIER = 1.05f;
    static final float SCROLL_3D_MOVE = 0.2f;
    static final float SCROLL_SHIFT_MULTIPLIER = 10.0f;
    static final float ROTATE_SPEED = 3.0f;
    static final float CAMERA_MOVEMENT_SCALE = 0.05f;
    static final float CAMERA_MOVEMENT_SHIFT_SCALE = 10.0f;
    static final int UI_COLUMN_WIDTH = 240;
    static final int UI_BAR_HEIGHT = 50;
    static final float PAN_SPEED_3D = 0.002f;
    static final float GEOM_SCALING_FACTOR = 1.001f;
    static final int DROP_DOWN_MAX = 4;
    static final int UI_BUTTON_HEIGHT = 25;
    static final int UI_BUTTON_BETWEEN = 7;
    static final int UI_BUTTON_TEXT = 15;
    HashMap<String, Thunk> commands = new HashMap();
    int curNormalIndex;
    int curTextureIndex;
    static final int NUM_AROUND = 15;
    static final int NUM_UP = 50;
    boolean splashActive = true;
    PImage splashImage = null;
    ArrayList<UIElement> elements = new ArrayList();
    boolean isMousePressed = false;
    boolean isKeyPressed = false;
    boolean wasMousePressed = false;
    boolean wasKeyPressed = false;
    MouseEvent uiLastMouseWheelEvent = null;
    MouseEvent curMouseWheelEvent = null;
    static final DecimalFormat df = new DecimalFormat("0.####");
    Stack<UndoRecord> undoRecords = new Stack();

    public void resetMaterials() {
        ArrayList<String> materialNames = new ArrayList<String>();
        for (Material vm : this.materials.values()) {
            materialNames.add(vm.name);
        }
        this.materialSelector.options = materialNames;
        this.materialSelector.selectedOption = 0;
    }

    public void clearSelected() {
        int i = this.vertices.size() - 1;
        while (i >= 0) {
            Vertex v = this.vertices.get(i);
            v.selected = false;
            --i;
        }
        i = this.faces.size() - 1;
        while (i >= 0) {
            Face f = this.faces.get(i);
            f.selected = false;
            --i;
        }
    }

    public void updateSelected() {
        ArrayList<Vertex> selected = new ArrayList<Vertex>();
        this.centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
        int i = this.vertices.size() - 1;
        while (i >= 0) {
            Vertex v = this.vertices.get(i);
            if (v.selected) {
                selected.add(v);
                this.centerOfMass.x += v.x;
                this.centerOfMass.y += v.y;
                this.centerOfMass.z += v.z;
                this.vEditor.updateText(new Vector3f(v.x, v.y, v.z));
            }
            --i;
        }
        ArrayList<Face> selectedFaces = new ArrayList<Face>();
        int i2 = this.faces.size() - 1;
        while (i2 >= 0) {
            Face f = this.faces.get(i2);
            if (f.selected) {
                selectedFaces.add(f);
                this.n1Editor.updateText(new Vector3f(f.v1.nx, f.v1.ny, f.v1.nz));
                this.n2Editor.updateText(new Vector3f(f.v2.nx, f.v2.ny, f.v2.nz));
                this.n3Editor.updateText(new Vector3f(f.v3.nx, f.v3.ny, f.v3.nz));
                this.t1Editor.updateText(new Vector3f(f.v1.tx, f.v1.ty, 0.0f));
                this.t2Editor.updateText(new Vector3f(f.v2.tx, f.v2.ty, 0.0f));
                this.t3Editor.updateText(new Vector3f(f.v3.tx, f.v3.ty, 0.0f));
                if (f.m != null) {
                    this.kaEditor.updateText(f.m.Ka);
                    this.kdEditor.updateText(f.m.Kd);
                    this.ksEditor.updateText(f.m.Ks);
                    this.materialDiffuseImage.image = f.m.texture_diffuse;
                }
            }
            --i2;
        }
        this.centerOfMass.x /= (float)selected.size();
        this.centerOfMass.y /= (float)selected.size();
        this.centerOfMass.z /= (float)selected.size();
        this.multipleVertexEditGroup.setVisible(false);
        this.vertexEditGroup.setVisible(false);
        this.faceEditGroup.setVisible(false);
        this.materialEditGroup.setVisible(false);
        this.newMaterialGroup.setVisible(false);
        if (selected.size() == 1) {
            this.singleSelectedVertex = (Vertex)selected.get(0);
            this.vertexEditGroup.setVisible(true);
        }
        if (selected.size() > 0) {
            this.multipleVertexEditGroup.setVisible(true);
        }
        boolean allSelectedFacesHaveNoMaterial = true;
        boolean allSelectedFacesHaveSameMaterial = true;
        Material jointMaterial = null;
        if (selectedFaces.size() == 0) {
            allSelectedFacesHaveNoMaterial = false;
            allSelectedFacesHaveSameMaterial = false;
        } else {
            this.singleSelectedFace = (Face)selectedFaces.get(0);
            for (Face f : selectedFaces) {
                if (f.m != null) {
                    allSelectedFacesHaveNoMaterial = false;
                    if (jointMaterial == null) {
                        jointMaterial = f.m;
                        continue;
                    }
                    if (jointMaterial == f.m) continue;
                    allSelectedFacesHaveSameMaterial = false;
                    continue;
                }
                allSelectedFacesHaveSameMaterial = false;
            }
        }
        if (allSelectedFacesHaveNoMaterial) {
            this.newMaterialGroup.setVisible(true);
        } else if (allSelectedFacesHaveSameMaterial && this.singleSelectedFace.m != null) {
            this.materialEditGroup.setVisible(true);
            this.materialSelector.selectedOption = this.materialSelector.options.indexOf(this.singleSelectedFace.m.name);
        }
        if (selectedFaces.size() == 1) {
            if (this.singleSelectedFace.v1.hasNormal) {
                this.n1Editor.setVisible(true);
                this.n2Editor.setVisible(true);
                this.n3Editor.setVisible(true);
            }
            if (this.singleSelectedFace.v1.hasTexture) {
                this.t1Editor.setVisible(true);
                this.t2Editor.setVisible(true);
                this.t3Editor.setVisible(true);
            }
        }
    }

    public void updateSelectedVertexPosition() {
        Vertex v = this.singleSelectedVertex;
        if (v.selected) {
            Vector3f vec = new Vector3f();
            this.vEditor.updateValues(vec);
            v.x = vec.x;
            v.y = vec.y;
            v.z = vec.z;
        }
    }

    public void updateMaterialChoice() {
        for (Face f : this.faces) {
            if (!f.selected) continue;
            f.m = this.materials.get(this.materialSelector.options.get(this.materialSelector.selectedOption));
        }
    }

    public void updateSelectedMaterial() {
        Material m;
        Face f = this.singleSelectedFace;
        if (f.selected && (m = f.m) != null) {
            this.kaEditor.updateValues(this.singleSelectedFace.m.Ka);
            this.kdEditor.updateValues(this.singleSelectedFace.m.Kd);
            this.ksEditor.updateValues(this.singleSelectedFace.m.Ks);
        }
    }

    public void updateSelectedFace() {
        Face f = this.singleSelectedFace;
        if (f.selected) {
            Vector3f vec = new Vector3f();
            this.n1Editor.updateValues(vec);
            f.v1.nx = vec.x;
            f.v1.ny = vec.y;
            f.v1.nz = vec.z;
            this.n2Editor.updateValues(vec);
            f.v2.nx = vec.x;
            f.v2.ny = vec.y;
            f.v2.nz = vec.z;
            this.n3Editor.updateValues(vec);
            f.v3.nx = vec.x;
            f.v3.ny = vec.y;
            f.v3.nz = vec.z;
            this.t1Editor.updateValues(vec);
            f.v1.tx = vec.x;
            f.v1.ty = vec.y;
            this.t2Editor.updateValues(vec);
            f.v2.tx = vec.x;
            f.v2.ty = vec.y;
            this.t3Editor.updateValues(vec);
            f.v3.tx = vec.x;
            f.v3.ty = vec.y;
        }
    }

    public void pre() {
        if (this.oldWidth != (float)this.width || this.oldHeight != (float)this.height) {
            this.resizeUI(this.oldWidth, this.oldHeight, this.width, this.height);
            int windowWidth = (this.width - 240) / 2 - 5;
            int windowHeight = this.height / 2 - 5;
            this.windows.get(0).resize(0, 0, windowWidth, windowHeight);
            this.windows.get(1).resize(windowWidth + 5, 0, windowWidth, windowHeight);
            this.windows.get(2).resize(0, windowHeight + 5, windowWidth, windowHeight);
            this.windows.get(3).resize(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight);
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        }
    }

    public void settings() {
        if (this.displayWidth > 1920 && this.displayHeight > 1080) {
            this.size(1920, 1080, "processing.opengl.PGraphics3D");
            this.oldWidth = 1920.0f;
            this.oldHeight = 1080.0f;
        } else {
            this.size(1280, 1024, "processing.opengl.PGraphics3D");
            this.oldWidth = 1280.0f;
            this.oldHeight = 1024.0f;
        }
        PJOGL.setIcon((String[])new String[]{"Avalanche_Icon.png"});
    }

    public void toggleFullScreen() {
        if (!this.fullScreenCheckbox.selected) {
            int windowWidth = this.width - 240 - 5;
            int windowHeight = this.height - 5;
            for (Window w : this.windows) {
                if (w.viewType == 4) {
                    w.resize(0, 0, windowWidth, windowHeight);
                    continue;
                }
                w.resize(0, 0, 0, 0);
            }
        } else {
            int windowWidth = (this.width - 240) / 2 - 5;
            int windowHeight = this.height / 2 - 5;
            this.windows.get(0).resize(0, 0, windowWidth, windowHeight);
            this.windows.get(1).resize(windowWidth + 5, 0, windowWidth, windowHeight);
            this.windows.get(2).resize(0, windowHeight + 5, windowWidth, windowHeight);
            this.windows.get(3).resize(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight);
        }
    }

    public void addMaterial() {
        for (Face f : this.faces) {
            if (!f.selected) continue;
            if (this.materials.size() == 0) {
                f.m = new Material("Avalanche1");
                this.materials.put(f.m.name, f.m);
                this.resetMaterials();
            } else {
                Iterator<Material> v = this.materials.values().iterator();
                f.m = v.next();
            }
            Vector3f n = this.faceNormal(f);
            f.v1.setNormal(n.x, n.y, n.z);
            f.v2.setNormal(n.x, n.y, n.z);
            f.v3.setNormal(n.x, n.y, n.z);
            f.v1.setTexture(0.0f, 0.0f);
            f.v2.setTexture(0.0f, 1.0f);
            f.v3.setTexture(1.0f, 0.0f);
        }
        this.updateSelected();
    }

    public void setup() {
        this.prefs = Preferences.userRoot().node(((Object)((Object)this)).getClass().getName());
        if (this.prefs.getBoolean("SplashSeen", false)) {
            this.splashActive = false;
        }
        this.surface.setTitle("Avalanche 3D Editor");
        this.frameRate(30.0f);
        this.surface.setResizable(true);
        this.registerMethod("pre", (Object)this);
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.windows = new ArrayList();
        this.materials = new HashMap();
        this.keyDown = new boolean[1024];
        this.keyCodeDown = new boolean[1024];
        this.lastKeyDown = new boolean[1024];
        this.lastKeyCodeDown = new boolean[1024];
        int uiY = 10;
        final Avalanche myThis = this;
        new Button("Open", "o", false, null, this.width - 240 + 10, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.openFile(myThis);
            }
        }, null);
        new Button("Save", "p", false, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.saveFile(myThis);
            }
        }, null);
        uiY += 25;
        new Line(uiY += 7, null);
        new Button("Place", "1", false, "Mode", this.width - 240 + 10, uiY += 7, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.mode = 1;
            }
        }, null);
        (Avalanche)this.new Button((String)"Select Vertex", (String)"2", (boolean)false, (String)"Mode", (int)(this.width - 240 + 10 + 110), (int)uiY, (int)100, (int)25, (Thunk)new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.clearSelected();
                Avalanche.this.mode = 2;
            }
        }, null).selected = true;
        new Button("Select Face", "3", false, "Mode", this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.clearSelected();
                Avalanche.this.mode = 3;
            }
        }, null);
        new Button("Move", "4", false, "Mode", this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.mode = 4;
            }
        }, null);
        new Button("Scale (All)", "5", false, "Mode", this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.mode = 5;
            }
        }, null);
        new Button("Scale", "6", false, "Mode", this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.mode = 6;
            }
        }, null);
        new Button("Rotate", "7", false, "Mode", this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.mode = 7;
            }
        }, null);
        new Line(uiY += 32, null);
        this.snapToGridCheckbox = new Button("Snap To Grid", "g", true, null, this.width - 240 + 10, uiY += 7, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.centerOfMassCheckbox = new Button("Center of Mass", "h", true, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.centerOfMassCheckbox.selected = true;
        this.darkModeCheckbox = new Button("Dark Mode", "i", true, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.darkModeCheckbox.selected = true;
        this.selectBackFacingCheckbox = new Button("Back Facing", "o", true, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.selectBackFacingCheckbox.selected = true;
        this.fullScreenCheckbox = new Button("3D Only", "=", true, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.toggleFullScreen();
            }
        }, null);
        new Line(uiY += 32, null);
        new Label("SHOW", uiY += 7, null);
        this.showVerticesCheckbox = new Button("Vertices", "z", true, null, this.width - 240 + 10, uiY += 15, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showVerticesCheckbox.selected = true;
        this.showEdgesCheckbox = new Button("Edges", "x", true, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showEdgesCheckbox.selected = true;
        this.showFacesCheckbox = new Button("Faces", "c", true, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showFacesCheckbox.selected = true;
        this.showLightingCheckbox = new Button("Light", "v", true, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showLightingCheckbox.selected = true;
        this.showNormalsCheckbox = new Button("Normals", "b", true, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showNormalsCheckbox.selected = true;
        this.showTexturesCheckbox = new Button("Texture", "n", true, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
            }
        }, null);
        this.showTexturesCheckbox.selected = true;
        new Line(uiY += 32, null);
        new Button("Face", "f", false, null, this.width - 240 + 10, uiY += 7, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.addFace();
            }
        }, null);
        new Button("Cube", "/", false, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.makeCube();
            }
        }, null);
        new Button("Sphere", ".", false, null, this.width - 240 + 10 + 110, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.makeSphere();
            }
        }, null);
        new Button("Toggle Normal", "\\", false, null, this.width - 240 + 10, uiY += 32, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.toggleNormals();
            }
        }, null);
        new Line(uiY += 32, null);
        this.editLabel = new Label("EDIT", uiY += 7, null);
        int headOfGroupY = uiY += 30;
        this.vertexEditGroup = new UIGroup();
        this.multipleVertexEditGroup = new UIGroup();
        new Button("Join Verts", "j", false, null, this.width - 240 + 10, uiY, 100, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.joinVerts();
            }
        }, this.multipleVertexEditGroup);
        this.vEditor = new VectorEditor("X", "Y", "Z", true, false, this.width - 240 + 10, uiY += 39, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedVertexPosition();
            }
        }, this.vertexEditGroup);
        this.faceEditGroup = new UIGroup();
        this.n1Editor = new VectorEditor("NX", "NY", "NZ", true, false, this.width - 240 + 10, uiY, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.n2Editor = new VectorEditor("NX", "NY", "NZ", true, false, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.n3Editor = new VectorEditor("NX", "NY", "NZ", true, false, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.t1Editor = new VectorEditor("U", "V", "", false, false, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.t2Editor = new VectorEditor("U", "V", "", false, false, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.t3Editor = new VectorEditor("U", "V", "", false, false, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedFace();
            }
        }, this.faceEditGroup);
        this.materialEditGroup = new UIGroup();
        new Line(uiY += 40, this.materialEditGroup);
        new Label("MATERIAL", uiY += 7, this.materialEditGroup);
        int savedUIY = uiY += 30;
        this.kaEditor = new VectorEditor("AR", "AG", "AB", true, true, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedMaterial();
            }
        }, this.materialEditGroup);
        this.kdEditor = new VectorEditor("DR", "DG", "DB", true, true, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedMaterial();
            }
        }, this.materialEditGroup);
        this.ksEditor = new VectorEditor("SR", "SG", "SB", true, true, this.width - 240 + 10, uiY += 40, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateSelectedMaterial();
            }
        }, this.materialEditGroup);
        ArrayList<String> materialNames = new ArrayList<String>();
        this.materialSelector = new DropDownList(materialNames, this.width - 240 + 10, savedUIY, 200, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.updateMaterialChoice();
            }
        }, this.materialEditGroup);
        this.materialDiffuseImage = new UIImage(this.width - 240 + 10, uiY += 40, 30, 30, this.materialEditGroup);
        this.newMaterialGroup = new UIGroup();
        new Button("Apply A Material", "m", false, null, this.width - 240 + 10, headOfGroupY, 210, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.addMaterial();
            }
        }, this.newMaterialGroup);
        this.newMaterialGroup.setVisible(false);
        this.commandBox = new TextBox("", "COMMAND", this.width - 240 + 10, this.height - 27, 220, 25, new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.executeCommand();
            }
        }, null);
        this.commandBox.anchorBottom = true;
        int windowWidth = (this.width - 240) / 2 - 5;
        int windowHeight = this.height / 2 - 5;
        this.windows.add(new Window(0, 0, windowWidth, windowHeight, 1));
        this.windows.add(new Window(windowWidth + 5, 0, windowWidth, windowHeight, 3));
        this.windows.add(new Window(0, windowHeight + 5, windowWidth, windowHeight, 2));
        this.windows.add(new Window(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight, 4));
        this.updateSelected();
        this.mode = 2;
        this.registerCommands();
        this.thread("updateUI");
        this.textSize(12.0f);
    }

    public void mouseWheel(MouseEvent event) {
        this.uiMouseWheel(event);
        for (Window w : this.windows) {
            w.mouseWheel(event);
        }
    }

    public void mouseClicked() {
        if (this.splashActive) {
            this.prefs.putBoolean("SplashSeen", true);
            this.splashActive = false;
            return;
        }
        if (!this.uiTakesMouseInput()) {
            if (this.dragWithoutPressInvalidatesClick) {
                this.dragWithoutPressInvalidatesClick = false;
                if (this.mode != 1) {
                    return;
                }
            }
            for (Window w : this.windows) {
                w.mouseClicked();
            }
        }
    }

    public void mousePressed() {
        if (!this.uiTakesMouseInput()) {
            this.dragWithoutPressInvalidatesClick = false;
            for (Window w : this.windows) {
                w.mousePressed();
            }
        }
    }

    public void mouseDragged() {
        if (!this.uiTakesMouseInput()) {
            this.dragWithoutPressInvalidatesClick = true;
            for (Window w : this.windows) {
                w.mouseDragged();
            }
        }
    }

    public void mouseReleased() {
        if (!this.uiTakesMouseInput()) {
            for (Window w : this.windows) {
                w.mouseReleased();
            }
        }
    }

    public void keyPressed() {
        if (this.key < '\u0400') {
            this.lastKeyDown[this.key] = this.keyDown[this.key];
            this.keyDown[this.key] = true;
        }
        this.lastKeyCodeDown[this.keyCode] = this.keyCodeDown[this.keyCode];
        this.keyCodeDown[this.keyCode] = true;
        if (!this.uiTakesKeyInput()) {
            for (Window w : this.windows) {
                w.keyPressed();
            }
        }
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
        if (this.key == '\uffff' && this.keyCode == 17) {
            this.ctrlPressed = true;
        }
    }

    public void keyReleased() {
        if (this.key < '\u0400') {
            this.lastKeyDown[this.key] = this.keyDown[this.key];
            this.keyDown[this.key] = false;
        }
        this.lastKeyCodeDown[this.keyCode] = this.keyCodeDown[this.keyCode];
        this.keyCodeDown[this.keyCode] = false;
        for (Window w : this.windows) {
            w.keyReleased();
        }
        if (this.key == '\uffff' && this.keyCode == 17) {
            this.ctrlPressed = false;
        }
        if (this.ctrlPressed && this.keyCode == 90) {
            this.undo();
        }
        if (this.ctrlPressed && this.keyCode == 65) {
            if (this.mode == 3) {
                int i = this.faces.size() - 1;
                while (i >= 0) {
                    Face f = this.faces.get(i);
                    f.selected = true;
                    --i;
                }
            } else {
                int i = this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = this.vertices.get(i);
                    v.selected = true;
                    --i;
                }
            }
        }
        if (this.key == '\u007f') {
            UndoRecordDeletion urd = new UndoRecordDeletion();
            int i = this.faces.size() - 1;
            while (i >= 0) {
                Face f = this.faces.get(i);
                if (f.selected || f.v1.v.selected || f.v2.v.selected || f.v3.v.selected) {
                    f.selected = false;
                    urd.addFace(f);
                    this.faces.remove(f);
                }
                --i;
            }
            i = this.vertices.size() - 1;
            while (i >= 0) {
                Vertex v = this.vertices.get(i);
                if (v.selected) {
                    v.selected = false;
                    urd.addVertex(v);
                    this.vertices.remove(v);
                }
                --i;
            }
        }
    }

    public void addFace() {
        ArrayList<Vertex> selected = new ArrayList<Vertex>();
        int i = this.vertices.size() - 1;
        while (i >= 0) {
            Vertex v = this.vertices.get(i);
            if (v.selected) {
                selected.add(v);
            }
            --i;
        }
        if (selected.size() == 3) {
            i = this.faces.size() - 1;
            while (i >= 0) {
                Face f = this.faces.get(i);
                if (selected.contains(f.v1.v) && selected.contains(f.v2.v) && selected.contains(f.v3.v)) {
                    new UndoRecordDeletion().addFace(f);
                    this.faces.remove(f);
                    return;
                }
                --i;
            }
            Face newFace = new Face((Vertex)selected.get(0), (Vertex)selected.get(1), (Vertex)selected.get(2));
            new UndoFaceAddition(newFace);
            this.faces.add(newFace);
        }
    }

    public void draw() {
        this.background(this.darkModeCheckbox.selected ? 0 : 192);
        this.ortho(-this.width / 2, this.width / 2, -this.height / 2, this.height / 2);
        for (Window w : this.windows) {
            w.draw();
            this.fill(255.0f, 0.0f, 0.0f);
            this.text(VIEW_NAMES[w.viewType], w.x, w.y + w.h - 10);
        }
        this.ortho(-this.width / 2, this.width / 2, -this.height / 2, this.height / 2);
        this.strokeWeight(2.0f);
        if (this.darkModeCheckbox.selected) {
            this.stroke(192.0f, 192.0f, 255.0f);
        } else {
            this.stroke(64.0f, 64.0f, 128.0f);
        }
        if (!this.fullScreenCheckbox.selected) {
            this.line(0.0f, this.height / 2, this.width - 240, this.height / 2);
            this.line((this.width - 240) / 2, 0.0f, (this.width - 240) / 2, this.height);
        }
        this.drawUI();
        this.drawSplash();
    }

    public Vector3f rgbToHsb(Vector3f c) {
        Vector3f r = new Vector3f();
        float V = Avalanche.max((float)Avalanche.max((float)r.x, (float)r.y), (float)r.z);
        float min = Avalanche.min((float)Avalanche.min((float)r.x, (float)r.y), (float)r.z);
        float S = V == 0.0f ? 0.0f : (V - min) / V;
        float H = 0.0f;
        H = V == r.x ? 60.0f * (c.y - c.z) / (V - min) : (V == r.y ? 60.0f * (2.0f + (c.z - c.x) / (V - min)) : 60.0f * (4.0f + (c.x - c.y) / (V - min)));
        r.x = H;
        r.y = S;
        r.z = V;
        return r;
    }

    public Vector3f hsvToRgb(Vector3f c) {
        Vector3f r = new Vector3f();
        if (c.y <= 0.0f) {
            r.x = c.z * 255.0f;
            r.y = c.z * 255.0f;
            r.z = c.z * 255.0f;
            return r;
        }
        float hh = c.x;
        if (hh >= 360.0f) {
            hh = 0.0f;
        }
        int i = (int)(hh /= 60.0f);
        float ff = hh - (float)i;
        float p = c.z * (1.0f - c.y);
        float q = c.z * (1.0f - c.y * ff);
        float t = c.z * (1.0f - c.y * (1.0f - ff));
        switch (i) {
            case 0: {
                r.x = c.z * 255.0f;
                r.y = t * 255.0f;
                r.z = p * 255.0f;
                break;
            }
            case 1: {
                r.x = q * 255.0f;
                r.y = c.z * 255.0f;
                r.z = p * 255.0f;
                break;
            }
            case 2: {
                r.x = p * 255.0f;
                r.y = c.z * 255.0f;
                r.z = t * 255.0f;
                break;
            }
            case 3: {
                r.x = p * 255.0f;
                r.y = q * 255.0f;
                r.z = c.z * 255.0f;
                break;
            }
            case 4: {
                r.x = t * 255.0f;
                r.y = p * 255.0f;
                r.z = c.z * 255.0f;
                break;
            }
            default: {
                r.x = c.z * 255.0f;
                r.y = p * 255.0f;
                r.z = q * 255.0f;
            }
        }
        return r;
    }

    public void executeCommand() {
        String c = this.commandBox.t;
        Avalanche.println((String)("'" + c + "'"));
        Thunk t = this.commands.get(c);
        if (t != null) {
            Avalanche.println((String)"go");
            t.apply();
        }
        this.commandBox.caretPos = 0;
        this.commandBox.t = "";
    }

    public void registerCommands() {
        this.registerCommand("randompoints", new Thunk(){

            @Override
            public void apply() {
                Avalanche.this.randomPoints();
            }
        });
    }

    public void registerCommand(String s, Thunk t) {
        this.commands.put(s, t);
    }

    public void randomPoints() {
        int i = 0;
        while (i < 100) {
            this.makeVertex(this.random(0.0f, 1.0f), this.random(0.0f, 1.0f), this.random(0.0f, 1.0f));
            ++i;
        }
    }

    public VertexRecord vertexHelper(String s, int startingCount, ArrayList<Vector3f> textureIndices, ArrayList<Vector3f> normals) {
        String[] subPieces = Avalanche.split((String)s, (char)'/');
        VertexRecord v1 = new VertexRecord(this.vertices.get(PApplet.parseInt((String)subPieces[0]) - 1 + startingCount));
        if (subPieces.length > 1 && subPieces[1].length() > 0) {
            v1.setTexture(textureIndices.get((int)(PApplet.parseInt((String)subPieces[1]) - 1)).x, textureIndices.get((int)(PApplet.parseInt((String)subPieces[1]) - 1)).y);
        }
        if (subPieces.length > 2 && subPieces[2].length() > 0) {
            v1.setNormal(normals.get((int)(PApplet.parseInt((String)subPieces[2]) - 1)).x, normals.get((int)(PApplet.parseInt((String)subPieces[2]) - 1)).y, normals.get((int)(PApplet.parseInt((String)subPieces[2]) - 1)).z);
        }
        return v1;
    }

    public void loadMaterials(String s) throws IOException {
        Material m = null;
        File f = new File(s);
        if (!f.exists()) {
            return;
        }
        Scanner scanner = new Scanner(f);
        String line = null;
        while (scanner.hasNextLine()) {
            line = scanner.nextLine();
            String[] pieces = Avalanche.splitTokens((String)line, (String)" ");
            int pn = 0;
            while (pn < pieces.length) {
                pieces[pn] = Avalanche.trim((String)pieces[pn]);
                ++pn;
            }
            if (pieces.length == 0) continue;
            if (pieces[0].equals("newmtl")) {
                m = new Material(pieces[1]);
                this.materials.put(m.name, m);
            }
            if (pieces[0].equals("Ka")) {
                m.Ka = new Vector3f(PApplet.parseFloat((String)pieces[1]), PApplet.parseFloat((String)pieces[2]), PApplet.parseFloat((String)pieces[3]));
            }
            if (pieces[0].equals("Kd")) {
                m.Kd = new Vector3f(PApplet.parseFloat((String)pieces[1]), PApplet.parseFloat((String)pieces[2]), PApplet.parseFloat((String)pieces[3]));
            }
            if (pieces[0].equals("Ks")) {
                m.Ks = new Vector3f(PApplet.parseFloat((String)pieces[1]), PApplet.parseFloat((String)pieces[2]), PApplet.parseFloat((String)pieces[3]));
            }
            if (!pieces[0].equals("map_Kd")) continue;
            m.texture_diffuse = this.loadImage(String.valueOf(f.getParent()) + "\\" + pieces[1]);
        }
        scanner.close();
    }

    public void openFile(final PApplet p) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {}
                MyFileChooser chooser = new MyFileChooser();
                if (chooser.showOpenDialog(((PSurfaceJOGL)p.getSurface()).getComponent()) == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    String extension = "";
                    int i = selectedFile.getAbsolutePath().lastIndexOf(46);
                    if (i > 0) {
                        extension = selectedFile.getAbsolutePath().substring(i + 1);
                    }
                    if (extension.equals("fbx")) {
                        Avalanche.this.loadFbx(selectedFile);
                    } else if (extension.equals("stl")) {
                        Avalanche.this.loadBinaryStl(selectedFile);
                    } else {
                        try {
                            Scanner scanner = new Scanner(selectedFile);
                            String line = null;
                            int startingCount = Avalanche.this.vertices.size();
                            ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
                            ArrayList<Vector3f> textureIndices = new ArrayList<Vector3f>();
                            Material curMaterial = null;
                            while (scanner.hasNextLine()) {
                                float z;
                                float y;
                                float x;
                                line = scanner.nextLine();
                                String[] pieces = Avalanche.splitTokens((String)line, (String)" ");
                                if (pieces.length == 0 || pieces[0].equals("#")) continue;
                                pieces[0].equals("o");
                                if (pieces[0].equals("mtllib")) {
                                    Avalanche.this.loadMaterials(String.valueOf(selectedFile.getParent()) + "\\" + pieces[1]);
                                }
                                if (pieces[0].equals("usemtl")) {
                                    curMaterial = Avalanche.this.materials.get(pieces[1]);
                                }
                                if (pieces[0].equals("v")) {
                                    x = PApplet.parseFloat((String)pieces[1]);
                                    y = PApplet.parseFloat((String)pieces[2]);
                                    z = PApplet.parseFloat((String)pieces[3]);
                                    Vertex v = new Vertex(x, y, z);
                                    Avalanche.this.vertices.add(v);
                                }
                                if (pieces[0].equals("vn")) {
                                    x = PApplet.parseFloat((String)pieces[1]);
                                    y = PApplet.parseFloat((String)pieces[2]);
                                    z = PApplet.parseFloat((String)pieces[3]);
                                    normals.add(new Vector3f(x, y, z));
                                }
                                if (pieces[0].equals("vt")) {
                                    x = PApplet.parseFloat((String)pieces[1]);
                                    y = PApplet.parseFloat((String)pieces[2]);
                                    textureIndices.add(new Vector3f(x, y, 0.0f));
                                }
                                if (!pieces[0].equals("f")) continue;
                                if (pieces.length == 4) {
                                    VertexRecord v1 = Avalanche.this.vertexHelper(pieces[1], startingCount, textureIndices, normals);
                                    VertexRecord v2 = Avalanche.this.vertexHelper(pieces[2], startingCount, textureIndices, normals);
                                    VertexRecord v3 = Avalanche.this.vertexHelper(pieces[3], startingCount, textureIndices, normals);
                                    Avalanche.this.faces.add(new Face(v1, v2, v3, curMaterial));
                                    continue;
                                }
                                if (pieces.length != 5) continue;
                                VertexRecord v1 = Avalanche.this.vertexHelper(pieces[1], startingCount, textureIndices, normals);
                                VertexRecord v2 = Avalanche.this.vertexHelper(pieces[2], startingCount, textureIndices, normals);
                                VertexRecord v3 = Avalanche.this.vertexHelper(pieces[3], startingCount, textureIndices, normals);
                                VertexRecord v4 = Avalanche.this.vertexHelper(pieces[4], startingCount, textureIndices, normals);
                                Avalanche.this.faces.add(new Face(v1, v2, v3, curMaterial));
                                Avalanche.this.faces.add(new Face(v1, v3, v4, curMaterial));
                            }
                            Avalanche.println((String)("read: " + Avalanche.this.vertices.size() + " , " + textureIndices.size() + " , " + normals.size()));
                            scanner.close();
                        }
                        catch (IOException e) {
                            Avalanche.print((String)("exception " + e));
                            e.printStackTrace();
                        }
                    }
                    Avalanche.this.resetMaterials();
                }
            }
        });
    }

    public String vertexRecordHelper(VertexRecord vr) {
        String result = String.valueOf(this.vertices.indexOf(vr.v) + 1);
        if (vr.hasTexture) {
            result = String.valueOf(result) + "/" + (this.curTextureIndex + 1);
            ++this.curTextureIndex;
        } else if (!vr.hasTexture && vr.hasNormal) {
            result = String.valueOf(result) + "/";
        }
        if (vr.hasNormal) {
            result = String.valueOf(result) + "/" + (this.curNormalIndex + 1);
            ++this.curNormalIndex;
        }
        return result;
    }

    public void saveFile(final PApplet p) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {}
                MyFileChooser chooser = new MyFileChooser();
                if (chooser.showSaveDialog(((PSurfaceJOGL)p.getSurface()).getComponent()) == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    String extension = "";
                    int ie = selectedFile.getAbsolutePath().lastIndexOf(46);
                    if (ie > 0) {
                        extension = selectedFile.getAbsolutePath().substring(ie + 1);
                    }
                    if (extension.equals("stl")) {
                        Avalanche.this.saveBinaryStl(selectedFile);
                    } else {
                        int i;
                        PrintWriter pw = Avalanche.this.createWriter(selectedFile.getAbsolutePath());
                        if (Avalanche.this.materials.size() > 0) {
                            String s = selectedFile.getAbsolutePath();
                            i = s.lastIndexOf(46);
                            if (i > 0) {
                                s = s.substring(0, i);
                            }
                            PrintWriter mpw = Avalanche.this.createWriter(String.valueOf(s) + ".mtl");
                            for (Material m : Avalanche.this.materials.values()) {
                                mpw.println("newmtl " + m.name);
                                mpw.println("Ka " + m.Ka.x + " " + m.Ka.y + " " + m.Ka.z);
                                mpw.println("Kd " + m.Kd.x + " " + m.Kd.y + " " + m.Kd.z);
                                mpw.println("Ks " + m.Ks.x + " " + m.Ks.y + " " + m.Ks.z);
                                if (m.texture_diffuse == null) continue;
                                String imgName = String.valueOf(s) + "_" + m.name + "_diffuse.png";
                                m.texture_diffuse.save(imgName);
                                mpw.println("map_Kd " + new File(imgName).getName());
                            }
                            mpw.flush();
                            mpw.close();
                            pw.println("mtllib " + new File(String.valueOf(s) + ".mtl").getName());
                        }
                        int i2 = 0;
                        while (i2 < Avalanche.this.vertices.size()) {
                            Vertex v = Avalanche.this.vertices.get(i2);
                            pw.println("v " + v.x + " " + v.y + " " + v.z);
                            ++i2;
                        }
                        pw.println("");
                        i2 = Avalanche.this.faces.size() - 1;
                        while (i2 >= 0) {
                            Face f = Avalanche.this.faces.get(i2);
                            if (f.v1.hasNormal) {
                                pw.println("vn " + f.v1.nx + " " + f.v1.ny + " " + f.v1.nz);
                            }
                            if (f.v2.hasNormal) {
                                pw.println("vn " + f.v2.nx + " " + f.v2.ny + " " + f.v2.nz);
                            }
                            if (f.v3.hasNormal) {
                                pw.println("vn " + f.v3.nx + " " + f.v3.ny + " " + f.v3.nz);
                            }
                            --i2;
                        }
                        pw.println("");
                        i2 = Avalanche.this.faces.size() - 1;
                        while (i2 >= 0) {
                            Face f = Avalanche.this.faces.get(i2);
                            if (f.v1.hasTexture) {
                                pw.println("vt " + f.v1.tx + " " + f.v1.ty);
                            }
                            if (f.v2.hasTexture) {
                                pw.println("vt " + f.v2.tx + " " + f.v2.ty);
                            }
                            if (f.v3.hasTexture) {
                                pw.println("vt " + f.v3.tx + " " + f.v3.ty);
                            }
                            --i2;
                        }
                        Avalanche.this.curNormalIndex = 0;
                        Avalanche.this.curTextureIndex = 0;
                        String curMatName = "";
                        i = Avalanche.this.faces.size() - 1;
                        while (i >= 0) {
                            Face f = Avalanche.this.faces.get(i);
                            if (f.m != null && !f.m.name.equals(curMatName)) {
                                curMatName = f.m.name;
                                pw.println("usemtl " + f.m.name);
                            }
                            pw.println("f " + Avalanche.this.vertexRecordHelper(f.v1) + " " + Avalanche.this.vertexRecordHelper(f.v2) + " " + Avalanche.this.vertexRecordHelper(f.v3));
                            --i;
                        }
                        pw.flush();
                        pw.close();
                    }
                }
            }
        });
    }

    public void saveBinaryStl(File f) {
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write("Armas V1.0 STL Export".getBytes());
            fos.write(new byte[59]);
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(this.faces.size());
            fos.write(bb.array());
            int i = 0;
            while (i < this.faces.size()) {
                Face fa = this.faces.get(i);
                bb = ByteBuffer.allocate(50);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.putFloat(fa.v1.hasNormal ? fa.v1.nx : 0.0f);
                bb.putFloat(fa.v1.hasNormal ? fa.v1.ny : 0.0f);
                bb.putFloat(fa.v1.hasNormal ? fa.v1.nz : 0.0f);
                bb.putFloat(fa.v1.v.x);
                bb.putFloat(fa.v1.v.y);
                bb.putFloat(fa.v1.v.z);
                bb.putFloat(fa.v2.v.x);
                bb.putFloat(fa.v2.v.y);
                bb.putFloat(fa.v2.v.z);
                bb.putFloat(fa.v3.v.x);
                bb.putFloat(fa.v3.v.y);
                bb.putFloat(fa.v3.v.z);
                bb.putShort((short)0);
                fos.write(bb.array());
                ++i;
            }
            fos.flush();
            fos.close();
        }
        catch (Exception exception) {}
    }

    public void loadBinaryStl(File f) {
        try {
            RandomAccessFile aFile = new RandomAccessFile(f.getAbsolutePath(), "r");
            FileChannel inChannel = aFile.getChannel();
            MappedByteBuffer buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inChannel.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.load();
            byte[] header = new byte[80];
            buffer.get(header);
            int numTris = buffer.getInt();
            Avalanche.println((String)("STL numTris = " + numTris));
            int i = 0;
            while (i < numTris) {
                Vector3f n = new Vector3f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
                Vertex v1 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
                Vertex v2 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
                Vertex v3 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
                buffer.getShort();
                this.vertices.add(v1);
                this.vertices.add(v2);
                this.vertices.add(v3);
                Face fa = new Face(v1, v2, v3);
                this.faces.add(fa);
                fa.v1.setNormal(n.x, n.y, n.z);
                fa.v2.setNormal(n.x, n.y, n.z);
                fa.v3.setNormal(n.x, n.y, n.z);
                ++i;
            }
            buffer.clear();
            inChannel.close();
            aFile.close();
        }
        catch (Exception exception) {}
    }

    public void loadFbx(File f) {
        try {
            RandomAccessFile aFile = new RandomAccessFile(f.getAbsolutePath(), "r");
            FileChannel inChannel = aFile.getChannel();
            MappedByteBuffer buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inChannel.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.load();
            byte[] header = new byte[23];
            buffer.get(header);
            int version = buffer.getInt();
            Avalanche.println((String)("FBX version = " + version));
            this.fbxReadNode(buffer);
            buffer.clear();
            inChannel.close();
            aFile.close();
        }
        catch (Exception exception) {}
    }

    public void fbxReadNode(ByteBuffer b) throws IOException {
        Avalanche.println((String)"NODE");
        int endOffset = b.getInt();
        int numProperties = b.getInt();
        int propertyListLen = b.getInt();
        byte nameLen = b.get();
        byte[] name = new byte[nameLen];
        b.get(name);
        Avalanche.println((String)("endOffset = " + endOffset));
        Avalanche.println((String)("numProperties = " + numProperties));
        Avalanche.println((String)("propertyListLen = " + propertyListLen));
        Avalanche.println((String)("nameLen = " + nameLen));
        Avalanche.println((String)("name = " + new String(name)));
        int i = 0;
        while (i < numProperties) {
            this.fbxReadProperty(b);
            ++i;
        }
        if (b.position() < endOffset) {
            this.fbxReadNode(b);
        }
    }

    public void fbxReadProperty(ByteBuffer b) throws IOException {
        char propertyType = b.getChar();
        Avalanche.println((char)propertyType);
        if (propertyType == 'Y') {
            short s = b.getShort();
            Avalanche.println((int)s);
        } else if (propertyType == 'C') {
            boolean boo = b.getChar() != '\u0000';
            Avalanche.println((boolean)boo);
        } else if (propertyType == 'I') {
            int i = b.getInt();
            Avalanche.println((int)i);
        } else if (propertyType == 'F') {
            float f = b.getFloat();
            Avalanche.println((float)f);
        } else if (propertyType == 'D') {
            double d = b.getDouble();
            Avalanche.println((double)d);
        } else if (propertyType == 'L') {
            long l = b.getLong();
            Avalanche.println((long)l);
        }
    }

    public Vector3f faceNormal(Face f) {
        Vector3f e1 = new Vector3f(f.v2.v.x - f.v1.v.x, f.v2.v.y - f.v1.v.y, f.v2.v.z - f.v1.v.z);
        Vector3f e2 = new Vector3f(f.v3.v.x - f.v2.v.x, f.v3.v.y - f.v2.v.y, f.v3.v.z - f.v2.v.z);
        Vector3f n = new Vector3f(e1.y * e2.z - e1.z * e2.y, e1.z * e2.x - e1.x * e2.z, e1.x * e2.y - e1.y * e2.x);
        n.normalize();
        return n;
    }

    public void toggleNormals() {
        int i = 0;
        while (i < this.faces.size()) {
            Face f = this.faces.get(i);
            if (f.selected) {
                if (f.v1.hasNormal) {
                    f.v3.hasNormal = false;
                    f.v2.hasNormal = false;
                    f.v1.hasNormal = false;
                } else {
                    Vector3f n = this.faceNormal(f);
                    f.v1.setNormal(n.x, n.y, n.z);
                    f.v2.setNormal(n.x, n.y, n.z);
                    f.v3.setNormal(n.x, n.y, n.z);
                }
            }
            ++i;
        }
    }

    public void joinVerts() {
        ArrayList<Vertex> selected = new ArrayList<Vertex>();
        this.centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
        for (Vertex v : this.vertices) {
            if (!v.selected) continue;
            selected.add(v);
            this.centerOfMass.x += v.x;
            this.centerOfMass.y += v.y;
            this.centerOfMass.z += v.z;
        }
        if (selected.size() == 0) {
            return;
        }
        this.centerOfMass.x /= (float)selected.size();
        this.centerOfMass.y /= (float)selected.size();
        this.centerOfMass.z /= (float)selected.size();
        Vertex toSave = (Vertex)selected.get(0);
        toSave.x = this.centerOfMass.x;
        toSave.y = this.centerOfMass.y;
        toSave.z = this.centerOfMass.z;
        for (Face f : this.faces) {
            if (f.v1.v.selected) {
                f.v1.v = toSave;
            }
            if (f.v2.v.selected) {
                f.v2.v = toSave;
            }
            if (!f.v3.v.selected) continue;
            f.v3.v = toSave;
        }
        for (Vertex v : selected) {
            this.vertices.remove(v);
        }
        this.vertices.add(toSave);
        this.updateSelected();
    }

    public Vertex makeVertex(float x, float y, float z) {
        Vertex result = new Vertex(x, y, z);
        this.vertices.add(result);
        return result;
    }

    public void makeCube() {
        Vertex v1 = this.makeVertex(-1.0f, -1.0f, -1.0f);
        Vertex v2 = this.makeVertex(-1.0f, -1.0f, 1.0f);
        Vertex v3 = this.makeVertex(-1.0f, 1.0f, -1.0f);
        Vertex v4 = this.makeVertex(-1.0f, 1.0f, 1.0f);
        Vertex v5 = this.makeVertex(1.0f, -1.0f, -1.0f);
        Vertex v6 = this.makeVertex(1.0f, -1.0f, 1.0f);
        Vertex v7 = this.makeVertex(1.0f, 1.0f, -1.0f);
        Vertex v8 = this.makeVertex(1.0f, 1.0f, 1.0f);
        this.faces.add(new Face(v1, v2, v3));
        this.faces.add(new Face(v2, v4, v3));
        this.faces.add(new Face(v1, v5, v6));
        this.faces.add(new Face(v1, v6, v2));
        this.faces.add(new Face(v3, v7, v8));
        this.faces.add(new Face(v3, v8, v4));
        this.faces.add(new Face(v5, v7, v6));
        this.faces.add(new Face(v6, v7, v8));
        this.faces.add(new Face(v2, v4, v6));
        this.faces.add(new Face(v4, v6, v8));
        this.faces.add(new Face(v1, v3, v5));
        this.faces.add(new Face(v3, v5, v7));
    }

    public void makeSphere() {
        Vertex b = this.makeVertex(-1.0f, 0.0f, 0.0f);
        ArrayList<Vertex> shelf = new ArrayList<Vertex>();
        int i = 0;
        while (i < 15) {
            float h = -0.96f;
            float d = Avalanche.sqrt((float)(1.0f - h * h));
            shelf.add(this.makeVertex(-0.96f, d * Avalanche.cos((float)((float)i * 2.0f * (float)Math.PI / 15.0f)), d * Avalanche.sin((float)((float)i * 2.0f * (float)Math.PI / 15.0f))));
            if (i != 0) {
                this.faces.add(new Face(b, (Vertex)shelf.get(i), (Vertex)shelf.get(i - 1)));
            }
            ++i;
        }
        this.faces.add(new Face(b, (Vertex)shelf.get(0), (Vertex)shelf.get(14)));
        ArrayList<Vertex> oldShelf = shelf;
        shelf = new ArrayList();
        int j = 0;
        while (j < 48) {
            float h = -1.0f + (float)(j + 1) * 0.04f;
            float d = Avalanche.sqrt((float)(1.0f - h * h));
            int i2 = 0;
            while (i2 < 15) {
                shelf.add(this.makeVertex(-1.0f + (float)(j + 1) * 0.04f, d * Avalanche.cos((float)((float)i2 * 2.0f * (float)Math.PI / 15.0f)), d * Avalanche.sin((float)((float)i2 * 2.0f * (float)Math.PI / 15.0f))));
                ++i2;
            }
            i2 = 0;
            while (i2 < 14) {
                this.faces.add(new Face((Vertex)oldShelf.get(i2 + 1), (Vertex)shelf.get(i2 + 1), (Vertex)oldShelf.get(i2)));
                this.faces.add(new Face((Vertex)oldShelf.get(i2), (Vertex)shelf.get(i2 + 1), (Vertex)shelf.get(i2)));
                ++i2;
            }
            this.faces.add(new Face((Vertex)oldShelf.get(14), (Vertex)oldShelf.get(0), (Vertex)shelf.get(14)));
            this.faces.add(new Face((Vertex)oldShelf.get(0), (Vertex)shelf.get(0), (Vertex)shelf.get(14)));
            oldShelf = shelf;
            shelf = new ArrayList();
            ++j;
        }
        Vertex t = this.makeVertex(1.0f, 0.0f, 0.0f);
        int i3 = 0;
        while (i3 < 15) {
            if (i3 != 0) {
                this.faces.add(new Face(t, (Vertex)oldShelf.get(i3 - 1), (Vertex)oldShelf.get(i3)));
            }
            ++i3;
        }
        this.faces.add(new Face(t, (Vertex)oldShelf.get(14), (Vertex)oldShelf.get(0)));
    }

    public void drawSplash() {
        if (this.splashActive) {
            if (this.splashImage == null) {
                this.splashImage = this.loadImage("Avalanche_Header.png");
            }
            this.fill(255.0f, 255.0f, 255.0f);
            this.stroke(92.0f, 92.0f, 92.0f);
            this.rect(this.width / 2 - this.width / 4, this.height / 2 - this.height / 4, this.width / 2, this.height / 2);
            this.image(this.splashImage, this.width / 2 - 128, this.height / 2 - this.height / 4 + 50, 256.0f, 80.0f);
            this.fill(0.0f, 0.0f, 0.0f);
            this.textSize(24.0f);
            this.text("Welcome to Avalanche 3D!", this.width / 2 - this.width / 4 + 50, this.height / 2 - this.height / 4 + 200);
            this.text("Quick Tips:", this.width / 2 - this.width / 4 + 50, this.height / 2 - this.height / 4 + 250);
            this.text("- Every button has a hotkey in the upper left", this.width / 2 - this.width / 4 + 100, this.height / 2 - this.height / 4 + 280);
            this.text("- Hold space to pan the camera", this.width / 2 - this.width / 4 + 100, this.height / 2 - this.height / 4 + 310);
            this.text("- Right mouse rotates; hold alt to rotate model", this.width / 2 - this.width / 4 + 100, this.height / 2 - this.height / 4 + 340);
            this.textSize(12.0f);
        }
    }

    public String floatToString(float f) {
        return df.format(f);
    }

    public void uiMouseWheel(MouseEvent event) {
        this.uiLastMouseWheelEvent = event;
    }

    public boolean uiTakesKeyInput() {
        if (this.splashActive) {
            return true;
        }
        int i = this.elements.size() - 1;
        while (i >= 0) {
            UIElement e = this.elements.get(i);
            if (e instanceof TextBox) {
                TextBox tb = (TextBox)e;
                if (tb.focused) {
                    return true;
                }
            }
            --i;
        }
        return false;
    }

    public boolean uiTakesMouseInput() {
        if (this.splashActive) {
            return true;
        }
        int i = this.elements.size() - 1;
        while (i >= 0) {
            ColorPicker cp;
            UIElement e = this.elements.get(i);
            if (e instanceof ColorPicker && (cp = (ColorPicker)e).takesMouseInput()) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void updateUI() {
        while (true) {
            this.curMouseWheelEvent = this.uiLastMouseWheelEvent;
            this.isMousePressed = this.mousePressed;
            this.isKeyPressed = this.keyPressed;
            int i = this.elements.size() - 1;
            while (i >= 0) {
                UIElement e = this.elements.get(i);
                e.update();
                --i;
            }
            this.wasMousePressed = this.isMousePressed;
            this.wasKeyPressed = this.isKeyPressed;
            if (this.curMouseWheelEvent == null) continue;
            this.uiLastMouseWheelEvent = null;
        }
    }

    public void drawUI() {
        this.hint(6);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(this.width - 240, 0.0f, this.width, this.height);
        int i = 0;
        while (i < this.elements.size()) {
            UIElement e = this.elements.get(i);
            e.drawIfVisible();
            ++i;
        }
    }

    public void resizeUI(float oldW, float oldH, float newW, float newH) {
        int i = this.elements.size() - 1;
        while (i >= 0) {
            UIElement e = this.elements.get(i);
            e.x = (int)((float)e.x + (newW - oldW));
            if (e.anchorBottom) {
                e.y = (int)((float)e.y + (newH - oldH));
            }
            --i;
        }
    }

    public boolean contains(float x, float y, float w, float h) {
        return (float)this.mouseX > x && (float)this.mouseX < x + w && (float)this.mouseY > y && (float)this.mouseY < y + h;
    }

    public void undo() {
        if (!this.undoRecords.empty()) {
            this.undoRecords.pop().undo();
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Avalanche"};
        if (passedArgs != null) {
            PApplet.main((String[])Avalanche.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button
    extends UIElement {
        int w;
        int h;
        String t;
        String tip;
        boolean highlight;
        Thunk onClick;
        boolean isCheckbox;
        public boolean selected;
        String group;

        Button(String tIn, String tipIn, boolean isCheckboxIn, String groupIn, int xIn, int yIn, int wIn, int hIn, Thunk onClickIn, UIGroup uigroup) {
            super(uigroup);
            this.highlight = false;
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
            this.t = tIn;
            this.tip = tipIn;
            this.onClick = onClickIn;
            this.isCheckbox = isCheckboxIn;
            this.group = groupIn;
            this.selected = false;
        }

        public void apply() {
            this.onClick.apply();
            if (this.isCheckbox) {
                this.selected = !this.selected;
            } else if (this.group != null) {
                int i = Avalanche.this.elements.size() - 1;
                while (i >= 0) {
                    UIElement e = Avalanche.this.elements.get(i);
                    if (e instanceof Button) {
                        Button b = (Button)e;
                        if (b.group != null && b.group.equals(this.group)) {
                            b.selected = false;
                        }
                    }
                    --i;
                }
                this.selected = true;
            }
        }

        @Override
        public void update() {
            if (Avalanche.this.mouseX > this.x && Avalanche.this.mouseX < this.x + this.w && Avalanche.this.mouseY > this.y && Avalanche.this.mouseY < this.y + this.h) {
                this.highlight = true;
                if (Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                    this.apply();
                }
            } else {
                this.highlight = false;
            }
            if (!Avalanche.this.uiTakesKeyInput() && Avalanche.this.wasKeyPressed && !Avalanche.this.isKeyPressed && Avalanche.this.key == this.tip.charAt(0)) {
                this.apply();
            }
        }

        @Override
        public void draw() {
            if (this.highlight) {
                Avalanche.this.fill(220.0f, 220.0f, 220.0f);
            } else {
                Avalanche.this.fill(192.0f, 192.0f, 192.0f);
            }
            Avalanche.this.stroke(0.0f, 0.0f, 0.0f);
            Avalanche.this.rect(this.x, this.y, this.w, this.h);
            if (this.selected) {
                Avalanche.this.fill(255.0f, 255.0f, 255.0f);
            } else {
                Avalanche.this.fill(0.0f, 0.0f, 0.0f);
            }
            Avalanche.this.textAlign(3, 3);
            Avalanche.this.text(this.t, this.x, this.y, this.w, this.h);
            Avalanche.this.textAlign(37, 101);
            Avalanche.this.text(this.tip, this.x + 1, this.y + 1, this.w, this.h);
        }
    }

    class Camera {
        Window w;

        Camera(Window wIn) {
            this.w = wIn;
        }

        public void keyPressed() {
        }

        public void keyReleased() {
        }

        public void mouseDragged() {
            if (Avalanche.this.mouseButton == 39) {
                if (!Avalanche.this.keyPressed || Avalanche.this.keyCode != 18) {
                    Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.w.modelViewMatrix).invert();
                    Vector3f eye = new Vector3f();
                    modelViewMatrixInvert.getTranslation(eye);
                    Vector3f forward = new Vector3f();
                    modelViewMatrixInvert.transformDirection(0.0f, 0.0f, -1.0f, forward);
                    forward.mul(2.0f);
                    eye.add((Vector3fc)forward);
                    Vector3f right = new Vector3f();
                    modelViewMatrixInvert.transformDirection(-1.0f, 0.0f, 0.0f, right);
                    Vector3f up = new Vector3f();
                    modelViewMatrixInvert.transformDirection(0.0f, -1.0f, 0.0f, up);
                    this.w.modelViewMatrix.translate(eye.x, eye.y, eye.z).rotate((this.w.selectMouseEndY - this.w.selectMouseStartY) * -0.0017452778f * 3.0f * 0.2f, (Vector3fc)right).translate(-eye.x, -eye.y, -eye.z);
                    this.w.modelViewMatrix.translate(eye.x, eye.y, eye.z).rotate((this.w.selectMouseEndX - this.w.selectMouseStartX) * -0.0017452778f * 3.0f * 0.2f, (Vector3fc)up).translate(-eye.x, -eye.y, -eye.z);
                    this.w.selectMouseStartX = this.w.selectMouseEndX;
                    this.w.selectMouseStartY = this.w.selectMouseEndY;
                } else {
                    Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.w.modelViewMatrix).invert();
                    Vector3f up = new Vector3f();
                    modelViewMatrixInvert.transformDirection(0.0f, 1.0f, 0.0f, up);
                    up.normalize(up);
                    Vector3f right = new Vector3f();
                    modelViewMatrixInvert.transformDirection(1.0f, 0.0f, 0.0f, right);
                    right.normalize(right);
                    this.w.modelViewMatrix.rotate((this.w.selectMouseEndY - this.w.selectMouseStartY) * -0.0017452778f * 3.0f, (Vector3fc)right);
                    this.w.modelViewMatrix.rotate((this.w.selectMouseEndX - this.w.selectMouseStartX) * 0.0017452778f * 3.0f, (Vector3fc)up);
                    this.w.selectMouseStartX = this.w.selectMouseEndX;
                    this.w.selectMouseStartY = this.w.selectMouseEndY;
                }
            }
        }

        public void update() {
            Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.w.modelViewMatrix).invert();
            if (Avalanche.this.keyDown[119]) {
                Vector3f forward = new Vector3f();
                modelViewMatrixInvert.transformDirection(0.0f, 0.0f, 1.0f, forward);
                forward.mul(Avalanche.this.keyCodeDown[16] ? 10.0f : 0.05f);
                this.w.modelViewMatrix.translate((Vector3fc)forward);
            }
            if (Avalanche.this.keyDown[115]) {
                Vector3f backward = new Vector3f();
                modelViewMatrixInvert.transformDirection(0.0f, 0.0f, -1.0f, backward);
                backward.mul(Avalanche.this.keyCodeDown[16] ? 10.0f : 0.05f);
                this.w.modelViewMatrix.translate((Vector3fc)backward);
            }
            if (Avalanche.this.keyDown[97]) {
                Vector3f left = new Vector3f();
                modelViewMatrixInvert.transformDirection(1.0f, 0.0f, 0.0f, left);
                left.mul(Avalanche.this.keyCodeDown[16] ? 10.0f : 0.05f);
                this.w.modelViewMatrix.translate((Vector3fc)left);
            }
            if (Avalanche.this.keyDown[100]) {
                Vector3f right = new Vector3f();
                modelViewMatrixInvert.transformDirection(-1.0f, 0.0f, 0.0f, right);
                right.mul(Avalanche.this.keyCodeDown[16] ? 10.0f : 0.05f);
                this.w.modelViewMatrix.translate((Vector3fc)right);
            }
        }

        public void pan(float x, float y) {
            Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.w.modelViewMatrix).invert();
            Vector3f up = new Vector3f();
            modelViewMatrixInvert.transformDirection(0.0f, -1.0f, 0.0f, up);
            up.mul(y * 0.002f);
            this.w.modelViewMatrix.translate((Vector3fc)up);
            Vector3f right = new Vector3f();
            modelViewMatrixInvert.transformDirection(1.0f, 0.0f, 0.0f, right);
            right.mul(x * 0.002f);
            this.w.modelViewMatrix.translate((Vector3fc)right);
        }

        public void moveForward(float amount) {
            Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.w.modelViewMatrix).invert();
            Vector3f forward = new Vector3f();
            modelViewMatrixInvert.transformDirection(0.0f, 0.0f, -1.0f, forward);
            forward.mul(amount);
            this.w.modelViewMatrix.translate((Vector3fc)forward);
        }

        public void frameModel() {
            ArrayList<Vertex> selected = new ArrayList<Vertex>();
            for (Vertex v : Avalanche.this.vertices) {
                if (!v.selected) continue;
                selected.add(v);
            }
            ArrayList<Face> selectedFaces = new ArrayList<Face>();
            for (Face f : Avalanche.this.faces) {
                if (!f.selected) continue;
                selectedFaces.add(f);
            }
            Vertex centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
            Vertex min = new Vertex(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vertex max = new Vertex(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            float scale = 1.0f;
            if (selected.size() == 0 && selectedFaces.size() == 0) {
                for (Vertex v : Avalanche.this.vertices) {
                    centerOfMass.x += v.x * (1.0f / (float)Avalanche.this.vertices.size());
                    centerOfMass.y += v.y * (1.0f / (float)Avalanche.this.vertices.size());
                    centerOfMass.z += v.z * (1.0f / (float)Avalanche.this.vertices.size());
                    min.x = Avalanche.min((float)min.x, (float)v.x);
                    min.y = Avalanche.min((float)min.y, (float)v.y);
                    min.z = Avalanche.min((float)min.z, (float)v.z);
                    max.x = Avalanche.max((float)max.x, (float)v.x);
                    max.y = Avalanche.max((float)max.y, (float)v.y);
                    max.z = Avalanche.max((float)max.z, (float)v.z);
                }
            } else if (selected.size() > 0) {
                for (Vertex v : selected) {
                    centerOfMass.x += v.x * (1.0f / (float)selected.size());
                    centerOfMass.y += v.y * (1.0f / (float)selected.size());
                    centerOfMass.z += v.z * (1.0f / (float)selected.size());
                    min.x = Avalanche.min((float)min.x, (float)v.x);
                    min.y = Avalanche.min((float)min.y, (float)v.y);
                    min.z = Avalanche.min((float)min.z, (float)v.z);
                    max.x = Avalanche.max((float)max.x, (float)v.x);
                    max.y = Avalanche.max((float)max.y, (float)v.y);
                    max.z = Avalanche.max((float)max.z, (float)v.z);
                }
            } else {
                for (Face f : Avalanche.this.faces) {
                    centerOfMass.x += f.v1.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.y += f.v1.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.z += f.v1.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                    min.x = Avalanche.min((float)min.x, (float)f.v1.v.x);
                    min.y = Avalanche.min((float)min.y, (float)f.v1.v.y);
                    min.z = Avalanche.min((float)min.z, (float)f.v1.v.z);
                    max.x = Avalanche.max((float)max.x, (float)f.v1.v.x);
                    max.y = Avalanche.max((float)max.y, (float)f.v1.v.y);
                    max.z = Avalanche.max((float)max.z, (float)f.v1.v.z);
                    centerOfMass.x += f.v2.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.y += f.v2.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.z += f.v2.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                    min.x = Avalanche.min((float)min.x, (float)f.v2.v.x);
                    min.y = Avalanche.min((float)min.y, (float)f.v2.v.y);
                    min.z = Avalanche.min((float)min.z, (float)f.v2.v.z);
                    max.x = Avalanche.max((float)max.x, (float)f.v2.v.x);
                    max.y = Avalanche.max((float)max.y, (float)f.v2.v.y);
                    max.z = Avalanche.max((float)max.z, (float)f.v2.v.z);
                    centerOfMass.x += f.v3.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.y += f.v3.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                    centerOfMass.z += f.v3.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                    min.x = Avalanche.min((float)min.x, (float)f.v3.v.x);
                    min.y = Avalanche.min((float)min.y, (float)f.v3.v.y);
                    min.z = Avalanche.min((float)min.z, (float)f.v3.v.z);
                    max.x = Avalanche.max((float)max.x, (float)f.v3.v.x);
                    max.y = Avalanche.max((float)max.y, (float)f.v3.v.y);
                    max.z = Avalanche.max((float)max.z, (float)f.v3.v.z);
                }
            }
            scale = Avalanche.max((float)(max.x - min.x), (float)Avalanche.max((float)(max.y - min.y), (float)(max.z - min.z)));
            this.w.modelViewMatrix.setLookAt(centerOfMass.x, centerOfMass.y, centerOfMass.z + 1.2f * scale, centerOfMass.x, centerOfMass.y, centerOfMass.z, 0.0f, -1.0f, 0.0f);
        }
    }

    class ColorPicker
    extends UIElement {
        Thunk valueUpdated;
        float hue;
        float saturation;
        float value;
        float r;
        float g;
        float b;

        ColorPicker(int xIn, int yIn, int rIn, int gIn, int bIn, Thunk valueUpdatedIn, UIGroup group) {
            super(group);
            this.x = xIn;
            this.y = yIn;
            if (this.y + 160 > Avalanche.this.height) {
                this.y = Avalanche.this.height - 160;
            }
            this.r = rIn;
            this.g = gIn;
            this.b = bIn;
            this.valueUpdated = valueUpdatedIn;
            this.hue = 120.0f;
            this.saturation = 0.5f;
            this.value = 0.5f;
        }

        public boolean takesMouseInput() {
            return this.visible && Avalanche.this.contains(this.x, this.y, 130.0f, 160.0f);
        }

        @Override
        public void update() {
            if (this.visible) {
                Vector3f rgb;
                Vector3f hsv;
                if (Avalanche.this.contains(this.x + 10, this.y + 5, 100.0f, 150.0f) && Avalanche.this.isMousePressed) {
                    hsv = new Vector3f(this.hue, (float)(Avalanche.this.mouseX - (this.x + 10)) / 100.0f, (float)(Avalanche.this.mouseY - (this.y + 5)) * 0.006666667f);
                    rgb = Avalanche.this.hsvToRgb(hsv);
                    this.saturation = (float)(Avalanche.this.mouseX - (this.x + 10)) / 100.0f;
                    this.value = (float)(Avalanche.this.mouseY - (this.y + 5)) * 0.006666667f;
                    this.r = rgb.x;
                    this.g = rgb.y;
                    this.b = rgb.z;
                    this.valueUpdated.apply();
                }
                if (Avalanche.this.contains(this.x + 115, this.y + 5, 10.0f, 100.0f) && Avalanche.this.isMousePressed) {
                    hsv = new Vector3f((float)(Avalanche.this.mouseY - (this.y + 5)) * 3.6f, this.saturation, this.value);
                    rgb = Avalanche.this.hsvToRgb(hsv);
                    this.hue = (float)(Avalanche.this.mouseY - (this.y + 5)) * 3.6f;
                    this.r = rgb.x;
                    this.g = rgb.y;
                    this.b = rgb.z;
                    this.valueUpdated.apply();
                }
                if (Avalanche.this.contains(this.x + 115, this.y + 145, 15.0f, 15.0f) && Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                    this.visible = false;
                }
            }
        }

        @Override
        public void draw() {
            Vector3f rgb;
            Vector3f hsv;
            Avalanche.this.fill(128.0f, 128.0f, 128.0f);
            Avalanche.this.stroke(255.0f, 255.0f, 255.0f);
            Avalanche.this.rect(this.x, this.y, 130.0f, 160.0f);
            int d = 1;
            float dw = 100 * d;
            float dh = 150 * d;
            float dxh = 10 * d;
            int s = 0;
            while ((float)s < dw) {
                int v = 0;
                while ((float)v < dh) {
                    hsv = new Vector3f(this.hue, (float)s / dw, (float)v / dh);
                    rgb = Avalanche.this.hsvToRgb(hsv);
                    Avalanche.this.set((this.x + 10) * d + s, (this.y + 5) * d + v, Avalanche.this.color(rgb.x, rgb.y, rgb.z));
                    ++v;
                }
                ++s;
            }
            int h = 0;
            while ((float)h < dw) {
                int xh = 0;
                while ((float)xh < dxh) {
                    hsv = new Vector3f((float)h * (360.0f / dw), 1.0f, 1.0f);
                    rgb = Avalanche.this.hsvToRgb(hsv);
                    Avalanche.this.set((this.x + 115) * d + xh, (this.y + 5) * d + h, Avalanche.this.color(rgb.x, rgb.y, rgb.z));
                    ++xh;
                }
                ++h;
            }
            Avalanche.this.fill(255.0f, 255.0f, 255.0f);
            Avalanche.this.stroke(0.0f, 0.0f, 0.0f);
            Avalanche.this.circle(this.x + 121, this.y + 151, 12.0f);
            Avalanche.this.line(this.x + 118, this.y + 148, this.x + 124, this.y + 154);
            Avalanche.this.line(this.x + 118, this.y + 154, this.x + 124, this.y + 148);
        }
    }

    class DropDownList
    extends UIElement {
        int w;
        int h;
        ArrayList<String> options;
        int selectedOption;
        boolean open;
        Thunk valueChanged;
        int currentTopOptionShown;

        DropDownList(ArrayList<String> optionsIn, int xIn, int yIn, int wIn, int hIn, Thunk valueChangedIn, UIGroup group) {
            super(group);
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
            this.options = optionsIn;
            this.open = false;
            this.valueChanged = valueChangedIn;
            this.selectedOption = 0;
            this.currentTopOptionShown = 0;
        }

        @Override
        public void update() {
            int s = Avalanche.min((int)this.options.size(), (int)4);
            if (Avalanche.this.mouseX > this.x && Avalanche.this.mouseX < this.x + this.w && Avalanche.this.mouseY > this.y && Avalanche.this.mouseY < this.y + this.h) {
                if (Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                    this.open = !this.open;
                }
            } else if (this.open && Avalanche.this.mouseX > this.x + 10 && Avalanche.this.mouseX < this.x + this.w - 10 && Avalanche.this.mouseY > this.y + this.h && Avalanche.this.mouseY < this.y + this.h + s * this.h) {
                if (Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                    this.currentTopOptionShown = this.selectedOption = (Avalanche.this.mouseY - (this.y + this.h)) / this.h + this.currentTopOptionShown;
                    if (this.currentTopOptionShown > this.options.size() - 4 - 1) {
                        this.currentTopOptionShown = this.options.size() - 4 - 1;
                    }
                    if (this.currentTopOptionShown < 0) {
                        this.currentTopOptionShown = 0;
                    }
                    this.open = false;
                    this.valueChanged.apply();
                } else if (Avalanche.this.curMouseWheelEvent != null) {
                    float e = Avalanche.this.curMouseWheelEvent.getCount();
                    if (e > 0.0f) {
                        ++this.currentTopOptionShown;
                        if (this.currentTopOptionShown > this.options.size() - 4 - 1) {
                            this.currentTopOptionShown = this.options.size() - 4 - 1;
                        }
                        if (this.currentTopOptionShown < 0) {
                            this.currentTopOptionShown = 0;
                        }
                    } else {
                        --this.currentTopOptionShown;
                        if (this.currentTopOptionShown < 0) {
                            this.currentTopOptionShown = 0;
                        }
                    }
                }
            } else if (Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                this.open = false;
            }
        }

        @Override
        public void draw() {
            Avalanche.this.fill(255.0f, 255.0f, 255.0f);
            Avalanche.this.stroke(0.0f, 0.0f, 0.0f);
            Avalanche.this.rect(this.x, this.y, this.w, this.h);
            Avalanche.this.fill(0.0f, 0.0f, 0.0f);
            Avalanche.this.textAlign(37, 3);
            int s = Avalanche.min((int)this.options.size(), (int)4);
            if (this.selectedOption < this.options.size()) {
                Avalanche.this.text(this.options.get(this.selectedOption), this.x + 2, this.y, this.w, this.h);
            }
            Avalanche.this.triangle(this.x + this.w - 10, this.y + 5, this.x + this.w - 4, this.y + 5, this.x + this.w - 7, this.y + 11);
            if (this.open) {
                Avalanche.this.fill(255.0f, 255.0f, 255.0f);
                Avalanche.this.rect(this.x + 10, this.y + this.h, this.w - 10, s * this.h);
                Avalanche.this.fill(0.0f, 0.0f, 0.0f);
                int i = 0;
                while (i < s) {
                    Avalanche.this.text(this.options.get(i + this.currentTopOptionShown), this.x + 12, this.y + this.h + i * this.h, this.w - 10, this.h);
                    ++i;
                }
            }
        }
    }

    class Face {
        VertexRecord v1;
        VertexRecord v2;
        VertexRecord v3;
        boolean selected;
        Material m;

        Face(Vertex inV1, Vertex inV2, Vertex inV3) {
            this.v1 = new VertexRecord(inV1);
            this.v2 = new VertexRecord(inV2);
            this.v3 = new VertexRecord(inV3);
            this.selected = false;
            this.m = null;
        }

        Face(VertexRecord inV1, VertexRecord inV2, VertexRecord inV3) {
            this.v1 = inV1;
            this.v2 = inV2;
            this.v3 = inV3;
            this.selected = false;
        }

        Face(VertexRecord inV1, VertexRecord inV2, VertexRecord inV3, Material mIn) {
            this.v1 = inV1;
            this.v2 = inV2;
            this.v3 = inV3;
            this.m = mIn;
            this.selected = false;
        }
    }

    class Label
    extends UIElement {
        String t;

        Label(String tIn, int yIn, UIGroup g) {
            super(g);
            this.y = yIn;
            this.t = tIn;
        }

        @Override
        public void draw() {
            Avalanche.this.fill(0.0f, 0.0f, 0.0f);
            Avalanche.this.text(this.t, Avalanche.this.width - 240 + 5, this.y, 240.0f, 20.0f);
        }
    }

    class Line
    extends UIElement {
        Line(int yIn, UIGroup g) {
            super(g);
            this.y = yIn;
        }

        @Override
        public void draw() {
            Avalanche.this.stroke(0.0f, 0.0f, 0.0f);
            Avalanche.this.strokeWeight(2.0f);
            Avalanche.this.line(Avalanche.this.width - 240, this.y, Avalanche.this.width, this.y);
        }
    }

    class Material {
        String name;
        Vector3f Ka;
        Vector3f Kd;
        Vector3f Ks;
        PImage texture_diffuse;

        Material(String nameIn) {
            this.name = nameIn;
            this.Ka = new Vector3f();
            this.Kd = new Vector3f();
            this.Ks = new Vector3f();
            this.texture_diffuse = null;
        }
    }

    class MyFileChooser
    extends JFileChooser {
        MyFileChooser() {
        }

        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            final JDialog dialog = super.createDialog(parent);
            dialog.setAlwaysOnTop(true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    dialog.toFront();
                }
            }, 100L);
            return dialog;
        }
    }

    class TextBox
    extends UIElement {
        int w;
        int h;
        String t;
        String label;
        public boolean focused;
        Thunk valueUpdated;
        int caretPos;

        TextBox(String tIn, String labelIn, int xIn, int yIn, int wIn, int hIn, Thunk valueUpdatedIn, UIGroup group) {
            super(group);
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
            this.t = tIn;
            this.label = labelIn;
            this.caretPos = 0;
            this.focused = false;
            this.valueUpdated = valueUpdatedIn;
        }

        @Override
        public void draw() {
            Avalanche.this.fill(192.0f, 128.0f, 128.0f);
            Avalanche.this.stroke(0.0f, 0.0f, 0.0f);
            Avalanche.this.rect(this.x, this.y, this.w, this.h);
            Avalanche.this.fill(0.0f, 0.0f, 0.0f);
            Avalanche.this.textAlign(37, 3);
            Avalanche.this.text(this.label, this.x, this.y - 22, this.w, this.h);
            Avalanche.this.text(this.t, this.x + 2, this.y, this.w, this.h);
            if (this.visible && this.focused && Avalanche.this.frameCount % 8 < 4) {
                float c = 0.0f;
                if (this.caretPos <= this.t.length()) {
                    c = Avalanche.this.textWidth(this.t.substring(0, this.caretPos));
                }
                if (c < (float)(this.w - 4)) {
                    Avalanche.this.text("_", (float)(this.x + 2) + c, this.y, this.w, this.h);
                }
            }
        }

        @Override
        public void update() {
            if (Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                if (this.visible && Avalanche.this.mouseX > this.x && Avalanche.this.mouseX < this.x + this.w && Avalanche.this.mouseY > this.y && Avalanche.this.mouseY < this.y + this.h) {
                    this.focused = true;
                    this.caretPos = this.t.length();
                } else {
                    if (this.focused) {
                        this.valueUpdated.apply();
                    }
                    this.focused = false;
                }
            }
            if (this.visible && this.focused) {
                int k = 0;
                while (k < 1024) {
                    if (Avalanche.this.keyDown[k] && !Avalanche.this.lastKeyDown[k] && k != 10 && k != 8) {
                        this.t = this.caretPos == this.t.length() ? String.valueOf(this.t) + Avalanche.this.key : String.valueOf(this.t.substring(0, this.caretPos)) + Avalanche.this.key + this.t.substring(this.caretPos, this.t.length());
                        Avalanche.this.keyDown[k] = false;
                        ++this.caretPos;
                    }
                    if (Avalanche.this.keyCodeDown[k] && !Avalanche.this.lastKeyCodeDown[k]) {
                        if (k == 9) {
                            UIElement uie;
                            int i = Avalanche.this.elements.indexOf(this);
                            if (i < Avalanche.this.elements.size() - 1 && (uie = Avalanche.this.elements.get(i + 1)) instanceof TextBox) {
                                ((TextBox)uie).focused = true;
                            }
                            this.valueUpdated.apply();
                            Avalanche.this.keyCodeDown[k] = false;
                            this.focused = false;
                        } else if (k == 10 || k == 27) {
                            this.valueUpdated.apply();
                            Avalanche.this.keyCodeDown[k] = false;
                            this.focused = false;
                        } else if (k == 37) {
                            if (this.caretPos > 0) {
                                --this.caretPos;
                            }
                            Avalanche.this.keyCodeDown[k] = false;
                        } else if (k == 39) {
                            if (this.caretPos < this.t.length()) {
                                ++this.caretPos;
                            }
                            Avalanche.this.keyCodeDown[k] = false;
                        } else if (k == 8) {
                            if (this.caretPos == this.t.length() && this.caretPos > 0) {
                                this.t = this.t.substring(0, Avalanche.max((int)0, (int)(this.t.length() - 1)));
                                --this.caretPos;
                            } else if (this.caretPos > 0) {
                                this.t = String.valueOf(this.t.substring(0, this.caretPos - 1)) + this.t.substring(this.caretPos, this.t.length());
                                --this.caretPos;
                            }
                            Avalanche.this.keyCodeDown[k] = false;
                        }
                    }
                    ++k;
                }
            }
        }
    }

    public static interface Thunk {
        public void apply();
    }

    public static interface ThunkString {
        public void apply(String var1);
    }

    class UIElement {
        int x;
        int y;
        public boolean visible = true;
        public boolean anchorBottom = false;

        UIElement() {
            Avalanche.this.elements.add(this);
        }

        UIElement(UIGroup g) {
            Avalanche.this.elements.add(this);
            if (g != null) {
                g.add(this);
            }
        }

        public void setVisible(boolean b) {
            this.visible = b;
        }

        public void update() {
        }

        public void drawIfVisible() {
            if (this.visible) {
                this.draw();
            }
        }

        public void draw() {
        }
    }

    class UIGroup
    extends UIElement {
        private ArrayList<UIElement> elements;

        UIGroup() {
            this.elements = new ArrayList();
        }

        UIGroup(UIGroup g) {
            super(g);
            this.elements = new ArrayList();
        }

        public void add(UIElement e) {
            this.elements.add(e);
        }

        @Override
        public void setVisible(boolean b) {
            int i = this.elements.size() - 1;
            while (i >= 0) {
                UIElement e = this.elements.get(i);
                e.setVisible(b);
                --i;
            }
        }
    }

    class UIImage
    extends UIElement {
        int w;
        int h;
        PImage image;

        UIImage(int xIn, int yIn, int wIn, int hIn, UIGroup group) {
            super(group);
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
        }

        @Override
        public void draw() {
            Avalanche.this.fill(228.0f, 228.0f, 228.0f);
            Avalanche.this.rect(this.x - 2, this.y - 2, this.w + 4, this.h + 4);
            if (this.image != null) {
                Avalanche.this.image(this.image, this.x, this.y, this.w, this.h);
            }
        }
    }

    class UndoFaceAddition
    extends UndoRecord {
        Face addedFace;

        UndoFaceAddition(Face f) {
            this.addedFace = f;
        }

        @Override
        public void undo() {
            Avalanche.this.faces.remove(this.addedFace);
        }
    }

    class UndoRecord {
        UndoRecord() {
            Avalanche.this.undoRecords.push(this);
        }

        public void undo() {
        }
    }

    class UndoRecordDeletion
    extends UndoRecord {
        ArrayList<Face> deletedFaces = new ArrayList();
        ArrayList<Vertex> deletedVertices = new ArrayList();

        UndoRecordDeletion() {
        }

        public void addFace(Face f) {
            this.deletedFaces.add(f);
        }

        public void addVertex(Vertex v) {
            this.deletedVertices.add(v);
        }

        @Override
        public void undo() {
            int i = 0;
            while (i < this.deletedVertices.size()) {
                Avalanche.this.vertices.add(this.deletedVertices.get(i));
                ++i;
            }
            i = 0;
            while (i < this.deletedFaces.size()) {
                Avalanche.this.faces.add(this.deletedFaces.get(i));
                ++i;
            }
        }
    }

    class UndoVertexAddition
    extends UndoRecord {
        Vertex addedVertex;

        UndoVertexAddition(Vertex v) {
            this.addedVertex = v;
        }

        @Override
        public void undo() {
            Avalanche.this.vertices.remove(this.addedVertex);
        }
    }

    class UndoVertexMovement
    extends UndoRecord {
        ArrayList<UndoVertexMovementRecord> movedVertices = new ArrayList();

        UndoVertexMovement() {
        }

        public void addVertex(Vertex v) {
            UndoVertexMovementRecord uvmr = new UndoVertexMovementRecord();
            uvmr.v = v;
            uvmr.pos = new Vector3f(v.x, v.y, v.z);
            this.movedVertices.add(uvmr);
        }

        @Override
        public void undo() {
            for (UndoVertexMovementRecord uvmr : this.movedVertices) {
                Avalanche.println((String)("undo " + uvmr.v.x + " , " + uvmr.pos.x));
                uvmr.v.x = uvmr.pos.x;
                uvmr.v.y = uvmr.pos.y;
                uvmr.v.z = uvmr.pos.z;
            }
        }
    }

    class UndoVertexMovementRecord {
        Vertex v;
        Vector3f pos;

        UndoVertexMovementRecord() {
        }
    }

    class VectorEditor
    extends UIGroup {
        TextBox x;
        TextBox y;
        TextBox z;
        ColorPicker cp;
        Thunk thunk;

        VectorEditor(String t1, String t2, String t3, boolean showZ, boolean useColorPickerIn, int xStart, int yStart, Thunk thunkIn, UIGroup group) {
            super(group);
            this.thunk = thunkIn;
            this.x = new TextBox("", t1, xStart, yStart, 63, 25, thunkIn, this);
            this.y = new TextBox("", t2, xStart + 73, yStart, 63, 25, thunkIn, this);
            if (showZ) {
                this.z = new TextBox("", t3, xStart + 73 + 73, yStart, 63, 25, thunkIn, this);
            }
            if (useColorPickerIn) {
                this.cp = new ColorPicker(xStart - 150, yStart, 255, 0, 0, new Thunk(){

                    @Override
                    public void apply() {
                        VectorEditor.this.x.t = Avalanche.this.floatToString(VectorEditor.this.cp.r / 255.0f);
                        VectorEditor.this.y.t = Avalanche.this.floatToString(VectorEditor.this.cp.g / 255.0f);
                        VectorEditor.this.z.t = Avalanche.this.floatToString(VectorEditor.this.cp.b / 255.0f);
                        VectorEditor.this.thunk.apply();
                    }
                }, this);
                this.cp.visible = false;
            }
        }

        @Override
        public void update() {
            if (Avalanche.this.contains(this.x.x + 73 + 73 + 35, this.x.y - 12, 35.0f, 10.0f) && Avalanche.this.wasMousePressed && !Avalanche.this.isMousePressed) {
                this.cp.visible = true;
            }
        }

        @Override
        public void draw() {
            if (this.cp != null) {
                Avalanche.this.stroke(255.0f, 255.0f, 255.0f);
                Avalanche.this.fill(PApplet.parseFloat((String)this.x.t) * 255.0f, PApplet.parseFloat((String)this.y.t) * 255.0f, PApplet.parseFloat((String)this.z.t) * 255.0f);
                Avalanche.this.rect(this.x.x + 73 + 73 + 35, this.x.y - 12, 35.0f, 10.0f);
            }
        }

        @Override
        public void setVisible(boolean b) {
            this.visible = b;
            this.x.setVisible(b);
            this.y.setVisible(b);
            if (this.z != null) {
                this.z.setVisible(b);
            }
        }

        public void updateText(Vector3f v) {
            this.x.t = Avalanche.this.floatToString(v.x);
            this.y.t = Avalanche.this.floatToString(v.y);
            if (this.z != null) {
                this.z.t = Avalanche.this.floatToString(v.z);
            }
        }

        public void updateValues(Vector3f v) {
            v.x = PApplet.parseFloat((String)this.x.t);
            v.y = PApplet.parseFloat((String)this.y.t);
            if (this.z != null) {
                v.z = PApplet.parseFloat((String)this.z.t);
            }
        }
    }

    class Vertex {
        float x;
        float y;
        float z;
        boolean selected;

        Vertex(float inX, float inY, float inZ) {
            this.x = inX;
            this.y = inY;
            this.z = inZ;
            this.selected = false;
        }
    }

    class VertexRecord {
        Vertex v;
        boolean hasNormal;
        boolean hasTexture;
        float nx;
        float ny;
        float nz;
        float tx;
        float ty;

        VertexRecord(Vertex vIn) {
            this.v = vIn;
            this.hasNormal = false;
            this.hasTexture = false;
        }

        public void setNormal(float inNx, float inNy, float inNz) {
            this.hasNormal = true;
            this.nx = inNx;
            this.ny = inNy;
            this.nz = inNz;
        }

        public void setTexture(float inTx, float inTy) {
            this.hasTexture = true;
            this.tx = inTx;
            this.ty = inTy;
        }
    }

    class Window {
        int viewType;
        int x;
        int y;
        int w;
        int h;
        boolean mouseInWindow;
        float mX;
        float mY;
        boolean selecting;
        float selectMouseStartX;
        float selectMouseStartY;
        float selectMouseEndX;
        float selectMouseEndY;
        Matrix4f modelViewMatrix;
        UndoVertexMovement currentUvm = null;
        PGraphics g;
        Camera c;
        Vector3f debugPoint = new Vector3f();
        Vector3f debugRayStart = new Vector3f();
        Vector3f debugRay = new Vector3f();

        Window(int xIn, int yIn, int wIn, int hIn, int viewTypeIn) {
            this.viewType = viewTypeIn;
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
            this.modelViewMatrix = new Matrix4f();
            if (this.viewType != 4) {
                this.modelViewMatrix = this.modelViewMatrix.scale(0.1f, 0.1f, 0.1f);
            } else {
                this.modelViewMatrix.setLookAt(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
            }
            this.selecting = false;
            this.g = Avalanche.this.createGraphics(this.w, this.h, "processing.opengl.PGraphics3D");
            if (this.viewType == 4) {
                this.c = new Camera(this);
            }
        }

        public void resize(int xIn, int yIn, int wIn, int hIn) {
            this.x = xIn;
            this.y = yIn;
            this.w = wIn;
            this.h = hIn;
            this.g.dispose();
            this.g = Avalanche.this.createGraphics(this.w, this.h, "processing.opengl.PGraphics3D");
        }

        public boolean processMousePosition() {
            this.mouseInWindow = Avalanche.this.mouseX >= this.x && Avalanche.this.mouseX - this.x < this.w && Avalanche.this.mouseY >= this.y && Avalanche.this.mouseY - this.y < this.h;
            this.mX = Avalanche.this.mouseX - this.x - this.w / 2;
            this.mY = Avalanche.this.mouseY - this.y - this.h / 2;
            return this.mouseInWindow;
        }

        public void mouseWheel(MouseEvent event) {
            float s;
            if (!this.processMousePosition()) {
                return;
            }
            float e = event.getCount();
            float f = s = e > 0.0f ? 1.05f : 0.952381f;
            if (Avalanche.this.keyPressed && Avalanche.this.keyCode == 16) {
                s *= 10.0f;
            }
            if (this.viewType == 4) {
                s = 0.2f;
                if (Avalanche.this.keyPressed && Avalanche.this.keyCode == 16) {
                    s *= 10.0f;
                }
                this.c.moveForward(e == 0.0f ? 0.0f : (e > 0.0f ? s : -s));
            } else if (e != 0.0f) {
                this.modelViewMatrix = this.modelViewMatrix.scale(s, s, s);
            }
        }

        public Vector3f getEyePosition() {
            PMatrix3D mat = (PMatrix3D)this.g.getMatrix();
            mat.invert();
            return new Vector3f(mat.m03, mat.m13, mat.m23);
        }

        public Vector3f unProject(float winX, float winY) {
            float x = winX / (float)(this.w / 2);
            float y = -(winY / (float)(this.h / 2));
            float z = 1.0f;
            Vector3f ray_nds = new Vector3f(x, y, z);
            PMatrix3D projection = new PMatrix3D((PMatrix)((PGraphics3D)this.g).projection);
            PMatrix3D modelview = new PMatrix3D((PMatrix)((PGraphics3D)this.g).modelview);
            PMatrix3D mvp = new PMatrix3D();
            mvp.apply(projection);
            mvp.apply(modelview);
            projection.invert();
            modelview.invert();
            float[] in = new float[]{ray_nds.x, ray_nds.y, -1.0f, 1.0f};
            float[] out = new float[4];
            projection.mult(in, out);
            Vector4f ray_eye = new Vector4f(out[0], out[1], -1.0f, 0.0f);
            float[] in2 = new float[]{ray_eye.x, ray_eye.y, ray_eye.z, ray_eye.w};
            modelview.mult(in2, out);
            Vector3f ray_wor = new Vector3f(out[0], out[1], out[2]);
            ray_wor.normalize();
            return ray_wor;
        }

        public boolean triangleContainsPointInPlane(Face f, Vector3f q, Vector3f n) {
            Vector3f e1 = new Vector3f(f.v2.v.x - f.v1.v.x, f.v2.v.y - f.v1.v.y, f.v2.v.z - f.v1.v.z);
            Vector3f e2 = new Vector3f(f.v3.v.x - f.v2.v.x, f.v3.v.y - f.v2.v.y, f.v3.v.z - f.v2.v.z);
            Vector3f e3 = new Vector3f(f.v1.v.x - f.v3.v.x, f.v1.v.y - f.v3.v.y, f.v1.v.z - f.v3.v.z);
            Vector3f c0 = new Vector3f(q.x - f.v1.v.x, q.y - f.v1.v.y, q.z - f.v1.v.z);
            Vector3f c1 = new Vector3f(q.x - f.v2.v.x, q.y - f.v2.v.y, q.z - f.v2.v.z);
            Vector3f c2 = new Vector3f(q.x - f.v3.v.x, q.y - f.v3.v.y, q.z - f.v3.v.z);
            Vector3f cp0 = new Vector3f();
            Vector3f cp1 = new Vector3f();
            Vector3f cp2 = new Vector3f();
            e1.cross((Vector3fc)c0, cp0);
            e2.cross((Vector3fc)c1, cp1);
            e3.cross((Vector3fc)c2, cp2);
            float dp0 = n.dot((Vector3fc)cp0);
            float dp1 = n.dot((Vector3fc)cp1);
            float dp2 = n.dot((Vector3fc)cp2);
            return dp0 > 0.0f && dp1 > 0.0f && dp2 > 0.0f || dp0 < 0.0f && dp1 < 0.0f && dp2 < 0.0f;
        }

        public boolean rayIntersectsTriangle(Face f, Vector3f ray, Vector3f eye, Vector3f n, Vector3f result) {
            float t = (f.v1.v.x * n.x + f.v1.v.y * n.y + f.v1.v.z * n.z - (eye.x * n.x + eye.y * n.y + eye.z * n.z)) / (ray.x * n.x + ray.y * n.y + ray.z * n.z);
            Vector3f q = new Vector3f(eye.x + ray.x * t, eye.y + ray.y * t, eye.z + ray.z * t);
            result.set((Vector3fc)q);
            this.debugPoint = q;
            boolean r = this.triangleContainsPointInPlane(f, q, n);
            return r;
        }

        public boolean rayIntersects(Face f, Vector3f result) {
            Vector3f n = Avalanche.this.faceNormal(f);
            Vector3f eye = this.getEyePosition();
            switch (this.viewType) {
                case 3: {
                    Vector3f ray = new Vector3f(1.0f, 0.0f, 0.0f);
                    Vector3f mousePos = new Vector3f(0.0f, -this.mY, this.mX);
                    mousePos = this.modelViewMatrix.transformPosition(mousePos);
                    eye.y = mousePos.y;
                    eye.z = mousePos.z;
                    return this.rayIntersectsTriangle(f, ray, eye, n, result);
                }
                case 2: {
                    Vector3f ray = new Vector3f(0.0f, 1.0f, 0.0f);
                    Vector3f mousePos = new Vector3f(this.mX, 0.0f, -this.mY);
                    mousePos = this.modelViewMatrix.transformPosition(mousePos);
                    eye.x = mousePos.x;
                    eye.z = mousePos.z;
                    return this.rayIntersectsTriangle(f, ray, eye, n, result);
                }
                case 1: {
                    Vector3f ray = new Vector3f(0.0f, 0.0f, 1.0f);
                    Vector3f mousePos = new Vector3f(-this.mX, -this.mY, 0.0f);
                    mousePos = this.modelViewMatrix.transformPosition(mousePos);
                    eye.x = mousePos.x;
                    eye.y = mousePos.y;
                    return this.rayIntersectsTriangle(f, ray, eye, n, result);
                }
                case 4: {
                    Vector3f pointOnScreen = this.unProject(this.selectMouseStartX, this.selectMouseStartY);
                    Vector3f ray = new Vector3f(pointOnScreen.x, pointOnScreen.y, pointOnScreen.z);
                    ray.normalize();
                    return this.rayIntersectsTriangle(f, ray, eye, n, result);
                }
            }
            return false;
        }

        public void mouseClicked() {
            if (!this.processMousePosition()) {
                return;
            }
            if (Avalanche.this.mode == 3) {
                Face f;
                if (this.viewType == 4) {
                    this.g.perspective(1.0471976f, (float)this.w / (float)this.h, 0.01f, 10000.0f);
                    this.g.resetMatrix();
                    this.g.applyMatrix(this.modelViewMatrix.m00(), this.modelViewMatrix.m10(), this.modelViewMatrix.m20(), this.modelViewMatrix.m30(), this.modelViewMatrix.m01(), this.modelViewMatrix.m11(), this.modelViewMatrix.m21(), this.modelViewMatrix.m31(), this.modelViewMatrix.m02(), this.modelViewMatrix.m12(), this.modelViewMatrix.m22(), this.modelViewMatrix.m32(), this.modelViewMatrix.m03(), this.modelViewMatrix.m13(), this.modelViewMatrix.m23(), this.modelViewMatrix.m33());
                }
                Vector3f eye = this.getEyePosition();
                Face closestIntersection = null;
                Vector3f result = new Vector3f();
                float curMinDistance = Float.MAX_VALUE;
                int i = Avalanche.this.faces.size() - 1;
                while (i >= 0) {
                    float d;
                    f = Avalanche.this.faces.get(i);
                    if (this.rayIntersects(f, result) && (d = result.distance((Vector3fc)eye)) < curMinDistance) {
                        curMinDistance = d;
                        closestIntersection = f;
                    }
                    --i;
                }
                if (Avalanche.this.keyPressed && Avalanche.this.keyCode == 16) {
                    if (closestIntersection != null) {
                        closestIntersection.selected = true;
                    }
                } else if (Avalanche.this.keyPressed && Avalanche.this.keyCode == 17) {
                    if (closestIntersection != null) {
                        closestIntersection.selected = false;
                    }
                } else {
                    i = Avalanche.this.faces.size() - 1;
                    while (i >= 0) {
                        f = Avalanche.this.faces.get(i);
                        f.selected = false;
                        --i;
                    }
                    if (closestIntersection != null) {
                        closestIntersection.selected = true;
                    }
                }
                Avalanche.this.updateSelected();
            } else if (Avalanche.this.mode == 2) {
                this.selectMouseStartX -= 3.0f;
                this.selectMouseStartY -= 3.0f;
                this.selectMouseEndX += 3.0f;
                this.selectMouseEndY += 3.0f;
                if (this.viewType == 4) {
                    this.g.perspective(1.0471976f, (float)this.w / (float)this.h, 0.01f, 10000.0f);
                    this.g.resetMatrix();
                    this.g.applyMatrix(this.modelViewMatrix.m00(), this.modelViewMatrix.m10(), this.modelViewMatrix.m20(), this.modelViewMatrix.m30(), this.modelViewMatrix.m01(), this.modelViewMatrix.m11(), this.modelViewMatrix.m21(), this.modelViewMatrix.m31(), this.modelViewMatrix.m02(), this.modelViewMatrix.m12(), this.modelViewMatrix.m22(), this.modelViewMatrix.m32(), this.modelViewMatrix.m03(), this.modelViewMatrix.m13(), this.modelViewMatrix.m23(), this.modelViewMatrix.m33());
                }
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (this.selectHelper(v) || Avalanche.this.keyPressed && Avalanche.this.keyCode == 16 && v.selected) {
                        v.selected = !Avalanche.this.keyPressed || Avalanche.this.keyCode != 17;
                    } else if (!Avalanche.this.keyPressed || Avalanche.this.keyCode != 17) {
                        v.selected = false;
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
            } else if (Avalanche.this.mode == 1) {
                switch (this.viewType) {
                    case 3: {
                        Vector3f mousePos = new Vector3f(0.0f, -this.mY, this.mX);
                        mousePos = this.modelViewMatrix.transformPosition(mousePos);
                        if (Avalanche.this.snapToGridCheckbox.selected) {
                            mousePos.y = (float)Avalanche.round((float)(mousePos.y / 5.0f)) * 5.0f;
                            mousePos.z = (float)Avalanche.round((float)(mousePos.z / 5.0f)) * 5.0f;
                        }
                        Vertex newVertex = new Vertex(0.0f, mousePos.y, mousePos.z);
                        Avalanche.this.vertices.add(newVertex);
                        new UndoVertexAddition(newVertex);
                        break;
                    }
                    case 2: {
                        Vector3f mousePos = new Vector3f(this.mX, 0.0f, -this.mY);
                        mousePos = this.modelViewMatrix.transformPosition(mousePos);
                        if (Avalanche.this.snapToGridCheckbox.selected) {
                            mousePos.x = (float)Avalanche.round((float)(mousePos.x / 5.0f)) * 5.0f;
                            mousePos.z = (float)Avalanche.round((float)(mousePos.z / 5.0f)) * 5.0f;
                        }
                        Vertex newVertex = new Vertex(mousePos.x, 0.0f, mousePos.z);
                        Avalanche.this.vertices.add(newVertex);
                        new UndoVertexAddition(newVertex);
                        break;
                    }
                    case 1: {
                        Vector3f mousePos = new Vector3f(-this.mX, -this.mY, 0.0f);
                        mousePos = this.modelViewMatrix.transformPosition(mousePos);
                        if (Avalanche.this.snapToGridCheckbox.selected) {
                            mousePos.x = (float)Avalanche.round((float)(mousePos.x / 5.0f)) * 5.0f;
                            mousePos.y = (float)Avalanche.round((float)(mousePos.y / 5.0f)) * 5.0f;
                        }
                        Vertex newVertex = new Vertex(mousePos.x, mousePos.y, 0.0f);
                        Avalanche.this.vertices.add(newVertex);
                        new UndoVertexAddition(newVertex);
                        break;
                    }
                }
            }
        }

        public void mousePressed() {
            if (!this.processMousePosition()) {
                return;
            }
            if (Avalanche.this.mouseButton == 37) {
                if (Avalanche.this.mode == 2 || Avalanche.this.mode == 3) {
                    this.selecting = true;
                } else if (Avalanche.this.mode != 4) {
                    // empty if block
                }
            }
            this.selectMouseStartX = this.mX;
            this.selectMouseStartY = this.mY;
            this.selectMouseEndX = this.mX;
            this.selectMouseEndY = this.mY;
        }

        public float getScaleFactor(float start, float end) {
            float diff = end - start;
            float baseScale = 1.0f;
            if (diff > 0.0f) {
                baseScale = Avalanche.pow((float)1.001f, (float)diff);
            } else if (diff < 0.0f) {
                baseScale = 1.0f / Avalanche.pow((float)1.001f, (float)(-diff));
            }
            return baseScale;
        }

        public void mouseDragged() {
            if (!this.processMousePosition()) {
                return;
            }
            this.selectMouseEndX = this.mX;
            this.selectMouseEndY = this.mY;
            Vector3f scale = new Vector3f();
            this.modelViewMatrix.getScale(scale);
            float gridOffsetX = 0.0f;
            float gridOffsetY = 0.0f;
            if (this.viewType == 4) {
                this.c.mouseDragged();
            }
            if (Avalanche.this.keyPressed && Avalanche.this.key == ' ') {
                switch (this.viewType) {
                    case 3: {
                        this.modelViewMatrix = this.modelViewMatrix.translate(0.0f, this.selectMouseEndY - this.selectMouseStartY, -(this.selectMouseEndX - this.selectMouseStartX));
                        break;
                    }
                    case 2: {
                        this.modelViewMatrix = this.modelViewMatrix.translate(-(this.selectMouseEndX - this.selectMouseStartX), 0.0f, this.selectMouseEndY - this.selectMouseStartY);
                        break;
                    }
                    case 1: {
                        this.modelViewMatrix = this.modelViewMatrix.translate(this.selectMouseEndX - this.selectMouseStartX, this.selectMouseEndY - this.selectMouseStartY, 0.0f);
                        break;
                    }
                    case 4: {
                        this.c.pan(this.selectMouseEndX - this.selectMouseStartX, -(this.selectMouseEndY - this.selectMouseStartY));
                    }
                }
                this.selectMouseStartX = this.selectMouseEndX;
                this.selectMouseStartY = this.selectMouseEndY;
                this.selecting = false;
            } else if (Avalanche.this.mode == 4) {
                boolean needsAdding;
                boolean bl = needsAdding = this.currentUvm == null;
                if (needsAdding) {
                    this.currentUvm = new UndoVertexMovement();
                }
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (v.selected) {
                        if (needsAdding) {
                            this.currentUvm.addVertex(v);
                        }
                        switch (this.viewType) {
                            case 3: {
                                v.z += (this.selectMouseEndX - this.selectMouseStartX) * scale.z;
                                v.y -= (this.selectMouseEndY - this.selectMouseStartY) * scale.z;
                                if (!Avalanche.this.snapToGridCheckbox.selected) break;
                                float vGY = (float)Avalanche.round((float)(v.y / 5.0f)) * 5.0f;
                                float vGZ = (float)Avalanche.round((float)(v.z / 5.0f)) * 5.0f;
                                gridOffsetX = v.z - vGZ;
                                gridOffsetY = -(v.y - vGY);
                                v.y = vGY;
                                v.z = vGZ;
                                break;
                            }
                            case 2: {
                                v.x += (this.selectMouseEndX - this.selectMouseStartX) * scale.z;
                                v.z -= (this.selectMouseEndY - this.selectMouseStartY) * scale.z;
                                if (!Avalanche.this.snapToGridCheckbox.selected) break;
                                float vGX = (float)Avalanche.round((float)(v.x / 5.0f)) * 5.0f;
                                float vGZ = (float)Avalanche.round((float)(v.z / 5.0f)) * 5.0f;
                                gridOffsetX = v.x - vGX;
                                gridOffsetY = -(v.z - vGZ);
                                v.x = vGX;
                                v.z = vGZ;
                                break;
                            }
                            case 1: {
                                v.x -= (this.selectMouseEndX - this.selectMouseStartX) * scale.z;
                                v.y -= (this.selectMouseEndY - this.selectMouseStartY) * scale.z;
                                if (!Avalanche.this.snapToGridCheckbox.selected) break;
                                float vGX = (float)Avalanche.round((float)(v.x / 5.0f)) * 5.0f;
                                float vGY = (float)Avalanche.round((float)(v.y / 5.0f)) * 5.0f;
                                gridOffsetX = -(v.x - vGX);
                                gridOffsetY = -(v.y - vGY);
                                v.x = vGX;
                                v.y = vGY;
                                break;
                            }
                        }
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
                this.selectMouseStartX = this.selectMouseEndX - gridOffsetX / scale.z;
                this.selectMouseStartY = this.selectMouseEndY - gridOffsetY / scale.z;
            } else if (Avalanche.this.mode == 7) {
                Avalanche.println((String)"hi1");
                for (Vertex v : Avalanche.this.vertices) {
                    if (!v.selected) continue;
                    switch (this.viewType) {
                        case 3: {
                            Vector3f ve = new Vector3f(v.x, v.y, v.z);
                            ve.rotateX(-(this.selectMouseStartX - this.selectMouseEndX + (this.selectMouseEndY - this.selectMouseStartY)) * scale.z * 0.1f);
                            v.x = ve.x;
                            v.y = ve.y;
                            v.z = ve.z;
                            break;
                        }
                        case 2: {
                            Vector3f ve = new Vector3f(v.x, v.y, v.z);
                            ve.rotateY(-(this.selectMouseStartX - this.selectMouseEndX + (this.selectMouseEndY - this.selectMouseStartY)) * scale.z * 0.1f);
                            v.x = ve.x;
                            v.y = ve.y;
                            v.z = ve.z;
                            break;
                        }
                        case 1: {
                            Vector3f ve = new Vector3f(v.x, v.y, v.z);
                            ve.rotateZ(-(this.selectMouseStartX - this.selectMouseEndX + (this.selectMouseEndY - this.selectMouseStartY)) * scale.z * 0.1f);
                            v.x = ve.x;
                            v.y = ve.y;
                            v.z = ve.z;
                            break;
                        }
                    }
                }
                this.selectMouseStartX = this.selectMouseEndX;
                this.selectMouseStartY = this.selectMouseEndY;
            } else if (Avalanche.this.mode == 6) {
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (v.selected) {
                        switch (this.viewType) {
                            case 3: {
                                float baseScaleZ = this.getScaleFactor(this.selectMouseStartX, this.selectMouseEndX);
                                float baseScaleY = this.getScaleFactor(this.selectMouseEndY, this.selectMouseStartY);
                                if (Avalanche.this.ctrlPressed) {
                                    if (Avalanche.abs((float)(this.selectMouseStartX - this.selectMouseEndX)) > Avalanche.abs((float)(this.selectMouseStartY - this.selectMouseEndY))) {
                                        baseScaleY = 1.0f;
                                    } else {
                                        baseScaleZ = 1.0f;
                                    }
                                }
                                if (Avalanche.this.centerOfMassCheckbox.selected) {
                                    v.y = Avalanche.this.centerOfMass.y + (v.y - Avalanche.this.centerOfMass.y) * baseScaleY;
                                    v.z = Avalanche.this.centerOfMass.z + (v.z - Avalanche.this.centerOfMass.z) * baseScaleZ;
                                    break;
                                }
                                v.y *= baseScaleY;
                                v.z *= baseScaleZ;
                                break;
                            }
                            case 2: {
                                float baseScaleX = this.getScaleFactor(this.selectMouseStartX, this.selectMouseEndX);
                                float baseScaleZ = this.getScaleFactor(this.selectMouseEndY, this.selectMouseStartY);
                                if (Avalanche.this.ctrlPressed) {
                                    if (Avalanche.abs((float)(this.selectMouseStartX - this.selectMouseEndX)) > Avalanche.abs((float)(this.selectMouseStartY - this.selectMouseEndY))) {
                                        baseScaleX = 1.0f;
                                    } else {
                                        baseScaleZ = 1.0f;
                                    }
                                }
                                if (Avalanche.this.centerOfMassCheckbox.selected) {
                                    v.x = Avalanche.this.centerOfMass.x + (v.x - Avalanche.this.centerOfMass.x) * baseScaleX;
                                    v.z = Avalanche.this.centerOfMass.z + (v.z - Avalanche.this.centerOfMass.z) * baseScaleZ;
                                    break;
                                }
                                v.x *= baseScaleX;
                                v.z *= baseScaleZ;
                                break;
                            }
                            case 1: {
                                float baseScaleX = this.getScaleFactor(this.selectMouseStartX, this.selectMouseEndX);
                                float baseScaleY = this.getScaleFactor(this.selectMouseEndY, this.selectMouseStartY);
                                if (Avalanche.this.ctrlPressed) {
                                    if (Avalanche.abs((float)(this.selectMouseStartX - this.selectMouseEndX)) > Avalanche.abs((float)(this.selectMouseStartY - this.selectMouseEndY))) {
                                        baseScaleX = 1.0f;
                                    } else {
                                        baseScaleY = 1.0f;
                                    }
                                }
                                if (Avalanche.this.centerOfMassCheckbox.selected) {
                                    v.x = Avalanche.this.centerOfMass.x + (v.x - Avalanche.this.centerOfMass.x) * baseScaleX;
                                    v.y = Avalanche.this.centerOfMass.y + (v.y - Avalanche.this.centerOfMass.y) * baseScaleY;
                                    break;
                                }
                                v.x *= baseScaleX;
                                v.y *= baseScaleY;
                                break;
                            }
                        }
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
                this.selectMouseStartX = this.selectMouseEndX - gridOffsetX / scale.z;
                this.selectMouseStartY = this.selectMouseEndY - gridOffsetY / scale.z;
            } else if (Avalanche.this.mode == 5) {
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (v.selected) {
                        switch (this.viewType) {
                            case 1: 
                            case 2: 
                            case 3: {
                                float baseScale = this.getScaleFactor(this.selectMouseStartX, this.selectMouseEndX);
                                if (Avalanche.this.centerOfMassCheckbox.selected) {
                                    v.x = Avalanche.this.centerOfMass.x + (v.x - Avalanche.this.centerOfMass.x) * baseScale;
                                    v.y = Avalanche.this.centerOfMass.y + (v.y - Avalanche.this.centerOfMass.y) * baseScale;
                                    v.z = Avalanche.this.centerOfMass.z + (v.z - Avalanche.this.centerOfMass.z) * baseScale;
                                    break;
                                }
                                v.x *= baseScale;
                                v.y *= baseScale;
                                v.z *= baseScale;
                                break;
                            }
                        }
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
                this.selectMouseStartX = this.selectMouseEndX - gridOffsetX / scale.z;
                this.selectMouseStartY = this.selectMouseEndY - gridOffsetY / scale.z;
            }
        }

        public boolean between(float v, float x1, float x2) {
            return v > x1 && v < x2 || v < x1 && v > x2;
        }

        public boolean selectHelper(Face f) {
            switch (this.viewType) {
                case 3: {
                    Vector3f startPos = new Vector3f(0.0f, -this.selectMouseStartY, this.selectMouseStartX);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(0.0f, -this.selectMouseEndY, this.selectMouseEndX);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(f.v1.v.y, startPos.y, endPos.y) && this.between(f.v1.v.z, startPos.z, endPos.z) && this.between(f.v2.v.y, startPos.y, endPos.y) && this.between(f.v2.v.z, startPos.z, endPos.z) && this.between(f.v3.v.y, startPos.y, endPos.y) && this.between(f.v3.v.z, startPos.z, endPos.z);
                }
                case 2: {
                    Vector3f startPos = new Vector3f(this.selectMouseStartX, 0.0f, -this.selectMouseStartY);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(this.selectMouseEndX, 0.0f, -this.selectMouseEndY);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(f.v1.v.x, startPos.x, endPos.x) && this.between(f.v1.v.z, startPos.z, endPos.z) && this.between(f.v2.v.x, startPos.x, endPos.x) && this.between(f.v2.v.z, startPos.z, endPos.z) && this.between(f.v3.v.x, startPos.x, endPos.x) && this.between(f.v3.v.z, startPos.z, endPos.z);
                }
                case 1: {
                    Vector3f startPos = new Vector3f(-this.selectMouseStartX, -this.selectMouseStartY, 0.0f);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(-this.selectMouseEndX, -this.selectMouseEndY, 0.0f);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(f.v1.v.x, startPos.x, endPos.x) && this.between(f.v1.v.y, startPos.y, endPos.y) && this.between(f.v2.v.x, startPos.x, endPos.x) && this.between(f.v2.v.y, startPos.y, endPos.y) && this.between(f.v3.v.x, startPos.x, endPos.x) && this.between(f.v3.v.y, startPos.y, endPos.y);
                }
                case 4: {
                    if (!Avalanche.this.selectBackFacingCheckbox.selected) {
                        Vector3f n = Avalanche.this.faceNormal(f);
                        Vector3f pointOnScreen = this.unProject(this.selectMouseStartX, this.selectMouseStartY);
                        Vector3f ray = new Vector3f(pointOnScreen.x, pointOnScreen.y, pointOnScreen.z);
                        ray.normalize();
                        Avalanche.println((String)("v = " + (ray.x * n.x + ray.y * n.y + ray.z * n.z)));
                        if (ray.x * n.x + ray.y * n.y + ray.z * n.z > 0.0f) {
                            return false;
                        }
                    }
                    float vX1 = this.g.screenX(f.v1.v.x, f.v1.v.y, f.v1.v.z) - (float)(this.w / 2);
                    float vY1 = this.g.screenY(f.v1.v.x, f.v1.v.y, f.v1.v.z) - (float)(this.h / 2);
                    float vX2 = this.g.screenX(f.v2.v.x, f.v2.v.y, f.v2.v.z) - (float)(this.w / 2);
                    float vY2 = this.g.screenY(f.v2.v.x, f.v2.v.y, f.v2.v.z) - (float)(this.h / 2);
                    float vX3 = this.g.screenX(f.v3.v.x, f.v3.v.y, f.v3.v.z) - (float)(this.w / 2);
                    float vY3 = this.g.screenY(f.v3.v.x, f.v3.v.y, f.v3.v.z) - (float)(this.h / 2);
                    return this.between(vX1, this.selectMouseStartX, this.selectMouseEndX) && this.between(vY1, this.selectMouseStartY, this.selectMouseEndY) && this.between(vX2, this.selectMouseStartX, this.selectMouseEndX) && this.between(vY2, this.selectMouseStartY, this.selectMouseEndY) && this.between(vX3, this.selectMouseStartX, this.selectMouseEndX) && this.between(vY3, this.selectMouseStartY, this.selectMouseEndY);
                }
            }
            return false;
        }

        public boolean selectHelper(Vertex v) {
            switch (this.viewType) {
                case 3: {
                    Vector3f startPos = new Vector3f(0.0f, -this.selectMouseStartY, this.selectMouseStartX);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(0.0f, -this.selectMouseEndY, this.selectMouseEndX);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(v.y, startPos.y, endPos.y) && this.between(v.z, startPos.z, endPos.z);
                }
                case 2: {
                    Vector3f startPos = new Vector3f(this.selectMouseStartX, 0.0f, -this.selectMouseStartY);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(this.selectMouseEndX, 0.0f, -this.selectMouseEndY);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(v.x, startPos.x, endPos.x) && this.between(v.z, startPos.z, endPos.z);
                }
                case 1: {
                    Vector3f startPos = new Vector3f(-this.selectMouseStartX, -this.selectMouseStartY, 0.0f);
                    startPos = this.modelViewMatrix.transformPosition(startPos);
                    Vector3f endPos = new Vector3f(-this.selectMouseEndX, -this.selectMouseEndY, 0.0f);
                    endPos = this.modelViewMatrix.transformPosition(endPos);
                    return this.between(v.x, startPos.x, endPos.x) && this.between(v.y, startPos.y, endPos.y);
                }
                case 4: {
                    float vX = this.g.screenX(v.x, v.y, v.z) - (float)(this.w / 2);
                    float vY = this.g.screenY(v.x, v.y, v.z) - (float)(this.h / 2);
                    return this.between(vX, this.selectMouseStartX, this.selectMouseEndX) && this.between(vY, this.selectMouseStartY, this.selectMouseEndY);
                }
            }
            return false;
        }

        public void mouseReleased() {
            this.currentUvm = null;
            if (!this.processMousePosition()) {
                return;
            }
            if (this.selecting && Avalanche.this.mode == 2) {
                if (this.viewType == 4) {
                    this.g.perspective(1.0471976f, (float)this.w / (float)this.h, 0.01f, 10000.0f);
                    this.g.resetMatrix();
                    this.g.applyMatrix(this.modelViewMatrix.m00(), this.modelViewMatrix.m10(), this.modelViewMatrix.m20(), this.modelViewMatrix.m30(), this.modelViewMatrix.m01(), this.modelViewMatrix.m11(), this.modelViewMatrix.m21(), this.modelViewMatrix.m31(), this.modelViewMatrix.m02(), this.modelViewMatrix.m12(), this.modelViewMatrix.m22(), this.modelViewMatrix.m32(), this.modelViewMatrix.m03(), this.modelViewMatrix.m13(), this.modelViewMatrix.m23(), this.modelViewMatrix.m33());
                }
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (this.selectHelper(v) || Avalanche.this.keyPressed && Avalanche.this.keyCode == 16 && v.selected) {
                        v.selected = !Avalanche.this.keyPressed || Avalanche.this.keyCode != 17;
                    } else if (!Avalanche.this.keyPressed || Avalanche.this.keyCode != 17) {
                        v.selected = false;
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
            } else if (this.selecting && Avalanche.this.mode == 3) {
                if (this.viewType == 4) {
                    this.g.perspective(1.0471976f, (float)this.w / (float)this.h, 0.01f, 10000.0f);
                    this.g.resetMatrix();
                    this.g.applyMatrix(this.modelViewMatrix.m00(), this.modelViewMatrix.m10(), this.modelViewMatrix.m20(), this.modelViewMatrix.m30(), this.modelViewMatrix.m01(), this.modelViewMatrix.m11(), this.modelViewMatrix.m21(), this.modelViewMatrix.m31(), this.modelViewMatrix.m02(), this.modelViewMatrix.m12(), this.modelViewMatrix.m22(), this.modelViewMatrix.m32(), this.modelViewMatrix.m03(), this.modelViewMatrix.m13(), this.modelViewMatrix.m23(), this.modelViewMatrix.m33());
                }
                int i = Avalanche.this.faces.size() - 1;
                while (i >= 0) {
                    Face f = Avalanche.this.faces.get(i);
                    if (this.selectHelper(f) || Avalanche.this.keyPressed && Avalanche.this.keyCode == 16 && f.selected) {
                        f.selected = !Avalanche.this.keyPressed || Avalanche.this.keyCode != 17;
                    } else if (!Avalanche.this.keyPressed || Avalanche.this.keyCode != 17) {
                        f.selected = false;
                    }
                    --i;
                }
                Avalanche.this.updateSelected();
            }
            this.selecting = false;
        }

        public void keyPressed() {
            if (!this.processMousePosition()) {
                return;
            }
            if (this.viewType == 4) {
                this.c.keyPressed();
            }
        }

        public void keyReleased() {
            if (!this.processMousePosition()) {
                return;
            }
            if (this.viewType == 4) {
                this.c.keyReleased();
                if (Avalanche.this.key == '`') {
                    this.c.frameModel();
                }
            } else if (Avalanche.this.key == '`') {
                ArrayList<Vertex> selected = new ArrayList<Vertex>();
                for (Vertex v : Avalanche.this.vertices) {
                    if (!v.selected) continue;
                    selected.add(v);
                }
                ArrayList<Face> selectedFaces = new ArrayList<Face>();
                for (Face f : Avalanche.this.faces) {
                    if (!f.selected) continue;
                    selectedFaces.add(f);
                }
                Vertex centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
                Vertex min = new Vertex(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
                Vertex max = new Vertex(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
                float scale = 1.0f;
                if (selected.size() == 0 && selectedFaces.size() == 0) {
                    Avalanche.println((String)"hi1");
                    for (Vertex v : Avalanche.this.vertices) {
                        centerOfMass.x += v.x * (1.0f / (float)Avalanche.this.vertices.size());
                        centerOfMass.y += v.y * (1.0f / (float)Avalanche.this.vertices.size());
                        centerOfMass.z += v.z * (1.0f / (float)Avalanche.this.vertices.size());
                        min.x = Avalanche.min((float)min.x, (float)v.x);
                        min.y = Avalanche.min((float)min.y, (float)v.y);
                        min.z = Avalanche.min((float)min.z, (float)v.z);
                        max.x = Avalanche.max((float)max.x, (float)v.x);
                        max.y = Avalanche.max((float)max.y, (float)v.y);
                        max.z = Avalanche.max((float)max.z, (float)v.z);
                    }
                } else if (selected.size() > 0) {
                    Avalanche.println((String)"hi2");
                    for (Vertex v : selected) {
                        centerOfMass.x += v.x * (1.0f / (float)selected.size());
                        centerOfMass.y += v.y * (1.0f / (float)selected.size());
                        centerOfMass.z += v.z * (1.0f / (float)selected.size());
                        min.x = Avalanche.min((float)min.x, (float)v.x);
                        min.y = Avalanche.min((float)min.y, (float)v.y);
                        min.z = Avalanche.min((float)min.z, (float)v.z);
                        max.x = Avalanche.max((float)max.x, (float)v.x);
                        max.y = Avalanche.max((float)max.y, (float)v.y);
                        max.z = Avalanche.max((float)max.z, (float)v.z);
                    }
                } else {
                    Avalanche.println((String)"hi3");
                    for (Face f : Avalanche.this.faces) {
                        centerOfMass.x += f.v1.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.y += f.v1.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.z += f.v1.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                        min.x = Avalanche.min((float)min.x, (float)f.v1.v.x);
                        min.y = Avalanche.min((float)min.y, (float)f.v1.v.y);
                        min.z = Avalanche.min((float)min.z, (float)f.v1.v.z);
                        max.x = Avalanche.max((float)max.x, (float)f.v1.v.x);
                        max.y = Avalanche.max((float)max.y, (float)f.v1.v.y);
                        max.z = Avalanche.max((float)max.z, (float)f.v1.v.z);
                        centerOfMass.x += f.v2.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.y += f.v2.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.z += f.v2.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                        min.x = Avalanche.min((float)min.x, (float)f.v2.v.x);
                        min.y = Avalanche.min((float)min.y, (float)f.v2.v.y);
                        min.z = Avalanche.min((float)min.z, (float)f.v2.v.z);
                        max.x = Avalanche.max((float)max.x, (float)f.v2.v.x);
                        max.y = Avalanche.max((float)max.y, (float)f.v2.v.y);
                        max.z = Avalanche.max((float)max.z, (float)f.v2.v.z);
                        centerOfMass.x += f.v3.v.x * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.y += f.v3.v.y * (0.33333334f / (float)Avalanche.this.faces.size());
                        centerOfMass.z += f.v3.v.z * (0.33333334f / (float)Avalanche.this.faces.size());
                        min.x = Avalanche.min((float)min.x, (float)f.v3.v.x);
                        min.y = Avalanche.min((float)min.y, (float)f.v3.v.y);
                        min.z = Avalanche.min((float)min.z, (float)f.v3.v.z);
                        max.x = Avalanche.max((float)max.x, (float)f.v3.v.x);
                        max.y = Avalanche.max((float)max.y, (float)f.v3.v.y);
                        max.z = Avalanche.max((float)max.z, (float)f.v3.v.z);
                    }
                }
                scale = Avalanche.max((float)(max.x - min.x), (float)Avalanche.max((float)(max.y - min.y), (float)(max.z - min.z)));
                if (scale < 0.5f) {
                    scale = 0.5f;
                }
                this.modelViewMatrix = new Matrix4f();
                if (this.viewType == 3) {
                    this.modelViewMatrix.translate(0.0f, centerOfMass.y, centerOfMass.z);
                } else if (this.viewType == 2) {
                    this.modelViewMatrix.translate(centerOfMass.x, 0.0f, centerOfMass.z);
                } else if (this.viewType == 1) {
                    this.modelViewMatrix.translate(centerOfMass.x, centerOfMass.y, 0.0f);
                }
                this.modelViewMatrix.scale(0.1f * scale * 0.05f, 0.1f * scale * 0.05f, 0.1f * scale * 0.05f);
            }
        }

        public void drawGrid() {
            Vector3f scale = new Vector3f();
            this.modelViewMatrix.getScale(scale);
            this.g.strokeWeight(0.5f * scale.z);
            if (Avalanche.this.darkModeCheckbox.selected) {
                this.g.stroke(92.0f, 92.0f, 92.0f);
            } else {
                this.g.stroke(0.0f, 0.0f, 0.0f);
            }
            Vector3f zero = new Vector3f();
            zero = this.modelViewMatrix.transformPosition(zero);
            int gridStartX = (int)(zero.x / 5.0f);
            gridStartX = (int)((float)gridStartX * 5.0f);
            int gridStartY = (int)(zero.y / 5.0f);
            gridStartY = (int)((float)gridStartY * 5.0f);
            int wG = (int)((float)((int)((float)this.w / 5.0f)) * 5.0f);
            int hG = (int)((float)((int)((float)this.h / 5.0f)) * 5.0f);
            switch (this.viewType) {
                case 3: {
                    int x = (int)(-5.0f - (float)wG);
                    while ((float)x < (float)wG + 5.0f) {
                        this.g.line(0.0f, (float)(gridStartX + x), -5.0f + (float)gridStartY - (float)hG, 0.0f, (float)(gridStartX + x), (float)(hG + gridStartY) + 5.0f);
                        x = (int)((float)x + 5.0f);
                    }
                    int y = (int)(-5.0f - (float)hG);
                    while ((float)y < (float)hG + 5.0f) {
                        this.g.line(0.0f, -5.0f + (float)gridStartX - (float)wG, (float)(gridStartY + y), 0.0f, (float)(wG + gridStartX) + 5.0f, (float)(gridStartY + y));
                        y = (int)((float)y + 5.0f);
                    }
                    break;
                }
                case 2: {
                    int x = (int)(-5.0f - (float)wG);
                    while ((float)x < (float)wG + 5.0f) {
                        this.g.line((float)(gridStartX + x), 0.0f, -5.0f + (float)gridStartY - (float)hG, (float)(gridStartX + x), 0.0f, (float)(hG + gridStartY) + 5.0f);
                        x = (int)((float)x + 5.0f);
                    }
                    int y = (int)(-5.0f - (float)hG);
                    while ((float)y < (float)hG + 5.0f) {
                        this.g.line(-5.0f + (float)gridStartX - (float)wG, 0.0f, (float)(gridStartY + y), (float)(wG + gridStartX) + 5.0f, 0.0f, (float)(gridStartY + y));
                        y = (int)((float)y + 5.0f);
                    }
                    break;
                }
                case 1: {
                    int x = (int)(-5.0f - (float)wG);
                    while ((float)x < (float)wG + 5.0f) {
                        this.g.line((float)(gridStartX + x), -5.0f + (float)gridStartY - (float)hG, 0.0f, (float)(gridStartX + x), (float)(hG + gridStartY) + 5.0f, 0.0f);
                        x = (int)((float)x + 5.0f);
                    }
                    int y = (int)(-5.0f - (float)hG);
                    while ((float)y < (float)hG + 5.0f) {
                        this.g.line(-5.0f + (float)gridStartX - (float)wG, (float)(gridStartY + y), 0.0f, (float)(wG + gridStartX) + 5.0f, (float)(gridStartY + y), 0.0f);
                        y = (int)((float)y + 5.0f);
                    }
                    break;
                }
            }
        }

        public void draw() {
            Face f;
            if (this.w <= 0 || this.h <= 0) {
                return;
            }
            if (this.viewType == 4) {
                this.c.update();
            }
            Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
            if (this.viewType != 4) {
                this.modelViewMatrix.getScale(scale);
            }
            this.g.beginDraw();
            this.g.pushMatrix();
            this.g.background(Avalanche.this.darkModeCheckbox.selected ? 0 : 192);
            if (this.viewType == 1) {
                this.g.ortho((float)(-this.w / 2), (float)(this.w / 2), (float)(-this.h / 2), (float)(this.h / 2), -10000.0f, 10000.0f);
                this.g.camera(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
            } else if (this.viewType == 2) {
                this.g.ortho((float)(-this.w / 2), (float)(this.w / 2), (float)(-this.h / 2), (float)(this.h / 2), -10000.0f, 10000.0f);
                this.g.camera(0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
            } else if (this.viewType == 3) {
                this.g.ortho((float)(-this.w / 2), (float)(this.w / 2), (float)(-this.h / 2), (float)(this.h / 2), -10000.0f, 10000.0f);
                this.g.camera(10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
            } else if (this.viewType == 4) {
                this.g.perspective(1.0471976f, (float)this.w / (float)this.h, 0.01f, 10000.0f);
                this.g.resetMatrix();
                this.g.applyMatrix(this.modelViewMatrix.m00(), this.modelViewMatrix.m10(), this.modelViewMatrix.m20(), this.modelViewMatrix.m30(), this.modelViewMatrix.m01(), this.modelViewMatrix.m11(), this.modelViewMatrix.m21(), this.modelViewMatrix.m31(), this.modelViewMatrix.m02(), this.modelViewMatrix.m12(), this.modelViewMatrix.m22(), this.modelViewMatrix.m32(), this.modelViewMatrix.m03(), this.modelViewMatrix.m13(), this.modelViewMatrix.m23(), this.modelViewMatrix.m33());
            }
            if (this.viewType != 4) {
                Matrix4f modelViewMatrixInvert = new Matrix4f((Matrix4fc)this.modelViewMatrix).invert();
                this.g.applyMatrix(modelViewMatrixInvert.m00(), modelViewMatrixInvert.m10(), modelViewMatrixInvert.m20(), modelViewMatrixInvert.m30(), modelViewMatrixInvert.m01(), modelViewMatrixInvert.m11(), modelViewMatrixInvert.m21(), modelViewMatrixInvert.m31(), modelViewMatrixInvert.m02(), modelViewMatrixInvert.m12(), modelViewMatrixInvert.m22(), modelViewMatrixInvert.m32(), modelViewMatrixInvert.m03(), modelViewMatrixInvert.m13(), modelViewMatrixInvert.m23(), modelViewMatrixInvert.m33());
            }
            this.g.beginShape(5);
            this.g.strokeWeight(1.0f * scale.z);
            this.g.stroke(255.0f, 0.0f, 0.0f);
            this.g.vertex(0.0f, 0.0f, 0.0f);
            this.g.vertex(5.0f, 0.0f, 0.0f);
            this.g.stroke(0.0f, 255.0f, 0.0f);
            this.g.vertex(0.0f, 0.0f, 0.0f);
            this.g.vertex(0.0f, 5.0f, 0.0f);
            this.g.stroke(0.0f, 0.0f, 255.0f);
            this.g.vertex(0.0f, 0.0f, 0.0f);
            this.g.vertex(0.0f, 0.0f, 5.0f);
            this.g.endShape();
            this.drawGrid();
            if (!Avalanche.this.saveNextDraw && Avalanche.this.showVerticesCheckbox.selected) {
                this.g.strokeCap(4);
                this.g.strokeWeight(5.0f * scale.z);
                this.g.beginShape(3);
                int i = Avalanche.this.vertices.size() - 1;
                while (i >= 0) {
                    Vertex v = Avalanche.this.vertices.get(i);
                    if (v.selected) {
                        this.g.stroke(255.0f, 0.0f, 0.0f);
                        this.g.fill(255.0f, 0.0f, 0.0f);
                    } else if (Avalanche.this.darkModeCheckbox.selected) {
                        this.g.stroke(255.0f, 255.0f, 255.0f);
                        this.g.fill(255.0f, 255.0f, 255.0f);
                    } else {
                        this.g.stroke(0.0f, 0.0f, 0.0f);
                        this.g.fill(0.0f, 0.0f, 0.0f);
                    }
                    this.g.vertex(v.x, v.y, v.z);
                    --i;
                }
                this.g.endShape();
            }
            if (Avalanche.this.saveNextDraw) {
                Avalanche.this.beginRaw("processing.dxf.RawDXF", "output.dxf");
            }
            if (Avalanche.this.showEdgesCheckbox.selected) {
                this.g.strokeWeight(1.0f * scale.z);
                if (Avalanche.this.darkModeCheckbox.selected) {
                    this.g.stroke(255.0f, 255.0f, 255.0f);
                } else {
                    this.g.stroke(0.0f, 0.0f, 0.0f);
                }
            } else {
                this.g.noStroke();
            }
            this.g.beginShape(9);
            if (Avalanche.this.showLightingCheckbox.selected) {
                this.g.lights();
            }
            PImage curTexture = null;
            this.g.textureMode(1);
            int i = Avalanche.this.faces.size() - 1;
            while (i >= 0) {
                f = Avalanche.this.faces.get(i);
                if (Avalanche.this.darkModeCheckbox.selected) {
                    this.g.fill(128.0f, 128.0f, 128.0f);
                    this.g.ambient(255.0f, 255.0f, 255.0f);
                    this.g.specular(255.0f, 255.0f, 255.0f);
                } else {
                    this.g.fill(64.0f, 64.0f, 64.0f);
                    this.g.ambient(64.0f, 64.0f, 64.0f);
                    this.g.specular(192.0f, 192.0f, 192.0f);
                }
                if (f.m != null) {
                    this.g.ambient(255.0f * f.m.Ka.x, 255.0f * f.m.Ka.y, 255.0f * f.m.Ka.z);
                    this.g.fill(255.0f * f.m.Kd.x, 255.0f * f.m.Kd.y, 255.0f * f.m.Kd.z);
                    this.g.specular(255.0f * f.m.Ks.x, 255.0f * f.m.Ks.y, 255.0f * f.m.Ks.z);
                }
                if (Avalanche.this.showEdgesCheckbox.selected) {
                    this.g.strokeWeight(1.0f * scale.z);
                    if (f.selected) {
                        this.g.stroke(255.0f, 0.0f, 0.0f);
                    } else if (Avalanche.this.darkModeCheckbox.selected) {
                        this.g.stroke(255.0f, 255.0f, 255.0f);
                    } else {
                        this.g.stroke(0.0f, 0.0f, 0.0f);
                    }
                } else {
                    this.g.noStroke();
                }
                if (f.selected) {
                    this.g.fill(255.0f, 0.0f, 0.0f);
                    this.g.ambient(255.0f, 0.0f, 0.0f);
                    this.g.specular(255.0f, 0.0f, 0.0f);
                }
                if (f.v1.hasNormal) {
                    this.g.normal(f.v1.nx, f.v1.ny, f.v1.nz);
                }
                if (!Avalanche.this.showFacesCheckbox.selected) {
                    this.g.noFill();
                }
                if (Avalanche.this.showTexturesCheckbox.selected && f.v1.hasTexture) {
                    if (f.m != null && curTexture != f.m.texture_diffuse) {
                        curTexture = f.m.texture_diffuse;
                        this.g.endShape();
                        this.g.beginShape(9);
                        this.g.texture(f.m.texture_diffuse);
                    } else if (f.m == null && curTexture != null) {
                        curTexture = null;
                        this.g.endShape();
                        this.g.beginShape(9);
                        this.g.texture(null);
                    }
                    this.g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z, f.v1.tx, f.v1.ty);
                } else {
                    this.g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z);
                }
                if (f.v2.hasNormal) {
                    this.g.normal(f.v2.nx, f.v2.ny, f.v2.nz);
                }
                if (Avalanche.this.showTexturesCheckbox.selected && f.v2.hasTexture) {
                    this.g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z, f.v2.tx, f.v2.ty);
                } else {
                    this.g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z);
                }
                if (f.v3.hasNormal) {
                    this.g.normal(f.v3.nx, f.v3.ny, f.v3.nz);
                }
                if (Avalanche.this.showTexturesCheckbox.selected && f.v3.hasTexture) {
                    this.g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z, f.v3.tx, f.v3.ty);
                } else {
                    this.g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z);
                }
                --i;
            }
            this.g.endShape();
            if (Avalanche.this.showNormalsCheckbox.selected) {
                this.g.beginShape(5);
                i = Avalanche.this.faces.size() - 1;
                while (i >= 0) {
                    f = Avalanche.this.faces.get(i);
                    if (f.v1.hasNormal) {
                        this.g.stroke(255.0f, 0.0f, 0.0f);
                        this.g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z);
                        this.g.vertex(f.v1.v.x + f.v1.nx * 0.2f, f.v1.v.y + f.v1.ny * 0.2f, f.v1.v.z + f.v1.nz * 0.2f);
                    }
                    if (f.v2.hasNormal) {
                        this.g.stroke(255.0f, 0.0f, 0.0f);
                        this.g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z);
                        this.g.vertex(f.v2.v.x + f.v2.nx * 0.2f, f.v2.v.y + f.v2.ny * 0.2f, f.v2.v.z + f.v2.nz * 0.2f);
                    }
                    if (f.v3.hasNormal) {
                        this.g.stroke(255.0f, 0.0f, 0.0f);
                        this.g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z);
                        this.g.vertex(f.v3.v.x + f.v3.nx * 0.2f, f.v3.v.y + f.v3.ny * 0.2f, f.v3.v.z + f.v3.nz * 0.2f);
                    }
                    --i;
                }
                this.g.endShape();
            }
            if (Avalanche.this.saveNextDraw) {
                Avalanche.this.endRaw();
                Avalanche.this.saveNextDraw = false;
            }
            if (this.selecting) {
                this.g.stroke(255.0f, 255.0f, 255.0f);
                this.g.ambient(255.0f, 255.0f, 255.0f);
                this.g.specular(255.0f, 255.0f, 255.0f);
                this.g.fill(255.0f, 228.0f, 228.0f, 92.0f);
                this.g.pushMatrix();
                this.g.resetMatrix();
                this.g.ortho((float)(-this.w / 2), (float)(this.w / 2), (float)(-this.h / 2), (float)(this.h / 2), -10000.0f, 10000.0f);
                this.g.camera(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                Vector3f startPos = new Vector3f(this.selectMouseStartX, this.selectMouseStartY, -10000.0f);
                Vector3f endPos = new Vector3f(this.selectMouseEndX, this.selectMouseEndY, -10000.0f);
                this.g.hint(2);
                this.g.rect(startPos.x, startPos.y, endPos.x - startPos.x, endPos.y - startPos.y);
                this.g.hint(-2);
                this.g.popMatrix();
            }
            this.g.popMatrix();
            this.g.fill(255.0f, 255.0f, 255.0f);
            this.g.stroke(255.0f, 255.0f, 255.0f);
            this.g.endDraw();
            Avalanche.this.image((PImage)this.g, this.x, this.y);
        }
    }
}

