/* autogenerated by Processing revision 1293 on 2025-11-29 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import Jama.*;
import Jama.examples.*;
import Jama.test.*;
import Jama.util.*;
import org.joml.*;
import org.joml.sampling.*;
import org.joml.internal.*;

import java.util.*;
import java.util.prefs.Preferences;
import org.joml.*;
import java.awt.*;
import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.Scanner;
import javax.swing.*;
import java.text.DecimalFormat;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class Avalanche extends PApplet {





ArrayList<Vertex> vertices;
ArrayList<Face> faces;
ArrayList<Window> windows;
HashMap<String, Material> materials;
Button snapToGridCheckbox;
Button showVerticesCheckbox;
Button centerOfMassCheckbox;
Button darkModeCheckbox;
Vertex centerOfMass;
Vertex singleSelectedVertex;
Face singleSelectedFace;
Button showEdgesCheckbox, showFacesCheckbox, showLightingCheckbox, showNormalsCheckbox, showTexturesCheckbox, selectBackFacingCheckbox, fullScreenCheckbox;
UIImage materialDiffuseImage;
UIGroup vertexEditGroup, multipleVertexEditGroup, faceEditGroup, materialEditGroup, newMaterialGroup;
VectorEditor vEditor;
VectorEditor n1Editor, n2Editor, n3Editor;
VectorEditor t1Editor, t2Editor, t3Editor;
VectorEditor kaEditor, kdEditor, ksEditor;
TextBox commandBox;
Label editLabel;
DropDownList materialSelector;
int mode;
boolean saveNextDraw;
float oldWidth, oldHeight;
boolean ctrlPressed = false;

//This is here to keep the UI from reporting press, drag, release, click - we don't want the click at the end
boolean dragWithoutPressInvalidatesClick = false;

boolean keyDown[];
boolean lastKeyDown[];
boolean keyCodeDown[];
boolean lastKeyCodeDown[];
  
Preferences prefs;

public void resetMaterials() {
  ArrayList<String> materialNames = new ArrayList<String>();
  Iterator<Material> v = materials.values().iterator();
  while(v.hasNext()) {
    Material vm = v.next();
    materialNames.add(vm.name);
  }
  materialSelector.options = materialNames;
  materialSelector.selectedOption = 0;
}

public void clearSelected() {
  for (int i = vertices.size()-1; i >= 0; i--) {
    Vertex v = vertices.get(i);
    v.selected = false;
  }
  for (int i = faces.size()-1; i >= 0; i--) {
    Face f = faces.get(i);
    f.selected = false;
  }
}

public void updateSelected() {
  ArrayList<Vertex> selected = new ArrayList<Vertex>();
  centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
  for (int i = vertices.size()-1; i >= 0; i--) {
    Vertex v = vertices.get(i);
    if(v.selected) {
      selected.add(v);
      centerOfMass.x += v.x;
      centerOfMass.y += v.y;
      centerOfMass.z += v.z;
      vEditor.updateText(new Vector3f(v.x, v.y, v.z));
    }
  }
  ArrayList<Face> selectedFaces = new ArrayList<Face>();
  for (int i = faces.size() - 1; i >= 0; i--) {
    Face f = faces.get(i);
    if(f.selected) {
      selectedFaces.add(f);
      n1Editor.updateText(new Vector3f(f.v1.nx, f.v1.ny, f.v1.nz));
      n2Editor.updateText(new Vector3f(f.v2.nx, f.v2.ny, f.v2.nz));
      n3Editor.updateText(new Vector3f(f.v3.nx, f.v3.ny, f.v3.nz));
      t1Editor.updateText(new Vector3f(f.v1.tx, f.v1.ty, 0.0f));
      t2Editor.updateText(new Vector3f(f.v2.tx, f.v2.ty, 0.0f));
      t3Editor.updateText(new Vector3f(f.v3.tx, f.v3.ty, 0.0f));
      if(f.m != null) {
        kaEditor.updateText(f.m.Ka);
        kdEditor.updateText(f.m.Kd);
        ksEditor.updateText(f.m.Ks);
        materialDiffuseImage.image = f.m.texture_diffuse;
      }
    }
  }
  centerOfMass.x /= selected.size();
  centerOfMass.y /= selected.size();
  centerOfMass.z /= selected.size();
  multipleVertexEditGroup.setVisible(false);
  vertexEditGroup.setVisible(false);
  faceEditGroup.setVisible(false);
  materialEditGroup.setVisible(false);
  newMaterialGroup.setVisible(false);
  if(selected.size() == 1) {
    singleSelectedVertex = selected.get(0);
    vertexEditGroup.setVisible(true);
  }
  if(selected.size() > 0) {
    multipleVertexEditGroup.setVisible(true);
  }
  boolean allSelectedFacesHaveNoMaterial = true;
  boolean allSelectedFacesHaveSameMaterial = true;
  Material jointMaterial = null;
  if(selectedFaces.size() == 0) {
    allSelectedFacesHaveNoMaterial = false;
    allSelectedFacesHaveSameMaterial = false;
  } else {
    singleSelectedFace = selectedFaces.get(0);
    for(Face f: selectedFaces) {
      if(f.m != null) {
        allSelectedFacesHaveNoMaterial = false;
        if(jointMaterial == null) {
          jointMaterial = f.m;
        } else if (jointMaterial != f.m) {
          allSelectedFacesHaveSameMaterial = false;
        }
      } else {
        allSelectedFacesHaveSameMaterial = false;
      }
    }
  }
  if(allSelectedFacesHaveNoMaterial) {
    newMaterialGroup.setVisible(true);
  } else if(allSelectedFacesHaveSameMaterial) {
    if(singleSelectedFace.m != null) {
      materialEditGroup.setVisible(true);
      materialSelector.selectedOption = materialSelector.options.indexOf(singleSelectedFace.m.name);
    }
  }
  if(selectedFaces.size() == 1) {
    if(singleSelectedFace.v1.hasNormal) {
      n1Editor.setVisible(true);
      n2Editor.setVisible(true);
      n3Editor.setVisible(true);
    }
    if(singleSelectedFace.v1.hasTexture) {
      t1Editor.setVisible(true);
      t2Editor.setVisible(true);
      t3Editor.setVisible(true);
    }
  }
}

public void updateSelectedVertexPosition() {
  Vertex v = singleSelectedVertex;
  if(v.selected) {
    Vector3f vec = new Vector3f();
    vEditor.updateValues(vec);
    v.x = vec.x; v.y = vec.y; v.z = vec.z;
  }
}

public void updateMaterialChoice() {
  for(Face f: faces) {
    if(f.selected) {
      f.m = materials.get(materialSelector.options.get(materialSelector.selectedOption));
    }
  }
}

public void updateSelectedMaterial() {
  Face f = singleSelectedFace;
  if(f.selected) {
    Material m = f.m;
    if(m != null) {
      kaEditor.updateValues(singleSelectedFace.m.Ka);
      kdEditor.updateValues(singleSelectedFace.m.Kd);
      ksEditor.updateValues(singleSelectedFace.m.Ks);
    }
  }
}
    
public void updateSelectedFace() {
  Face f = singleSelectedFace;
  if(f.selected) {
    Vector3f vec = new Vector3f();
    n1Editor.updateValues(vec);
    f.v1.nx = vec.x; f.v1.ny = vec.y; f.v1.nz = vec.z;
    n2Editor.updateValues(vec);
    f.v2.nx = vec.x; f.v2.ny = vec.y; f.v2.nz = vec.z;
    n3Editor.updateValues(vec);
    f.v3.nx = vec.x; f.v3.ny = vec.y; f.v3.nz = vec.z;
    t1Editor.updateValues(vec);
    f.v1.tx = vec.x; f.v1.ty = vec.y;
    t2Editor.updateValues(vec);
    f.v2.tx = vec.x; f.v2.ty = vec.y;
    t3Editor.updateValues(vec);
    f.v3.tx = vec.x; f.v3.ty = vec.y;
      
  }
}
public void pre() {
  if((oldWidth != width) || (oldHeight != height)) {
    resizeUI(oldWidth, oldHeight, width, height);
      
    int windowWidth = (width - UI_COLUMN_WIDTH) / 2 - 5;
    int windowHeight = height / 2 - 5;
    windows.get(0).resize(0, 0, windowWidth, windowHeight);
    windows.get(1).resize(windowWidth + 5, 0, windowWidth, windowHeight);
    windows.get(2).resize(0, windowHeight + 5, windowWidth, windowHeight);
    windows.get(3).resize(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight);    
       
    oldWidth = width;
    oldHeight = height;
  }
}

public void settings() {
  if((displayWidth > 1920) && (displayHeight > 1080)) {
    size(1920, 1080, P3D);
    oldWidth = 1920;
    oldHeight = 1080;
  } else {
    size(1280, 1024, P3D);
    oldWidth = 1280;
    oldHeight = 1024;
  }
  //pixelDensity(displayDensity());
  
  PJOGL.setIcon("Avalanche_Icon.png");
}  

public void toggleFullScreen() {
  if(!fullScreenCheckbox.selected) { //transition to full 3D      
    int windowWidth = (width - UI_COLUMN_WIDTH) - 5;
    int windowHeight = height - 5;
    for(Window w : windows) {
      if(w.viewType == VIEW_3D) {
        w.resize(0, 0, windowWidth, windowHeight);
      } else {
        w.resize(0, 0, 0, 0);
      }
    }
  } else { //transition away
  int windowWidth = (width - UI_COLUMN_WIDTH) / 2 - 5;
    int windowHeight = height / 2 - 5;
    windows.get(0).resize(0, 0, windowWidth, windowHeight);
    windows.get(1).resize(windowWidth + 5, 0, windowWidth, windowHeight);
    windows.get(2).resize(0, windowHeight + 5, windowWidth, windowHeight);
    windows.get(3).resize(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight);           
  }
}

public void addMaterial() {
  //Use the first material
  for(Face f: faces) {
    if(f.selected) {
      if(materials.size() == 0) {
        f.m = new Material("Avalanche1");
        materials.put(f.m.name, f.m);
        resetMaterials();
      } else { 
        Iterator<Material> v = materials.values().iterator();
        f.m = v.next();    
      }
      Vector3f n = faceNormal(f);
      f.v1.setNormal(n.x, n.y, n.z);
      f.v2.setNormal(n.x, n.y, n.z);
      f.v3.setNormal(n.x, n.y, n.z);
      f.v1.setTexture(0.0f, 0.0f);
      f.v2.setTexture(0.0f, 1.0f);
      f.v3.setTexture(1.0f, 0.0f);
    }
  }
  updateSelected();
}

public void setup() {
  prefs = Preferences.userRoot().node(this.getClass().getName());
  if(prefs.getBoolean("SplashSeen", false)) {
    splashActive = false;
  }
  surface.setTitle("Avalanche 3D Editor");  
  frameRate(30);
  surface.setResizable(true);
  
  registerMethod ("pre", this ) ;
  
  vertices = new ArrayList<Vertex>();
  faces = new ArrayList<Face>();
  windows = new ArrayList<Window>();
  materials = new HashMap<String, Material>();
  
  keyDown = new boolean[1024];
  keyCodeDown = new boolean[1024];
  lastKeyDown = new boolean[1024];
  lastKeyCodeDown = new boolean[1024];
  
  int uiY = 10; //Starting value
  
  final PApplet myThis = this;
  
  new Button("Open", "o", false, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { openFile(myThis); } }, null );
  new Button("Save", "p", false, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { saveFile(myThis); } }, null );
  uiY += UI_BUTTON_HEIGHT;
  uiY += UI_BUTTON_BETWEEN;
  new Line(uiY, null);
  uiY += UI_BUTTON_BETWEEN;
  new Button("Place", "1", false, "Mode",  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { mode = MODE_PLACE; } }, null );
  new Button("Select Vertex", "2", false, "Mode",  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { clearSelected(); mode = MODE_SELECT_VERTEX; } }, null ).selected = true;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Button("Select Face", "3", false, "Mode",  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { clearSelected(); mode = MODE_SELECT_FACE; } }, null );
  new Button("Move", "4", false, "Mode",  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { mode = MODE_MOVE; } }, null );
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Button("Scale (All)", "5", false, "Mode",  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { mode = MODE_SCALE_ALL; } }, null );
  new Button("Scale", "6", false, "Mode",  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { mode = MODE_SCALE; } }, null );
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Button("Rotate", "7", false, "Mode",  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { mode = MODE_ROTATE; } }, null );
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Line(uiY, null);
  uiY += UI_BUTTON_BETWEEN;  
  snapToGridCheckbox = new Button("Snap To Grid", "g", true, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  centerOfMassCheckbox = new Button("Center of Mass", "h", true, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  centerOfMassCheckbox.selected = true;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  darkModeCheckbox = new Button("Dark Mode", "i", true, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  darkModeCheckbox.selected = true;
  selectBackFacingCheckbox = new Button("Back Facing", "o", true, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  selectBackFacingCheckbox.selected = true;  
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  fullScreenCheckbox = new Button("3D Only", "=", true, null, width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { toggleFullScreen(); } }, null );
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  
  new Line(uiY, null);
  uiY += UI_BUTTON_BETWEEN;  
  new Label("SHOW", uiY, null);
  uiY += UI_BUTTON_TEXT;  
  
  showVerticesCheckbox = new Button("Vertices", "z", true, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showVerticesCheckbox.selected = true;
  showEdgesCheckbox = new Button("Edges", "x", true, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showEdgesCheckbox.selected = true;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  showFacesCheckbox = new Button("Faces", "c", true, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showFacesCheckbox.selected = true;
  showLightingCheckbox = new Button("Light", "v", true, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showLightingCheckbox.selected = true;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  showNormalsCheckbox = new Button("Normals", "b", true, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showNormalsCheckbox.selected = true;
  showTexturesCheckbox = new Button("Texture", "n", true, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { } }, null );
  showTexturesCheckbox.selected = true;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Line(uiY, null);
  uiY += UI_BUTTON_BETWEEN;  
  
  new Button("Face", "f", false, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  addFace(); } }, null );
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Button("Cube", "/", false, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  makeCube(); } }, null );
  new Button("Sphere", ".", false, null,  width - UI_COLUMN_WIDTH + 10 + 110, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  makeSphere(); } }, null );  
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Button("Toggle Normal", "\\", false, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  toggleNormals(); } }, null ); 
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN;
  new Line(uiY, null);
  uiY += UI_BUTTON_BETWEEN;  
  editLabel = new Label("EDIT", uiY, null);
  uiY += UI_BUTTON_TEXT + UI_BUTTON_TEXT; 
  
  int headOfGroupY =  uiY;
  vertexEditGroup = new UIGroup();
  multipleVertexEditGroup = new UIGroup();
  new Button("Join Verts", "j", false, null,  width - UI_COLUMN_WIDTH + 10, uiY, 100, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  joinVerts(); } }, multipleVertexEditGroup ); 
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_BETWEEN + UI_BUTTON_BETWEEN;  
  vEditor = new VectorEditor("X", "Y", "Z", true, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedVertexPosition(); } }, vertexEditGroup);
  
  faceEditGroup = new UIGroup();
  n1Editor = new VectorEditor("NX", "NY", "NZ", true, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  n2Editor = new VectorEditor("NX", "NY", "NZ", true, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  n3Editor = new VectorEditor("NX", "NY", "NZ", true, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  t1Editor = new VectorEditor("U", "V", "", false, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  t2Editor = new VectorEditor("U", "V", "", false, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  t3Editor = new VectorEditor("U", "V", "", false, false, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedFace(); } }, faceEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  
  materialEditGroup = new UIGroup(); 
  new Line(uiY, materialEditGroup);
  uiY += UI_BUTTON_BETWEEN;  
  new Label("MATERIAL", uiY, materialEditGroup);
  uiY += UI_BUTTON_TEXT + UI_BUTTON_TEXT; 
  int savedUIY = uiY;
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  kaEditor = new VectorEditor("AR", "AG", "AB", true, true, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedMaterial(); } }, materialEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  kdEditor = new VectorEditor("DR", "DG", "DB", true, true, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedMaterial(); } }, materialEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  ksEditor = new VectorEditor("SR", "SG", "SB", true, true, width - UI_COLUMN_WIDTH + 10, uiY, new Thunk() { @Override public void apply() { updateSelectedMaterial(); } }, materialEditGroup);
  uiY += UI_BUTTON_HEIGHT + UI_BUTTON_TEXT;
  ArrayList<String> materialNames = new ArrayList<String>();
  materialSelector = new DropDownList(materialNames, width - UI_COLUMN_WIDTH + 10, savedUIY, UI_COLUMN_WIDTH - 40, 25, new Thunk() { @Override public void apply() { updateMaterialChoice(); } }, materialEditGroup);
  
  materialDiffuseImage = new UIImage(width - UI_COLUMN_WIDTH + 10, uiY, 30, 30, materialEditGroup);
  
  newMaterialGroup = new UIGroup();
  new Button("Apply A Material", "m", false, null,  width - UI_COLUMN_WIDTH + 10, headOfGroupY, 210, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() {  addMaterial(); } }, newMaterialGroup );
  newMaterialGroup.setVisible(false);
  
  commandBox = new TextBox("", "COMMAND", width - UI_COLUMN_WIDTH + 10, height - 27, UI_COLUMN_WIDTH- 20, UI_BUTTON_HEIGHT, new Thunk() { @Override public void apply() { executeCommand(); } }, null );
  commandBox.anchorBottom = true;
  
  int windowWidth = (width - UI_COLUMN_WIDTH) / 2 - 5;
  int windowHeight = height / 2 - 5;
  windows.add(new Window(0, 0, windowWidth, windowHeight, VIEW_Z));
  windows.add(new Window(windowWidth + 5, 0, windowWidth, windowHeight, VIEW_X));
  windows.add(new Window(0, windowHeight + 5, windowWidth, windowHeight, VIEW_Y));
  windows.add(new Window(windowWidth + 5, windowHeight + 5, windowWidth, windowHeight, VIEW_3D));
  
  updateSelected();
  mode = MODE_SELECT_VERTEX; 
  registerCommands();
  thread("updateUI");
  textSize(12);
  
}

public void mouseWheel(MouseEvent event) {
  uiMouseWheel(event);
  for(Window w : windows) {
    w.mouseWheel(event);
  }
}

public void mouseClicked() {
  if(splashActive) {
    prefs.putBoolean("SplashSeen", true);
    splashActive = false;
    return;
  }
  if(!uiTakesMouseInput()) {
    if(dragWithoutPressInvalidatesClick) {
      //we got a drag, no intervening press, then a click.  we don't want this click in our UI.
      dragWithoutPressInvalidatesClick = false;
      if(mode != MODE_PLACE) {
        return;
      }
    }
    for(Window w : windows) {
      w.mouseClicked();
    }
  }
}

public void mousePressed() {
  if(!uiTakesMouseInput()) {
    dragWithoutPressInvalidatesClick = false;
    for(Window w : windows) {
      w.mousePressed();
    }
  }
}

public void mouseDragged() {
  if(!uiTakesMouseInput()) {  
    dragWithoutPressInvalidatesClick = true;
    for(Window w : windows) {
      w.mouseDragged();
    }
  }
}

public void mouseReleased() {   
  if(!uiTakesMouseInput()) {
    for(Window w : windows) {
      w.mouseReleased();
    }
  }
}

public void keyPressed() {
  if(key < 1024) {
    lastKeyDown[key] = keyDown[key];
    keyDown[key] = true;
  }
  lastKeyCodeDown[keyCode] = keyCodeDown[keyCode];
  keyCodeDown[keyCode] = true;
  if(!uiTakesKeyInput()) {
    for(Window w : windows) {
      w.keyPressed();
    }
  }
  if(key == ESC) key = 0;
  if (key == CODED) {
    if (keyCode == CONTROL) {
      ctrlPressed = true;
    }
  }
}

public void keyReleased() {   
    if(key < 1024) {
      lastKeyDown[key] = keyDown[key];
      keyDown[key] = false;
    }
    lastKeyCodeDown[keyCode] = keyCodeDown[keyCode];
    keyCodeDown[keyCode] = false;
    for(Window w : windows) {
    w.keyReleased();
  }
  if (key == CODED) {
    if (keyCode == CONTROL) {
      ctrlPressed = false;
    }
  }
  if(ctrlPressed && keyCode == 90) {
    undo();
  }
  if(ctrlPressed && keyCode == 65) {
    if(mode == MODE_SELECT_FACE) {
      for (int i = faces.size()-1; i >= 0; i--) {
        Face f = faces.get(i);
        f.selected = true;
      }
    } else {
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        v.selected = true;
      }
    }
  }
  if (key == DELETE) {
    UndoRecordDeletion urd = new UndoRecordDeletion();
    for (int i = faces.size()-1; i >= 0; i--) {
      Face f = faces.get(i);
      if(f.selected || f.v1.v.selected || f.v2.v.selected || f.v3.v.selected) {
        f.selected = false;
        urd.addFace(f);
        faces.remove(f);
      }
    }
    for (int i = vertices.size()-1; i >= 0; i--) {
      Vertex v = vertices.get(i);
      if(v.selected) {
        v.selected = false;
        urd.addVertex(v);
        vertices.remove(v);
      }
    }
  } 
} 

public void addFace() {  
  ArrayList<Vertex> selected = new ArrayList<Vertex>();
  for (int i = vertices.size()-1; i >= 0; i--) {
    Vertex v = vertices.get(i);
    if(v.selected) {
      selected.add(v);
    }
  }
  if(selected.size() == 3) {
    //See if the face already exists
    for (int i = faces.size()-1; i >= 0; i--) {
      Face f = faces.get(i);
      if(selected.contains(f.v1.v) && selected.contains(f.v2.v) && selected.contains(f.v3.v)) {
        new UndoRecordDeletion().addFace(f);
        faces.remove(f);
        return;
      }
    }
    Face newFace = new Face(selected.get(0), selected.get(1), selected.get(2));
    new UndoFaceAddition(newFace);
    faces.add(newFace);
  }
}

public void draw() {
  background(darkModeCheckbox.selected ? 0 : 192);
  ortho(-width/2, width/2, -height/2, height/2);
  
  for(Window w : windows) {
    w.draw();
    
    fill(255, 0, 0);
    text(VIEW_NAMES[w.viewType], w.x, w.y + w.h - 10);
  }
  ortho(-width/2, width/2, -height/2, height/2);
  strokeWeight(2);
  if(darkModeCheckbox.selected) {
    stroke(192, 192, 255);
  } else {
    stroke(64, 64, 128);
  }
  if(!fullScreenCheckbox.selected) {
    line(0, height / 2, width - UI_COLUMN_WIDTH, height / 2);
    line((width - UI_COLUMN_WIDTH) / 2, 0, (width - UI_COLUMN_WIDTH) / 2, height);
  }
  
  drawUI();
  drawSplash();
  //saveFrame("test-######.tif");
}



class Camera {
  Window w;
  
  Camera(Window wIn) {
    w = wIn;
  }
  
  public void keyPressed() {
  }
  
  public void keyReleased() {
  }
  
  public void mouseDragged() {
    if(mouseButton == RIGHT) {
      if(!(keyPressed && keyCode == ALT)) {
        //rotate around a point about 10 units in front of yourself
        Matrix4f modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
        Vector3f eye = new Vector3f();
        modelViewMatrixInvert.getTranslation(eye);
        Vector3f forward = new Vector3f();
        modelViewMatrixInvert.transformDirection(0, 0, -1, forward);
        forward.mul(2.0f);
        eye.add(forward);
        //Vector3f dir = new Vector3f();
        //modelViewMatrixInvert.positiveZ(dir);
        //dir.mul(-10.0);
        //eye.add(dir);        
        
        Vector3f right = new Vector3f();
        modelViewMatrixInvert.transformDirection(-1, 0, 0, right);
        Vector3f up = new Vector3f();
        modelViewMatrixInvert.transformDirection(0, -1, 0, up);
        w.modelViewMatrix.translate(eye.x, eye.y, eye.z)
          .rotate((w.selectMouseEndY - w.selectMouseStartY) * -(.31415f / 180.0f) * ROTATE_SPEED * 0.2f, right)
          .translate(-eye.x, -eye.y, -eye.z);
          
        /*modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
        modelViewMatrixInvert.getTranslation(eye);
        modelViewMatrixInvert.positiveZ(dir);
        dir.mul(-10.0);
        eye.add(dir);*/  
          
        w.modelViewMatrix.translate(eye.x, eye.y, eye.z)
          .rotate((w.selectMouseEndX - w.selectMouseStartX) * -(.31415f / 180.0f) * ROTATE_SPEED * 0.2f, up)
          .translate(-eye.x, -eye.y, -eye.z);
          
        w.selectMouseStartX = w.selectMouseEndX;
        w.selectMouseStartY = w.selectMouseEndY;
        //w.debugPoint = eye;
      } else {
        Matrix4f modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
        Vector3f up = new Vector3f();
        modelViewMatrixInvert.transformDirection(0, 1, 0, up);
        up.normalize(up);
        
        Vector3f right = new Vector3f();
        modelViewMatrixInvert.transformDirection(1, 0, 0, right);
        right.normalize(right);
        
        w.modelViewMatrix.rotate((w.selectMouseEndY - w.selectMouseStartY) * -(.31415f / 180.0f) * ROTATE_SPEED, right);
        w.modelViewMatrix.rotate((w.selectMouseEndX - w.selectMouseStartX) * (.31415f / 180.0f) * ROTATE_SPEED, up);
        w.selectMouseStartX = w.selectMouseEndX;
        w.selectMouseStartY = w.selectMouseEndY;
      }
    }
  }
  
  public void update() {
    Matrix4f modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
    if(keyDown['w']) { //w
      Vector3f forward = new Vector3f();
      modelViewMatrixInvert.transformDirection(0, 0, 1, forward);
      forward.mul(keyCodeDown[16] ? CAMERA_MOVEMENT_SHIFT_SCALE : CAMERA_MOVEMENT_SCALE);
      w.modelViewMatrix.translate(forward);
    } 
    if(keyDown['s']) { //don't know s yet
      Vector3f backward = new Vector3f();
      modelViewMatrixInvert.transformDirection(0, 0, -1, backward);
      backward.mul(keyCodeDown[16] ? CAMERA_MOVEMENT_SHIFT_SCALE : CAMERA_MOVEMENT_SCALE);
      w.modelViewMatrix.translate(backward);
    } 
    if(keyDown['a']) {
      Vector3f left = new Vector3f();
      modelViewMatrixInvert.transformDirection(1, 0, 0, left);
      left.mul(keyCodeDown[16] ? CAMERA_MOVEMENT_SHIFT_SCALE : CAMERA_MOVEMENT_SCALE);
      w.modelViewMatrix.translate(left);
    } 
    if(keyDown['d']) {
      Vector3f right = new Vector3f();
      modelViewMatrixInvert.transformDirection(-1, 0, 0, right);
      right.mul(keyCodeDown[16] ? CAMERA_MOVEMENT_SHIFT_SCALE : CAMERA_MOVEMENT_SCALE);
      w.modelViewMatrix.translate(right);
    }
  }
  
  public void pan(float x, float y) {
    
    Matrix4f modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
    Vector3f up = new Vector3f();
    modelViewMatrixInvert.transformDirection(0, -1, 0, up);
    up.mul(y * PAN_SPEED_3D);
    w.modelViewMatrix.translate(up); 
    Vector3f right = new Vector3f();
    modelViewMatrixInvert.transformDirection(1, 0, 0, right);
    right.mul(x * PAN_SPEED_3D);
    w.modelViewMatrix.translate(right);
  }
  
  public void moveForward(float amount) {
    Matrix4f modelViewMatrixInvert = new Matrix4f(w.modelViewMatrix).invert();
    Vector3f forward = new Vector3f();
    modelViewMatrixInvert.transformDirection(0, 0, -1, forward);
    forward.mul(amount);
    w.modelViewMatrix.translate(forward);
  }
  
  public void frameModel() {
    ArrayList<Vertex> selected = new ArrayList<Vertex>();
    for (Vertex v: vertices) {
      if(v.selected) {
        selected.add(v);
      }
    }
    ArrayList<Face> selectedFaces = new ArrayList<Face>();
    for (Face f: faces) {
      if(f.selected) {
        selectedFaces.add(f);
      }
    }
    Vertex centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
    Vertex min = new Vertex(MAX_FLOAT, MAX_FLOAT, MAX_FLOAT);
    Vertex max = new Vertex(-MAX_FLOAT, -MAX_FLOAT, -MAX_FLOAT);
    float scale = 1.0f;
    if((selected.size() == 0) && (selectedFaces.size() == 0)) {
      for (Vertex v : vertices) {
        centerOfMass.x += v.x * (1.0f / vertices.size());
        centerOfMass.y += v.y * (1.0f / vertices.size());
        centerOfMass.z += v.z * (1.0f / vertices.size());
        min.x = min(min.x, v.x);
        min.y = min(min.y, v.y);
        min.z = min(min.z, v.z);
        max.x = max(max.x, v.x);
        max.y = max(max.y, v.y);
        max.z = max(max.z, v.z);
      }    
    } else if(selected.size() > 0) {
      for (Vertex v : selected) {
        centerOfMass.x += v.x * (1.0f / selected.size());
        centerOfMass.y += v.y * (1.0f / selected.size());
        centerOfMass.z += v.z * (1.0f / selected.size());
        min.x = min(min.x, v.x);
        min.y = min(min.y, v.y);
        min.z = min(min.z, v.z);
        max.x = max(max.x, v.x);
        max.y = max(max.y, v.y);
        max.z = max(max.z, v.z);
      }    
    } else {
      for (Face f : faces) {
        centerOfMass.x += f.v1.v.x * (0.33333333333f / faces.size());
        centerOfMass.y += f.v1.v.y * (0.33333333333f / faces.size());
        centerOfMass.z += f.v1.v.z * (0.33333333333f / faces.size());
        min.x = min(min.x, f.v1.v.x);
        min.y = min(min.y, f.v1.v.y);
        min.z = min(min.z, f.v1.v.z);
        max.x = max(max.x, f.v1.v.x);
        max.y = max(max.y, f.v1.v.y);
        max.z = max(max.z, f.v1.v.z);
        centerOfMass.x += f.v2.v.x * (0.33333333333f / faces.size());
        centerOfMass.y += f.v2.v.y * (0.33333333333f / faces.size());
        centerOfMass.z += f.v2.v.z * (0.33333333333f / faces.size());
        min.x = min(min.x, f.v2.v.x);
        min.y = min(min.y, f.v2.v.y);
        min.z = min(min.z, f.v2.v.z);
        max.x = max(max.x, f.v2.v.x);
        max.y = max(max.y, f.v2.v.y);
        max.z = max(max.z, f.v2.v.z);
        centerOfMass.x += f.v3.v.x * (0.33333333333f / faces.size());
        centerOfMass.y += f.v3.v.y * (0.33333333333f / faces.size());
        centerOfMass.z += f.v3.v.z * (0.33333333333f / faces.size());
        min.x = min(min.x, f.v3.v.x);
        min.y = min(min.y, f.v3.v.y);
        min.z = min(min.z, f.v3.v.z);
        max.x = max(max.x, f.v3.v.x);
        max.y = max(max.y, f.v3.v.y);
        max.z = max(max.z, f.v3.v.z);
      }
    }    
    scale = max((max.x - min.x), max(max.y - min.y, max.z - min.z));
    w.modelViewMatrix.setLookAt(centerOfMass.x, centerOfMass.y, centerOfMass.z + 1.2f * scale, 
      centerOfMass.x, centerOfMass.y, centerOfMass.z,
      0.0f, -1.0f, 0.0f);
  }
}

public Vector3f rgbToHsb(Vector3f c) {  
  Vector3f r = new Vector3f();
  float V = max(max(r.x, r.y), r.z);
  float min = min(min(r.x, r.y), r.z);
  float S = (V == 0.0f) ? 0.0f : ((V - min) / V);
  float H = 0.0f;
  if(V == r.x) {
    H = 60 * (c.y - c.z) / (V - min);
  } else if (V == r.y) {
    H = 60 * (2 + (c.z - c.x) / (V - min));
  } else {
    H = 60 * (4 + (c.x - c.y) / (V - min));
  }
  r.x = H;
  r.y = S;
  r.z = V;
  return r;
}

public Vector3f hsvToRgb(Vector3f c) {
  Vector3f r = new Vector3f();
  if(c.y <= 0.0f) {       
      r.x = c.z * 255;
      r.y = c.z * 255;
      r.z = c.z * 255;
      return r;
  }
  float hh = c.x;
  if(hh >= 360.0f) hh = 0.0f;
  hh /= 60.0f;
  int i = (int)hh;
  float ff = hh - i;
  float p = c.z * (1.0f - c.y);
  float q = c.z * (1.0f - (c.y * ff));
  float t = c.z * (1.0f - (c.y * (1.0f - ff)));

  switch(i) {
  case 0:
      r.x = c.z * 255;
      r.y = t * 255;
      r.z = p * 255;
      break;
  case 1:
      r.x = q * 255;
      r.y = c.z * 255;
      r.z = p * 255;
      break;
  case 2:
      r.x = p * 255;
      r.y = c.z * 255;
      r.z = t * 255;
      break;
  case 3:
      r.x = p * 255;
      r.y = q * 255;
      r.z = c.z * 255;
      break;
  case 4:
      r.x = t * 255;
      r.y = p * 255;
      r.z = c.z * 255;
      break;
  case 5:
  default:
      r.x = c.z * 255;
      r.y = p * 255;
      r.z = q * 255;
      break;
  }
  return r;     
}

static final int MODE_PLACE = 1;
static final int MODE_SELECT_VERTEX = 2;
static final int MODE_SELECT_FACE = 3;
static final int MODE_MOVE = 4;
static final int MODE_SCALE_ALL = 5;
static final int MODE_SCALE = 6;
static final int MODE_ROTATE = 7;


static final int VIEW_Z = 1;   ///View down the Z axis at Z = 0
static final int VIEW_Y = 2;   ///View down the Y axis at Y = 0
static final int VIEW_X = 3;   ///View down the X axis at X = 0
static final int VIEW_3D = 4;  ///Arbitrary 3D view

static final String[] VIEW_NAMES = { "", "FRONT", "TOP ", "LEFT", "PERSPECTIVE" };

static final float VIEW_SCALE = 0.1f;
static final float STARTING_SCALE = 5.0f;

static final float SCROLL_MULTIPLIER = 1.05f;
static final float SCROLL_3D_MOVE = 0.2f;
static final float SCROLL_SHIFT_MULTIPLIER = 10.0f;

static final float ROTATE_SPEED = 3.0f;

static final float CAMERA_MOVEMENT_SCALE = 0.05f;
static final float CAMERA_MOVEMENT_SHIFT_SCALE = 10.0f;

static final int UI_COLUMN_WIDTH = 240;
static final int UI_BAR_HEIGHT = 50;


static final float PAN_SPEED_3D = 0.002f;

static final float GEOM_SCALING_FACTOR = 1.001f;

static final int DROP_DOWN_MAX = 4;

static final int UI_BUTTON_HEIGHT = 25;
static final int UI_BUTTON_BETWEEN = 7;
static final int UI_BUTTON_TEXT = 15;

HashMap<String, Thunk> commands = new HashMap<String, Thunk> ();


public void executeCommand() {
  String c = commandBox.t;
  println("'" + c + "'");
  Thunk t = commands.get(c);
  if(t != null) {
    println("go");
    t.apply();
  }
  commandBox.caretPos = 0;
  commandBox.t = "";
}


public void registerCommands() {
  registerCommand("randompoints", new Thunk() { @Override public void apply() { randomPoints(); } } );
}

public void registerCommand(String s, Thunk t) {
  commands.put(s, t);
}

public void randomPoints() {
  for(int i = 0; i < 100; ++i) {
    makeVertex(random(0.0f, 1.0f), random(0.0f, 1.0f), random(0.0f, 1.0f));
  }
}








class MyFileChooser extends JFileChooser {
    protected JDialog createDialog(Component parent) throws HeadlessException {
        final JDialog dialog = super.createDialog(parent);
        dialog.setAlwaysOnTop(true);        
        new java.util.Timer().schedule( 
        new java.util.TimerTask() {
            @Override
            public void run() {
              dialog.toFront();
            }
          }, 
          100 
        );
        return dialog;
    }
}

public VertexRecord vertexHelper(String s, int startingCount, ArrayList<Vector3f> textureIndices, ArrayList<Vector3f> normals)
{
  String [] subPieces = split(s, '/');
  VertexRecord v1 = new VertexRecord(vertices.get(PApplet.parseInt(subPieces[0]) - 1 + startingCount));                                  
  if(subPieces.length > 1) {
    //Get texture index
    if(subPieces[1].length() > 0) {
      v1.setTexture(textureIndices.get(PApplet.parseInt(subPieces[1]) - 1).x, textureIndices.get(PApplet.parseInt(subPieces[1]) - 1).y);
    }
  }
  if(subPieces.length > 2) {
    //Get normal index
    if(subPieces[2].length() > 0) {
      v1.setNormal(normals.get(PApplet.parseInt(subPieces[2]) - 1).x, normals.get(PApplet.parseInt(subPieces[2]) - 1).y, normals.get(PApplet.parseInt(subPieces[2]) - 1).z);
    }
  }
  return v1;
}

public void loadMaterials(String s) throws IOException {
  Material m = null;
  File f = new File(s);
  if(!f.exists()) {
    return;
  }
  Scanner scanner = new Scanner(f);
  String line = null;
  while(scanner.hasNextLine()) {
    line = scanner.nextLine();
    String[] pieces = splitTokens(line, " ");
    for(int pn = 0; pn < pieces.length; pn++) {
      pieces[pn] = trim(pieces[pn]);
    }
    if(pieces.length == 0) {
      continue;
    }
    if(pieces[0].equals("newmtl")) {
      m = new Material(pieces[1]);
      materials.put(m.name, m);
    }
    if(pieces[0].equals("Ka")) {
      m.Ka = new Vector3f(PApplet.parseFloat(pieces[1]), PApplet.parseFloat(pieces[2]), PApplet.parseFloat(pieces[3]));
    }
    if(pieces[0].equals("Kd")) {
      m.Kd = new Vector3f(PApplet.parseFloat(pieces[1]), PApplet.parseFloat(pieces[2]), PApplet.parseFloat(pieces[3]));
    }
    if(pieces[0].equals("Ks")) {
      m.Ks = new Vector3f(PApplet.parseFloat(pieces[1]), PApplet.parseFloat(pieces[2]), PApplet.parseFloat(pieces[3]));
    }
    if(pieces[0].equals("map_Kd")) {
      m.texture_diffuse = loadImage(f.getParent() + "\\" + pieces[1]);      
    }
  }
  scanner.close();
  return;
}

public void openFile(final PApplet p) {
  EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
              try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } catch (Exception ex) {
                }
                MyFileChooser chooser = new MyFileChooser();
                      if (chooser.showOpenDialog(((PSurfaceJOGL)p.getSurface()).getComponent()) == JFileChooser.APPROVE_OPTION) {
                          // do something
                          File selectedFile = chooser.getSelectedFile();
                          String extension = "";
                          int i = selectedFile.getAbsolutePath().lastIndexOf('.');
                          if (i > 0) {
                              extension = selectedFile.getAbsolutePath().substring(i+1);
                          }
                          if(extension.equals("fbx")) {
                            loadFbx(selectedFile);
                          } else if(extension.equals("stl")) {
                            loadBinaryStl(selectedFile);
                          } else {
                            try {
                              Scanner scanner = new Scanner(selectedFile);
                              String line = null;
                              int startingCount = vertices.size();
                              ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
                              ArrayList<Vector3f> textureIndices = new ArrayList<Vector3f>();
                              Material curMaterial = null;
                              while(scanner.hasNextLine()) {
                                line = scanner.nextLine();
                                String[] pieces = splitTokens(line, " ");
                                if(pieces.length == 0) {
                                  continue;
                                }
                                if(pieces[0].equals("#")) {
                                  continue;
                                }
                                if(pieces[0].equals("o")) {
                                  //New object.  We don't support objects yet
                                }
                                if(pieces[0].equals("mtllib")) {                                  
                                  loadMaterials(selectedFile.getParent() + "\\" + pieces[1]);
                                }
                                if(pieces[0].equals("usemtl")) {
                                  curMaterial = materials.get(pieces[1]);
                                }
                                if(pieces[0].equals("v")) {
                                  float x = PApplet.parseFloat(pieces[1]);
                                  float y = PApplet.parseFloat(pieces[2]);
                                  float z = PApplet.parseFloat(pieces[3]);
                                  
                                  Vertex v = new Vertex(x, y, z);
                                  vertices.add(v);
                                } 
                                if(pieces[0].equals("vn")) {
                                  float x = PApplet.parseFloat(pieces[1]);
                                  float y = PApplet.parseFloat(pieces[2]);
                                  float z = PApplet.parseFloat(pieces[3]);
                                  
                                  normals.add(new Vector3f(x, y, z));                                  
                                } 
                                if(pieces[0].equals("vt")) {
                                  float x = PApplet.parseFloat(pieces[1]);
                                  float y = PApplet.parseFloat(pieces[2]);
                                  //float z = float(pieces[3]);  //There is a third, we're ignoring
                                  
                                  textureIndices.add(new Vector3f(x, y, 0));
                                } 
                                //OK this is actually wrong.  We're storing the normal and the texture index on the vertex, where as they can differ
                                //per face.  That means we're getting this wrong for some models.  We need to re-architect the data model to support this.
                                if(pieces[0].equals("f")) {
                                  if(pieces.length == 4) {
                                    VertexRecord v1 = vertexHelper(pieces[1], startingCount, textureIndices, normals);
                                    VertexRecord v2 = vertexHelper(pieces[2], startingCount, textureIndices, normals);
                                    VertexRecord v3 = vertexHelper(pieces[3], startingCount, textureIndices, normals);
                                    faces.add(new Face(v1, v2, v3, curMaterial));
                                  } else if (pieces.length == 5) {
                                    VertexRecord v1 = vertexHelper(pieces[1], startingCount, textureIndices, normals);
                                    VertexRecord v2 = vertexHelper(pieces[2], startingCount, textureIndices, normals);
                                    VertexRecord v3 = vertexHelper(pieces[3], startingCount, textureIndices, normals);
                                    VertexRecord v4 = vertexHelper(pieces[4], startingCount, textureIndices, normals);                                    
                                    faces.add(new Face(v1, v2, v3, curMaterial));
                                    faces.add(new Face(v1, v3, v4, curMaterial));
                                  }
                                }
                              }
                              println("read: " + vertices.size() + " , " + textureIndices.size() + " , " + normals.size());
                              scanner.close();
                            } catch (IOException e) {
                              print("exception " + e);
                              e.printStackTrace();
                            }   
                          }
                          resetMaterials();
                      }
                  }              
        });
}

int curNormalIndex, curTextureIndex;

public String vertexRecordHelper(VertexRecord vr) {
  String result = (vertices.indexOf(vr.v) + 1) + "";
  if(vr.hasTexture) {
    result = result + "/" + (curTextureIndex + 1);
    curTextureIndex++;
  } else if (!vr.hasTexture && vr.hasNormal) {
    result = result + "/";
  }
  if(vr.hasNormal) {
    result = result + "/" + (curNormalIndex + 1);
    curNormalIndex++;
  }
  return result;
}

public void saveFile(final PApplet p) {
  EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } catch (Exception ex) {
                }
                MyFileChooser chooser = new MyFileChooser();
                  if (chooser.showSaveDialog(((PSurfaceJOGL)p.getSurface()).getComponent()) == JFileChooser.APPROVE_OPTION) {
                      // do something
                      File selectedFile = chooser.getSelectedFile();
                      String extension = "";
                      int ie = selectedFile.getAbsolutePath().lastIndexOf('.');
                      if (ie > 0) {
                          extension = selectedFile.getAbsolutePath().substring(ie+1);
                      }
                      if(extension.equals("stl")) {
                            saveBinaryStl(selectedFile);
                      } else {
                        PrintWriter pw = createWriter(selectedFile.getAbsolutePath());
                        //Save out materials
                        if(materials.size() > 0) {
                          String s = selectedFile.getAbsolutePath();
                          int i = s.lastIndexOf('.');
                          if (i > 0) {
                            s = s.substring(0, i);                            
                          }
                          PrintWriter mpw = createWriter(s + ".mtl");
                           Iterator<Material> mv = materials.values().iterator();
    
                          while(mv.hasNext()) {
                            Material m = mv.next();
                            //println("mi = " + mi + " m = " + materials.get(mi));
                            mpw.println("newmtl " + m.name);
                            mpw.println("Ka " + m.Ka.x + " " + m.Ka.y + " " + m.Ka.z);
                            mpw.println("Kd " + m.Kd.x + " " + m.Kd.y + " " + m.Kd.z);
                            mpw.println("Ks " + m.Ks.x + " " + m.Ks.y + " " + m.Ks.z);
                            if(m.texture_diffuse != null) {
                              String imgName = s + "_" + m.name + "_diffuse.png";
                              m.texture_diffuse.save(imgName);
                              mpw.println("map_Kd " + new File(imgName).getName());
                            }
                          }
                          mpw.flush();
                          mpw.close();
                          pw.println("mtllib " + (new File(s + ".mtl")).getName());
                        }
                        for (int i = 0; i < vertices.size(); i++) {
                          Vertex v = vertices.get(i);
                          pw.println("v " + v.x + " " + v.y + " " + v.z);
                        }
                        pw.println("");
                        for (int i = faces.size()-1; i >= 0; i--) {
                          Face f = faces.get(i);
                          if(f.v1.hasNormal) {
                            pw.println("vn " + f.v1.nx + " " + f.v1.ny + " " + f.v1.nz);
                          }
                          if(f.v2.hasNormal) {
                            pw.println("vn " + f.v2.nx + " " + f.v2.ny + " " + f.v2.nz);
                          }
                          if(f.v3.hasNormal) {
                            pw.println("vn " + f.v3.nx + " " + f.v3.ny + " " + f.v3.nz);
                          }
                        }
                        pw.println("");
                        for (int i = faces.size()-1; i >= 0; i--) {
                          Face f = faces.get(i);                        
                          if(f.v1.hasTexture) {
                            pw.println("vt " + f.v1.tx + " " + f.v1.ty);
                          }
                          if(f.v2.hasTexture) {
                            pw.println("vt " + f.v2.tx + " " + f.v2.ty);
                          }
                          if(f.v3.hasTexture) {
                            pw.println("vt " + f.v3.tx + " " + f.v3.ty);
                          }
                        }
                        curNormalIndex = 0;
                        curTextureIndex = 0;
                        String curMatName = "";
                        for (int i = faces.size()-1; i >= 0; i--) {
                          Face f = faces.get(i);
                          if((f.m != null) &&
                             (!f.m.name.equals(curMatName))) {
                               curMatName = f.m.name;
                               pw.println("usemtl " + f.m.name);
                          }
                          pw.println("f " + vertexRecordHelper(f.v1) + " " + vertexRecordHelper(f.v2) + " " + vertexRecordHelper(f.v3));
                        }
                        pw.flush();
                        pw.close();
                      }
                  }
              }              
        });
}

public void saveBinaryStl(File f) {
  try {
    FileOutputStream fos = new FileOutputStream(f);
    fos.write("Armas V1.0 STL Export".getBytes());
    fos.write(new byte[59]);
    ByteBuffer bb = ByteBuffer.allocate(4);
    bb.order(ByteOrder.LITTLE_ENDIAN);        
    bb.putInt(faces.size());
    fos.write(bb.array());
    for(int i = 0; i < faces.size(); ++i) {
      Face fa = faces.get(i);
      bb = ByteBuffer.allocate(50);
      bb.order(ByteOrder.LITTLE_ENDIAN);        
      bb.putFloat(fa.v1.hasNormal ? fa.v1.nx : 0.0f);
      bb.putFloat(fa.v1.hasNormal ? fa.v1.ny : 0.0f);
      bb.putFloat(fa.v1.hasNormal ? fa.v1.nz : 0.0f);
      bb.putFloat(fa.v1.v.x);
      bb.putFloat(fa.v1.v.y);
      bb.putFloat(fa.v1.v.z);
      bb.putFloat(fa.v2.v.x);
      bb.putFloat(fa.v2.v.y);
      bb.putFloat(fa.v2.v.z);
      bb.putFloat(fa.v3.v.x);
      bb.putFloat(fa.v3.v.y);
      bb.putFloat(fa.v3.v.z);
      bb.putShort((short)0);
      fos.write(bb.array());
    }
    fos.flush();
    fos.close();
  } catch (Exception ex) {
  }
}

public void loadBinaryStl(File f) {
  try {
    
    RandomAccessFile aFile = new RandomAccessFile
                (f.getAbsolutePath(), "r");
    FileChannel inChannel = aFile.getChannel();
    MappedByteBuffer buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0, inChannel.size());
    buffer.order(ByteOrder.LITTLE_ENDIAN);
    buffer.load();
    
    byte[] header = new byte[80];
    buffer.get(header);
    
    int numTris = buffer.getInt();
    println("STL numTris = " + numTris);
    for(int i = 0; i < numTris; ++i) {
      Vector3f n = new Vector3f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
      Vertex v1 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
      Vertex v2 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
      Vertex v3 = new Vertex(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
      short dummy = buffer.getShort();
      
      vertices.add(v1);
      vertices.add(v2);
      vertices.add(v3);
      
      Face fa = new Face(v1, v2, v3);
      faces.add(fa);
      fa.v1.setNormal(n.x, n.y, n.z);
      fa.v2.setNormal(n.x, n.y, n.z);
      fa.v3.setNormal(n.x, n.y, n.z);      
    }
    buffer.clear(); // do something with the data and clear/compact it.
    inChannel.close();
    aFile.close();
    } catch (Exception ex) {
  }
}

public void loadFbx(File f) {
  try {
    RandomAccessFile aFile = new RandomAccessFile
                (f.getAbsolutePath(), "r");
    FileChannel inChannel = aFile.getChannel();
    MappedByteBuffer buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0, inChannel.size());
    buffer.order(ByteOrder.LITTLE_ENDIAN);
    buffer.load();  
    
    byte[] header = new byte[23];
    buffer.get(header);
    int version = buffer.getInt();
    println("FBX version = " + version);
        
    fbxReadNode(buffer);
    
    buffer.clear(); // do something with the data and clear/compact it.
    inChannel.close();
    aFile.close();
  } catch (Exception ex) {
  }
}

public void fbxReadNode(ByteBuffer b) throws IOException {
  println("NODE");
  int endOffset = b.getInt();
  int numProperties = b.getInt();
  int propertyListLen = b.getInt();
  int nameLen = b.get();
  byte[] name = new byte[nameLen];
  b.get(name);
  println("endOffset = " + endOffset);
  println("numProperties = " + numProperties);
  println("propertyListLen = " + propertyListLen);
  println("nameLen = " + nameLen);
  println("name = " + new String(name));
  for(int i = 0; i < numProperties; i++) {
    fbxReadProperty(b);
  }
  if(b.position() < endOffset) {
    fbxReadNode(b);
  }
}

public void fbxReadProperty(ByteBuffer b) throws IOException {
  char propertyType = b.getChar();
  println(propertyType);
  if(propertyType == 'Y') {
    short s = b.getShort();
    println(s);
  } else if (propertyType == 'C') {
    boolean boo = (b.getChar() != 0);
    println(boo);
  } else if (propertyType == 'I') {
    int i = b.getInt();
    println(i);
  } else if (propertyType == 'F') {
    float f = b.getFloat();
    println(f);
  } else if (propertyType == 'D') {
    double d = b.getDouble();
    println(d);
  } else if (propertyType == 'L') {
    long l = b.getLong();
    println(l);
  }
}
class Vertex {
  float x, y, z;
  boolean selected;
  
  Vertex(float inX, float inY, float inZ) {
    x = inX; y = inY; z = inZ;
    selected = false;
  }
  
}

class VertexRecord {
  Vertex v;  
  boolean hasNormal;
  boolean hasTexture;
  float nx, ny, nz;
  float tx, ty;
  
  VertexRecord(Vertex vIn) {
    v = vIn;
    hasNormal = false;
    hasTexture = false;
   
  }
  
  public void setNormal(float inNx, float inNy, float inNz) {
    hasNormal = true;
    nx = inNx;
    ny = inNy;
    nz = inNz;
  }
  public void setTexture(float inTx, float inTy) {
    hasTexture = true;
    tx = inTx;
    ty = inTy;
  }
}

class Face {
  VertexRecord v1, v2, v3;
  boolean selected;
  Material m;
  
  Face(Vertex inV1, Vertex inV2, Vertex inV3) {
    v1 = new VertexRecord(inV1); v2 = new VertexRecord(inV2); v3 = new VertexRecord(inV3);
    selected = false;
    m = null;
  }
  Face(VertexRecord inV1, VertexRecord inV2, VertexRecord inV3) {
    v1 = inV1; v2 = inV2; v3 = inV3;
    selected = false;
  }
  Face(VertexRecord inV1, VertexRecord inV2, VertexRecord inV3, Material mIn) {
    v1 = inV1; v2 = inV2; v3 = inV3;
    m = mIn;
    selected = false;
  }
}

class Material {
  String name;
  Vector3f Ka, Kd, Ks;
  PImage texture_diffuse;
  Material(String nameIn) {
    name = nameIn;
    Ka = new Vector3f();
    Kd = new Vector3f();
    Ks = new Vector3f();
    texture_diffuse = null;
  }
}

public Vector3f faceNormal(Face f) {
  Vector3f e1 = new Vector3f(f.v2.v.x  - f.v1.v.x, f.v2.v.y - f.v1.v.y, f.v2.v.z - f.v1.v.z);
  Vector3f e2 = new Vector3f(f.v3.v.x  - f.v2.v.x, f.v3.v.y - f.v2.v.y, f.v3.v.z - f.v2.v.z);
  
  Vector3f n = new Vector3f(e1.y * e2.z - e1.z * e2.y,
                            e1.z * e2.x - e1.x * e2.z,
                            e1.x * e2.y - e1.y * e2.x);
  n.normalize();
  return n;
}

public void toggleNormals() {
  for(int i = 0 ; i < faces.size(); ++i) {
    Face f = faces.get(i);
    if(f.selected) {
      if(f.v1.hasNormal) {
        f.v1.hasNormal = f.v2.hasNormal = f.v3.hasNormal = false;
      } else {
        Vector3f n = faceNormal(f);
        f.v1.setNormal(n.x, n.y, n.z);
        f.v2.setNormal(n.x, n.y, n.z);
        f.v3.setNormal(n.x, n.y, n.z);
        
      }
    }
  }  
}

public void joinVerts() {
  ArrayList<Vertex> selected = new ArrayList<Vertex>();
  centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
  for (Vertex v: vertices) {
    if(v.selected) {
      selected.add(v);
      centerOfMass.x += v.x;
      centerOfMass.y += v.y;
      centerOfMass.z += v.z;
    }
  }
  if(selected.size() == 0) {
    return;
  }
  centerOfMass.x /= selected.size();
  centerOfMass.y /= selected.size();
  centerOfMass.z /= selected.size();
  Vertex toSave = selected.get(0);
  toSave.x = centerOfMass.x; toSave.y = centerOfMass.y; toSave.z = centerOfMass.z;
  for(Face f: faces) {
    if(f.v1.v.selected) {
      f.v1.v = toSave;
    }
    if(f.v2.v.selected) {
      f.v2.v = toSave;
    }
    if(f.v3.v.selected) {
      f.v3.v = toSave;
    }
  }
  for(Vertex v : selected) {
    vertices.remove(v);
  }
  vertices.add(toSave);
  updateSelected();
}

public Vertex makeVertex(float x, float y, float z) {
  Vertex result = new Vertex(x, y, z);
  vertices.add(result);
  return result;
}

public void makeCube() {
  Vertex v1 = makeVertex(-1.0f, -1.0f, -1.0f);
  Vertex v2 = makeVertex(-1.0f, -1.0f, 1.0f);
  Vertex v3 = makeVertex(-1.0f, 1.0f, -1.0f);
  Vertex v4 = makeVertex(-1.0f, 1.0f, 1.0f);
  Vertex v5 = makeVertex(1.0f, -1.0f, -1.0f);
  Vertex v6 = makeVertex(1.0f, -1.0f, 1.0f);
  Vertex v7 = makeVertex(1.0f, 1.0f, -1.0f);
  Vertex v8 = makeVertex(1.0f, 1.0f, 1.0f);
  
  faces.add(new Face(v1, v2, v3));  
  faces.add(new Face(v2, v4, v3));
  faces.add(new Face(v1, v5, v6));
  faces.add(new Face(v1, v6, v2));
  faces.add(new Face(v3, v7, v8));
  faces.add(new Face(v3, v8, v4));
  faces.add(new Face(v5, v7, v6));
  faces.add(new Face(v6, v7, v8));
  faces.add(new Face(v2, v4, v6));
  faces.add(new Face(v4, v6, v8));
  faces.add(new Face(v1, v3, v5));
  faces.add(new Face(v3, v5, v7));
}

static final int NUM_AROUND = 15;
static final int NUM_UP = 50;

public void makeSphere() {
  Vertex b = makeVertex(-1.0f, 0.0f, 0.0f);
  ArrayList<Vertex> shelf = new ArrayList<Vertex>();
  for(int i = 0; i < NUM_AROUND; ++i) {
    float h = -1.0f + (2.0f / NUM_UP);
    float d = sqrt(1.0f - h * h);
    shelf.add(makeVertex(-1.0f + (2.0f / NUM_UP), d * cos(i * 2.0f * PI / NUM_AROUND), d * sin(i * 2.0f * PI / NUM_AROUND)));
    if(i != 0) {
      faces.add(new Face(b, shelf.get(i), shelf.get(i - 1)));
    }
  }
  faces.add(new Face(b, shelf.get(0), shelf.get(NUM_AROUND - 1)));
  
  ArrayList<Vertex> oldShelf = shelf;
  shelf = new ArrayList<Vertex>();
  for(int j = 0; j < NUM_UP - 2; ++j) {
    float h = -1.0f + (j + 1) * (2.0f / NUM_UP);
    float d = sqrt(1.0f - h * h);
    for(int i = 0; i < NUM_AROUND; ++i) {
        shelf.add(makeVertex(-1.0f + (j + 1) * (2.0f / NUM_UP), d * cos(i * 2.0f * PI / NUM_AROUND), d * sin(i * 2.0f * PI / NUM_AROUND)));
    }
    for(int i = 0; i < NUM_AROUND - 1; ++i) {
      faces.add(new Face(oldShelf.get(i + 1), shelf.get(i + 1), oldShelf.get(i)));
      faces.add(new Face(oldShelf.get(i), shelf.get(i + 1), shelf.get(i)));
    }
    faces.add(new Face(oldShelf.get(NUM_AROUND - 1), oldShelf.get(0), shelf.get(NUM_AROUND - 1)));
    faces.add(new Face(oldShelf.get(0), shelf.get(0), shelf.get(NUM_AROUND - 1)));    
    oldShelf = shelf;
    shelf = new ArrayList<Vertex>();
  }
  Vertex t = makeVertex(1.0f, 0.0f, 0.0f);
  for(int i = 0; i < NUM_AROUND; ++i) {
    if(i != 0) {
      faces.add(new Face(t, oldShelf.get(i - 1), oldShelf.get(i)));
    }
  }
  faces.add(new Face(t, oldShelf.get(NUM_AROUND - 1), oldShelf.get(0)));
  
  return;  
}

boolean splashActive = true;
PImage splashImage = null;

public void drawSplash() {
  if(splashActive) {
    if(splashImage == null) {
      splashImage = loadImage("Avalanche_Header.png");
    }
    fill(255, 255, 255);
    stroke(92, 92, 92);
    rect(width / 2 - width / 4, height / 2 - height / 4, width / 2, height / 2);
    image(splashImage, width / 2 - 128, height / 2 - height / 4 + 50, 256, 80);
    
    fill(0, 0, 0);
    textSize(24);
    text("Welcome to Avalanche 3D!", width / 2 - width / 4 + 50, height / 2 - height / 4 + 200);
    
    
    text("Quick Tips:", width / 2 - width / 4 + 50, height / 2 - height / 4 + 250);
    text("- Every button has a hotkey in the upper left", width / 2 - width / 4 + 100, height / 2 - height / 4 + 280);
    text("- Hold space to pan the camera", width / 2 - width / 4 + 100, height / 2 - height / 4 + 310);
    text("- Right mouse rotates; hold alt to rotate model", width / 2 - width / 4 + 100, height / 2 - height / 4 + 340);
    
    textSize(12);
  }
}



ArrayList<UIElement> elements = new ArrayList<UIElement>();
boolean isMousePressed = false;
boolean isKeyPressed = false;
boolean wasMousePressed = false;
boolean wasKeyPressed = false;
MouseEvent uiLastMouseWheelEvent = null;
MouseEvent curMouseWheelEvent = null;

static final DecimalFormat df = new DecimalFormat("0.####");

public String floatToString(float f) {
  //return String.format("%.04f", f);
  return df.format(f);
}

public void uiMouseWheel(MouseEvent event) {
  uiLastMouseWheelEvent = event;
}
  
public boolean uiTakesKeyInput() {
  if(splashActive) {
    return true;
  }
  for (int i = elements.size()-1; i >= 0; i--) {
    UIElement e = elements.get(i);
    if(e instanceof TextBox) {
      TextBox tb = (TextBox)e;
      if(tb.focused) {
        return true;
      }
    }
  }
  return false;
}

public boolean uiTakesMouseInput() {
  if(splashActive) {
    return true;
  }
  for (int i = elements.size()-1; i >= 0; i--) {
    UIElement e = elements.get(i);
    if(e instanceof ColorPicker) {
      ColorPicker cp = (ColorPicker)e;
      if(cp.takesMouseInput()) {
        return true;
      }
    }
  }
  return false;
}

public void updateUI() {
  while(true) {
    curMouseWheelEvent = uiLastMouseWheelEvent;
    isMousePressed = mousePressed;
    isKeyPressed = keyPressed; 
    for (int i = elements.size()-1; i >= 0; i--) {
        UIElement e = elements.get(i);
        e.update();
    }
    wasMousePressed = isMousePressed;
    wasKeyPressed = isKeyPressed;
    if(curMouseWheelEvent != null) {
      uiLastMouseWheelEvent = null;
    }
  }
}

public void drawUI() {
  hint(DISABLE_OPTIMIZED_STROKE);
  fill(255, 255, 255);
  rect(width - UI_COLUMN_WIDTH, 0, width, height);
  for (int i = 0; i < elements.size(); i++) {
      UIElement e = elements.get(i);
      e.drawIfVisible();
  }      
}

public void resizeUI(float oldW, float oldH, float newW, float newH) {
  for (int i = elements.size()-1; i >= 0; i--) {
     UIElement e = elements.get(i);
     e.x += (newW - oldW);
     if(e.anchorBottom) {
       e.y += (newH - oldH);
     }
  }
}

public interface Thunk { void apply(); }
public interface ThunkString { void apply(String s); }

class UIElement {
  int x, y;
  public boolean visible = true;  
  public boolean anchorBottom = false;
  
  UIElement() {  
    elements.add(this);
  }
  UIElement(UIGroup g) {    
    elements.add(this);
    if(g != null) {
      g.add(this);
    }
  }
  
  public void setVisible(boolean b) {
    visible = b;
  }
  public void update() {}
  public void drawIfVisible() {
    if(visible) {
      draw();
    }
  }
  public void draw() {}
}

class UIGroup extends UIElement {
  private ArrayList<UIElement> elements = new ArrayList<UIElement>();
  
  UIGroup() {}
  UIGroup(UIGroup g) {
    super(g);
  }
  
  public void add(UIElement e) {
    elements.add(e);
  }
  
  public void setVisible(boolean b) {
    for (int i = elements.size()-1; i >= 0; i--) {
     UIElement e = elements.get(i);
     e.setVisible(b);
    }
  }
}

class Label extends UIElement {
  String t;
  
  Label(String tIn, int yIn, UIGroup g) {
    super(g);
    y = yIn;
    t = tIn;
  }
  
  public void draw() {
    fill(0, 0, 0);    
    text(t, width - UI_COLUMN_WIDTH + 5, y, UI_COLUMN_WIDTH, 20);
  }
}

class Line extends UIElement {
  Line(int yIn, UIGroup g) {
    super(g);
    y = yIn;
  }
  
  public void draw() {
    stroke(0, 0, 0);
    strokeWeight(2.0f);
    line(width - UI_COLUMN_WIDTH, y, width, y);
  }
}

class Button extends UIElement {
  int w, h;
  String t, tip;
  boolean highlight = false;
  Thunk onClick;
  boolean isCheckbox;
  public boolean selected;
  String group;
  
  Button(String tIn, String tipIn, boolean isCheckboxIn, String groupIn, int xIn, int yIn, int wIn, int hIn, Thunk onClickIn, UIGroup uigroup) {
    super(uigroup);
    x = xIn; y = yIn; w = wIn; h = hIn;
    t = tIn;
    tip = tipIn;
    onClick = onClickIn;
    isCheckbox = isCheckboxIn;
    group = groupIn;
    selected = false;
  }
  
  public void apply() {
    onClick.apply();
    if(isCheckbox) {
      selected = !selected;
    } else if(group != null) {
      for (int i = elements.size()-1; i >= 0; i--) {
        UIElement e = elements.get(i);
        if(e instanceof Button) {
          Button b = (Button)e;
          if((b.group != null) && b.group.equals(group)) {
            b.selected = false;
          }
        }
      }
      selected = true;
    }
  }
  
  public void update() {
    if((mouseX > x) && (mouseX < x + w) && (mouseY > y) && (mouseY < y + h)) {
      highlight = true;
      if(wasMousePressed && !isMousePressed) {
        apply();
      }
    } else {
      highlight = false;
    }
    if(!uiTakesKeyInput() && wasKeyPressed && !isKeyPressed && (key == tip.charAt(0))) {
      apply();
    }
  }
    
  public void draw() {
    if(highlight) {
      fill(220, 220, 220);
    } else {
      fill(192, 192, 192);
    }
    stroke(0, 0, 0);
    rect(x, y, w, h);
    if(selected) {
      fill(255, 255, 255);
    } else {
      fill(0, 0, 0);
    }
    textAlign(CENTER, CENTER);
    text(t, x, y, w, h);
    textAlign(LEFT, TOP);
    text(tip, x + 1, y + 1, w, h);
    
  }
}

public boolean contains(float x, float y, float w, float h) {
  return ((mouseX > x) && (mouseX < (x + w)) && (mouseY > y) && (mouseY < (y + h)));
}

class VectorEditor extends UIGroup {
  TextBox x, y, z;
  ColorPicker cp;
  Thunk thunk;
  
  VectorEditor(String t1, String t2, String t3, boolean showZ, boolean useColorPickerIn, int xStart, int yStart, Thunk thunkIn, UIGroup group) {
    super(group);
    thunk = thunkIn;
    x = new TextBox("", t1, xStart, yStart, 63, 25, thunkIn, this );
    y = new TextBox("", t2, xStart + 73, yStart, 63, 25, thunkIn, this );
    if(showZ) {
      z = new TextBox("", t3, xStart + 73 + 73, yStart, 63, 25, thunkIn, this );
    }
    if(useColorPickerIn) { 
      cp = new ColorPicker(xStart - 150, yStart, 255, 0, 0, new Thunk() { @Override public void apply() { x.t = floatToString(cp.r / 255.0f); y.t = floatToString(cp.g / 255.0f); z.t = floatToString(cp.b / 255.0f); thunk.apply(); } }, this);
      cp.visible = false;
    }
  }
  
  public void update() {
    if(contains(x.x + 73 + 73 + 35, x.y - 12, 35, 10)) {
      if(wasMousePressed && !isMousePressed) {
        cp.visible = true;
      }      
    }
  }
  public void draw() {
    if(cp != null) {
      stroke(255, 255, 255);
      fill(PApplet.parseFloat(x.t) * 255, PApplet.parseFloat(y.t) * 255, PApplet.parseFloat(z.t) * 255);
      rect(x.x + 73 + 73 + 35, x.y - 12, 35, 10);
    }
  }
  
  public void setVisible(boolean b) {
    this.visible = b;
    x.setVisible(b);
    y.setVisible(b);
    if(z != null) {
      z.setVisible(b);
    }
    return;
  }
  
  public void updateText(Vector3f v) {
    x.t = floatToString(v.x);
    y.t = floatToString(v.y);
    if(z != null) {
      z.t = floatToString(v.z);
    }
  }
  
  public void updateValues(Vector3f v) {
    v.x = PApplet.parseFloat(x.t);
    v.y = PApplet.parseFloat(y.t);
    if(z != null) {
      v.z = PApplet.parseFloat(z.t);
    }
  }
}

class UIImage extends UIElement {
  int w, h;
  PImage image;
  
  UIImage(int xIn, int yIn, int wIn, int hIn, UIGroup group) {
    super(group);
    x = xIn; y = yIn;
    w = wIn;
    h = hIn;
  }
  
  public void draw() {
    fill(228, 228, 228);
    rect(x - 2, y - 2, w + 4, h + 4);
    if(image != null) {
      image(image, x, y, w, h);
    }
  }
}

class DropDownList extends UIElement {
  int w, h;
  ArrayList<String> options;
  int selectedOption;
  boolean open;
  Thunk valueChanged;
  int currentTopOptionShown;
  
  DropDownList(ArrayList<String> optionsIn, int xIn, int yIn, int wIn, int hIn, Thunk valueChangedIn, UIGroup group) {
    super(group);
    x = xIn; y = yIn;
    w = wIn;
    h = hIn;
    options = optionsIn;
    open = false;
    valueChanged = valueChangedIn;
    selectedOption = 0;    
    currentTopOptionShown = 0;
  }  
  
  public void update() {
    int s = min(options.size(), DROP_DOWN_MAX);
    if((mouseX > x) && (mouseX < x + w) && (mouseY > y) && (mouseY < y + h)) {
      if(wasMousePressed && !isMousePressed) {
        open = !open;
      }      
    } else if (open &&
               (mouseX > (x + 10)) && (mouseX < (x + w - 10)) &&
               (mouseY > (y + h)) && (mouseY < (y + h + s * h))) {
        //println("mouseover");
      if(wasMousePressed && !isMousePressed) {        
        selectedOption = ((mouseY - (y + h)) / h) + currentTopOptionShown;
        currentTopOptionShown = selectedOption;
        if(currentTopOptionShown > (options.size() - DROP_DOWN_MAX - 1)) {
          currentTopOptionShown = (options.size() - DROP_DOWN_MAX - 1);
        }
        if(currentTopOptionShown < 0) {
          currentTopOptionShown = 0;
        }
        open = false;
        valueChanged.apply();
      } else if (curMouseWheelEvent != null) { 
        float e = curMouseWheelEvent.getCount();
        if(e > 0.0f) {
          currentTopOptionShown++;
          if(currentTopOptionShown > (options.size() - DROP_DOWN_MAX - 1)) {
            currentTopOptionShown = (options.size() - DROP_DOWN_MAX - 1);
          }
          if(currentTopOptionShown < 0) {
            currentTopOptionShown = 0;
          }
        } else {
          currentTopOptionShown--;
          if(currentTopOptionShown < 0) {
            currentTopOptionShown = 0;
          }
        }
      }
    } else {
      if(wasMousePressed && !isMousePressed) {
        open = false;
      }
    }
  }
  
  public void draw() {
    fill(255, 255, 255);
    stroke(0, 0, 0);
    rect(x, y, w, h);
    fill(0, 0, 0);
    textAlign(LEFT, CENTER);
    int s = min(options.size(), DROP_DOWN_MAX);
    if(selectedOption < options.size()) {
      text(options.get(selectedOption), x + 2, y, w, h);
    }
    triangle(x + w - 10, y + 5,
             x + w - 4, y + 5,
             x + w - 7, y + 11);
    if(open) {
      fill(255, 255, 255);
      rect(x + 10, y + h, w - 10, s * h);
      fill(0, 0, 0);
      for(int i = 0 ; i < s; ++i) {
        text(options.get(i + currentTopOptionShown), x + 12, y + h + i * h, w - 10, h);
      }
    }
  }
}

class ColorPicker extends UIElement {
  Thunk valueUpdated;
  float hue;
  float saturation;
  float value;
  float r, g, b;
  
  ColorPicker(int xIn, int yIn, int rIn, int gIn, int bIn, Thunk valueUpdatedIn, UIGroup group) {
    super(group);
    x = xIn; y = yIn;
    if(y + 160 > height) {
      y = height - 160;
    }
    r = rIn; g = gIn; b = bIn;
    valueUpdated = valueUpdatedIn;
    hue = 120.0f;
    saturation = 0.5f;
    value = 0.5f;
  }
  
  
  public boolean takesMouseInput() {
    return (visible &&
       contains(x, y , 130, 160));
  }
  
  public void update() {
    if(visible) {
      if(contains(x + 10, y + 5, 100, 150)) { 
        if(isMousePressed) {
          Vector3f hsv = new Vector3f(hue, (mouseX - (x + 10)) / 100.0f, (mouseY - (y + 5)) * (1.0f / 150.0f));
          Vector3f rgb = hsvToRgb(hsv);
          saturation = (mouseX - (x + 10)) / 100.0f;
          value = (mouseY - (y + 5)) * (1.0f / 150.0f);
          r = rgb.x;
          g = rgb.y;
          b = rgb.z;
          valueUpdated.apply();
        }
      }
      if(contains(x + 115, y + 5, 10, 100)) {   
        if(isMousePressed) { 
          Vector3f hsv = new Vector3f((mouseY - (y + 5)) * (360.0f / 100.0f), saturation, value);
          Vector3f rgb = hsvToRgb(hsv);
          hue = (mouseY - (y + 5)) * (360.0f / 100.0f);
          r = rgb.x;
          g = rgb.y;
          b = rgb.z;
          valueUpdated.apply();
        }
      }
      if(contains(x + 115, y + 145, 15, 15)) {  
        if(wasMousePressed && !isMousePressed) {  
          visible = false;
        }
      }
    }
  }
  
  public void draw() {
    fill(128, 128, 128);
    stroke(255, 255, 255);
    rect(x, y, 130, 160);
    //colorMode(HSB, 100);
    int d = 1;//displayDensity();
    float dw = 100 * d;
    float dh = 150 * d;
    float dxh = 10 * d;
    for (int s = 0; s < dw; s++) {
      for(int v = 0; v < dh; v++) {
        Vector3f hsv = new Vector3f(hue, s / dw, v / dh);
        Vector3f rgb = hsvToRgb(hsv);
        set((x + 10) * d + s, (y + 5) * d + v, color(rgb.x, rgb.y, rgb.z));        
      }
    }
    for(int h = 0; h < dw; h++) {
      for(int xh = 0; xh < dxh; xh++) {
        Vector3f hsv = new Vector3f(h * (360.0f / dw), 1.0f, 1.0f);
        Vector3f rgb = hsvToRgb(hsv);
        set((x + 115) * d + xh, (y + 5) * d + h, color(rgb.x, rgb.y, rgb.z));
      }
    }
    fill(255, 255, 255);
    stroke(0, 0, 0);
    circle(x + 121, y + 151, 12);
    line(x + 118, y + 148, x + 124, y + 154);
    line(x + 118, y + 154, x + 124, y + 148);
    //colorMode(RGB, 255);
  }
}

class TextBox extends UIElement {
  int w, h;
  String t;
  String label;
  public boolean focused;
  Thunk valueUpdated;
  int caretPos;
  
  TextBox(String tIn, String labelIn, int xIn, int yIn, int wIn, int hIn, Thunk valueUpdatedIn, UIGroup group) {
    super(group);
    x = xIn; y = yIn; w = wIn; h = hIn;
    t = tIn;
    label = labelIn;
    caretPos = 0;
    focused = false;
    valueUpdated = valueUpdatedIn;
  }
  
  public void draw() {
    fill(192, 128, 128);
    stroke(0, 0, 0);
    rect(x, y, w, h);
    
    fill(0, 0, 0);
    textAlign(LEFT, CENTER);
    text(label, x, y - 22, w, h);
    text(t, x + 2, y, w, h);
    if(visible && focused && (frameCount % 8 < 4)) {
      float c = 0;
      if(caretPos <= t.length()) {
        c = textWidth(t.substring(0, caretPos));
      }
      if(c < w - 4) {
        text("_", x + 2 + c, y, w, h);
      }
    }
  }
  
  public void update() {
    if(wasMousePressed && !isMousePressed) {
       if(visible && (mouseX > x) && (mouseX < x + w) && (mouseY > y) && (mouseY < y + h)) {
         focused = true;
         caretPos = t.length();
       } else {
         if(focused) {
          valueUpdated.apply();
         }
         focused = false;
       }
    }
    if(visible && focused) {
      for(int k = 0; k < 1024; k++) {
        if(keyDown[k] && !lastKeyDown[k]) {
          if((k != ENTER) && (k != BACKSPACE)) {
            if(caretPos == t.length()) {
              t = t + key;
            } else {
              t = t.substring(0, caretPos) + key + t.substring(caretPos, t.length());
            }
            keyDown[k] = false;
            caretPos++;
          }
        }
        if(keyCodeDown[k] && !lastKeyCodeDown[k]) {
          if(k == TAB) {
            int i = elements.indexOf(this);
            if(i < (elements.size() - 1)) {
              UIElement uie = elements.get(i + 1);
              if(uie instanceof TextBox) {
                ((TextBox)uie).focused = true;
              }
            }
            valueUpdated.apply();
            keyCodeDown[k] = false;
            focused = false;
            
          } else if ((k == ENTER) || (k == ESC)) {
            valueUpdated.apply();
            keyCodeDown[k] = false;
            focused = false;
          } else if (k == LEFT) {
            if(caretPos > 0) caretPos--;
            keyCodeDown[k] = false;
          } else if (k == RIGHT) {
            if(caretPos < t.length()) caretPos++;
            keyCodeDown[k] = false;
          } else if(k == BACKSPACE) {
            if((caretPos == t.length()) && (caretPos > 0)) {
              t = t.substring(0, max(0, t.length()-1));
              caretPos--;
            } else if(caretPos > 0) {
              t = t.substring(0, caretPos - 1) + t.substring(caretPos, t.length());
              caretPos--;
            }        
            keyCodeDown[k] = false;
          }
        }
      }
    }
  }
}
Stack<UndoRecord> undoRecords = new Stack<UndoRecord>();

public void undo() {
  if(!undoRecords.empty()) {
    undoRecords.pop().undo();
  }
}

class UndoRecord {
  UndoRecord() {
    undoRecords.push(this);
  }
  
  public void undo() {
  }
}

class UndoRecordDeletion extends UndoRecord {
  ArrayList<Face> deletedFaces;
  ArrayList<Vertex> deletedVertices;
  
  UndoRecordDeletion() {
    super();
    deletedFaces = new ArrayList<Face>();  
    deletedVertices = new ArrayList<Vertex>();
  }
  
  public void addFace(Face f) {
    deletedFaces.add(f);
  }
  
  public void addVertex(Vertex v) {
    deletedVertices.add(v);
  }
  
  public void undo() {
    for(int i = 0; i < deletedVertices.size(); ++i) {
      vertices.add(deletedVertices.get(i));      
    }
    for(int i = 0; i < deletedFaces.size(); ++i) {
      faces.add(deletedFaces.get(i));      
    }
  }
}

class UndoFaceAddition extends UndoRecord {
  Face addedFace;
  
  UndoFaceAddition(Face f) {
    super();
    addedFace = f;
  }
  
  public void undo() {
    faces.remove(addedFace);
  }
}

class UndoVertexAddition extends UndoRecord {
  Vertex addedVertex;
  
  UndoVertexAddition(Vertex v) {
    super();
    addedVertex = v;
  }
  
  public void undo() {
    vertices.remove(addedVertex);
  }
}

class UndoVertexMovementRecord {
  Vertex v;
  Vector3f pos;
}

class UndoVertexMovement extends UndoRecord {
  ArrayList<UndoVertexMovementRecord> movedVertices;
  
  UndoVertexMovement() {
    super();
    movedVertices = new ArrayList<UndoVertexMovementRecord>();
  }
  
  public void addVertex(Vertex v) {
    UndoVertexMovementRecord uvmr = new UndoVertexMovementRecord();
    uvmr.v = v;
    uvmr.pos = new Vector3f(v.x, v.y, v.z);
    movedVertices.add(uvmr);
  }
  
  public void undo() {
    for(UndoVertexMovementRecord uvmr : movedVertices) {
      println("undo " + uvmr.v.x + " , " + uvmr.pos.x);
      uvmr.v.x = uvmr.pos.x;
      uvmr.v.y = uvmr.pos.y;
      uvmr.v.z = uvmr.pos.z;      
    }
  }
}
class Window {
  int viewType;
  int x, y, w, h;
  boolean mouseInWindow;
  float mX, mY;
  boolean selecting;
  
  float selectMouseStartX, selectMouseStartY;
  float selectMouseEndX, selectMouseEndY;
  
  Matrix4f modelViewMatrix;
  
  UndoVertexMovement currentUvm = null;
  
  PGraphics g;
  Camera c;
  Vector3f debugPoint = new Vector3f();
  Vector3f debugRayStart = new Vector3f();
  Vector3f debugRay = new Vector3f();
  
  Window(int xIn, int yIn, int wIn, int hIn, int viewTypeIn) {
    viewType = viewTypeIn;
    x = xIn; y = yIn; w = wIn; h = hIn;
    modelViewMatrix = new Matrix4f();
    
    if(viewType != VIEW_3D) {
      modelViewMatrix = modelViewMatrix.scale(VIEW_SCALE, VIEW_SCALE, VIEW_SCALE);
    } else {
      modelViewMatrix.setLookAt(0.0f, 0.0f, 10.0f,
        0.0f, 0.0f, 0.0f, 
        0.0f, -1.0f, 0.0f);
    }
    selecting = false;
    
    g = createGraphics(w, h, P3D);
    if(viewType == VIEW_3D) {
      c = new Camera(this);
    }
  }
  
  public void resize(int xIn, int yIn, int wIn, int hIn) {    
    x = xIn; y = yIn; w = wIn; h = hIn;
    g.dispose();
    g = createGraphics(w, h, P3D);
  }
    
  public boolean processMousePosition() {
    mouseInWindow = ((mouseX >= x) && ((mouseX - x) < w) && (mouseY >= y) && ((mouseY - y) < h));
    mX = mouseX - x - (w / 2);
    mY = mouseY - y - (h / 2);
    
    return mouseInWindow;
  }
 
  
  public void mouseWheel(MouseEvent event) {
    if(!processMousePosition())
      return;
    float e = event.getCount();
    float s = (e > 0.0f) ? SCROLL_MULTIPLIER : (1.0f / SCROLL_MULTIPLIER);
    if(keyPressed && keyCode == SHIFT) {
      s *= SCROLL_SHIFT_MULTIPLIER;
    }
    if(viewType == VIEW_3D) {
      s = SCROLL_3D_MOVE;
      if(keyPressed && keyCode == SHIFT) {
        s *= SCROLL_SHIFT_MULTIPLIER;
      }
      c.moveForward((e == 0.0f) ? 0.0f : (e > 0.0f ? s : -s));
    } else {
      if (e != 0.0f) {
        modelViewMatrix = modelViewMatrix.scale(s, s, s);
      }
    }
  }
  
  // Function to get the position of the viewpoint in the current coordinate system
  public Vector3f getEyePosition() {
    PMatrix3D mat = (PMatrix3D)g.getMatrix(); //Get the model view matrix
    mat.invert();
    return new Vector3f( mat.m03, mat.m13, mat.m23 );
  }
  
  
  public Vector3f unProject(float winX, float winY) {
    float x = winX / (w / 2);
    float y = -(winY / (h / 2));
    float z = 1.0f;
    Vector3f ray_nds = new Vector3f(x, y, z);
    
    PMatrix3D projection = new PMatrix3D(((PGraphics3D)g).projection); 
    PMatrix3D modelview = new PMatrix3D(((PGraphics3D)g).modelview); 
    PMatrix3D mvp = new PMatrix3D();
    mvp.apply(projection);
    mvp.apply(modelview);
    projection.invert();
    modelview.invert();
    float[] in = {ray_nds.x, ray_nds.y, -1.0f, 1.0f};
    float[] out = new float[4];
    projection.mult(in, out);
    Vector4f ray_eye = new Vector4f(out[0], out[1], -1.0f, 0.0f);
    float[] in2 = { ray_eye.x, ray_eye.y, ray_eye.z, ray_eye.w };
    modelview.mult(in2, out);
    Vector3f ray_wor = new Vector3f(out[0], out[1], out[2]);
    ray_wor.normalize();
    return ray_wor;
    
  }
  
  //Returns true if this point - which is presumed to be in the plane of Face f - is inside that
  //Face.
  public boolean triangleContainsPointInPlane(Face f, Vector3f q, Vector3f n) {    
    Vector3f e1 = new Vector3f(f.v2.v.x  - f.v1.v.x, f.v2.v.y - f.v1.v.y, f.v2.v.z - f.v1.v.z);
    Vector3f e2 = new Vector3f(f.v3.v.x  - f.v2.v.x, f.v3.v.y - f.v2.v.y, f.v3.v.z - f.v2.v.z);
    Vector3f e3 = new Vector3f(f.v1.v.x  - f.v3.v.x, f.v1.v.y - f.v3.v.y, f.v1.v.z - f.v3.v.z);
    
    Vector3f c0 = new Vector3f(q.x - f.v1.v.x, q.y - f.v1.v.y, q.z - f.v1.v.z);
    Vector3f c1 = new Vector3f(q.x - f.v2.v.x, q.y - f.v2.v.y, q.z - f.v2.v.z);
    Vector3f c2 = new Vector3f(q.x - f.v3.v.x, q.y - f.v3.v.y, q.z - f.v3.v.z);
    Vector3f cp0 = new Vector3f();
    Vector3f cp1 = new Vector3f();
    Vector3f cp2 = new Vector3f();
    e1.cross(c0, cp0);  //cp0 = e1 x c0
    e2.cross(c1, cp1);  //cp1 = e2 x c1
    e3.cross(c2, cp2);  //cp2 = e3 x c2
    
    float dp0 = n.dot(cp0);
    float dp1 = n.dot(cp1);
    float dp2 = n.dot(cp2);
    return (((dp0 > 0) && (dp1 > 0) && (dp2 > 0)) ||
            ((dp0 < 0) && (dp1 < 0) && (dp2 < 0)));
  }  
  
  public boolean rayIntersectsTriangle(Face f, Vector3f ray, Vector3f eye, Vector3f n, Vector3f result) {
    float t = ((f.v1.v.x * n.x + f.v1.v.y * n.y + f.v1.v.z * n.z) -
               (eye.x * n.x + eye.y * n.y + eye.z * n.z)) /
               (ray.x * n.x + ray.y * n.y + ray.z * n.z);
    Vector3f q = new Vector3f(eye.x + ray.x * t, eye.y + ray.y * t, eye.z + ray.z * t);
    result.set(q);    
    debugPoint = q;
    boolean r = triangleContainsPointInPlane(f, q, n);
    return r;
  }  
  
  public boolean rayIntersects(Face f, Vector3f result) {
    Vector3f n = faceNormal(f);          
    Vector3f eye = getEyePosition();
    switch(viewType) {
        case VIEW_X:   
        {
          Vector3f ray = new Vector3f(1.0f, 0.0f, 0.0f);
          Vector3f mousePos = new Vector3f(0.0f, -mY, mX);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          eye.y = mousePos.y;
          eye.z = mousePos.z;
          return rayIntersectsTriangle(f, ray, eye, n, result);
        }
        case VIEW_Y:
        {
          Vector3f ray = new Vector3f(0.0f, 1.0f, 0.0f);
          Vector3f mousePos = new Vector3f(mX, 0.0f, -mY);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          eye.x = mousePos.x;
          eye.z = mousePos.z;
          return rayIntersectsTriangle(f, ray, eye, n, result);
        }
        case VIEW_Z:
        {
          Vector3f ray = new Vector3f(0.0f, 0.0f, 1.0f);
          Vector3f mousePos = new Vector3f(-mX, -mY, 0.0f);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          eye.x = mousePos.x;
          eye.y = mousePos.y;
          return rayIntersectsTriangle(f, ray, eye, n, result);
        }
        case VIEW_3D:
        {         
          Vector3f pointOnScreen = unProject(selectMouseStartX, selectMouseStartY);          
          Vector3f ray = new Vector3f(pointOnScreen.x, pointOnScreen.y, pointOnScreen.z);
          ray.normalize();
          return rayIntersectsTriangle(f, ray, eye, n, result);
        }
      }
      return false;
  }
  
  public void mouseClicked() {
    if(!processMousePosition())
      return;
    if(mode == MODE_SELECT_FACE) {
      if(viewType == VIEW_3D) {
        g.perspective(PI/3.0f, ((float)w) / h, .01f, 10000.0f);
        g.resetMatrix();
        g.applyMatrix(modelViewMatrix.m00(), modelViewMatrix.m10(), modelViewMatrix.m20(), modelViewMatrix.m30(),
          modelViewMatrix.m01(), modelViewMatrix.m11(), modelViewMatrix.m21(), modelViewMatrix.m31(),
          modelViewMatrix.m02(), modelViewMatrix.m12(), modelViewMatrix.m22(), modelViewMatrix.m32(),
          modelViewMatrix.m03(), modelViewMatrix.m13(), modelViewMatrix.m23(), modelViewMatrix.m33());        
      }
      Vector3f eye = getEyePosition();
      Face closestIntersection = null;
      Vector3f result = new Vector3f();
      float curMinDistance = MAX_FLOAT;
      for(int i = faces.size() - 1; i >= 0; i--) {
        Face f = faces.get(i);
        if(rayIntersects(f, result)) {
          float d = result.distance(eye);
          if(d < curMinDistance) {
            curMinDistance = d;
            closestIntersection = f;
          }
        }
      }
      if(keyPressed && keyCode == SHIFT) {
        if(closestIntersection != null) {
          closestIntersection.selected = true;
        }
      } else if (keyPressed && keyCode == CONTROL) {
        if(closestIntersection != null) {
          closestIntersection.selected = false;
        }
      } else {
        for(int i = faces.size() - 1; i >= 0; i--) {
          Face f = faces.get(i);
          f.selected = false;
        }
        if(closestIntersection != null) {
          closestIntersection.selected = true;
        }
      } 
      updateSelected();
    } else if(mode == MODE_SELECT_VERTEX) {
      selectMouseStartX -= 3;
      selectMouseStartY -= 3;
      selectMouseEndX += 3;
      selectMouseEndY += 3;
      if(viewType == VIEW_3D) {
        
      g.perspective(PI/3.0f, ((float)w) / h, .01f, 10000.0f);
      g.resetMatrix();
      g.applyMatrix(modelViewMatrix.m00(), modelViewMatrix.m10(), modelViewMatrix.m20(), modelViewMatrix.m30(),
        modelViewMatrix.m01(), modelViewMatrix.m11(), modelViewMatrix.m21(), modelViewMatrix.m31(),
        modelViewMatrix.m02(), modelViewMatrix.m12(), modelViewMatrix.m22(), modelViewMatrix.m32(),
        modelViewMatrix.m03(), modelViewMatrix.m13(), modelViewMatrix.m23(), modelViewMatrix.m33());        
      }
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(selectHelper(v) ||
           ((keyPressed && keyCode == SHIFT) && v.selected))
        {
          if(keyPressed && keyCode == CONTROL) {
            v.selected = false;
          } else {
            v.selected = true;
          }
        } else {
          if(!(keyPressed && keyCode == CONTROL)) {
            v.selected = false;
          }
        }
      }
      updateSelected();
    } else if(mode == MODE_PLACE) { 
      switch(viewType) {
        case VIEW_X:   
        {
          Vector3f mousePos = new Vector3f(0.0f, -mY, mX);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          if(snapToGridCheckbox.selected) {
            mousePos.y = round(mousePos.y / STARTING_SCALE) * STARTING_SCALE;
            mousePos.z = round(mousePos.z / STARTING_SCALE) * STARTING_SCALE;
          }
          Vertex newVertex = new Vertex(0.0f, mousePos.y, mousePos.z);
          vertices.add(newVertex);
          new UndoVertexAddition(newVertex);
        }
        break;
        case VIEW_Y:
        {
          Vector3f mousePos = new Vector3f(mX, 0.0f, -mY);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          if(snapToGridCheckbox.selected) {
            mousePos.x = round(mousePos.x / STARTING_SCALE) * STARTING_SCALE;
            mousePos.z = round(mousePos.z / STARTING_SCALE) * STARTING_SCALE;
          }
          Vertex newVertex = new Vertex(mousePos.x, 0.0f, mousePos.z);
          vertices.add(newVertex);
          new UndoVertexAddition(newVertex);
        }
        break;
        case VIEW_Z:
        {
          Vector3f mousePos = new Vector3f(-mX, -mY, 0.0f);
          mousePos = modelViewMatrix.transformPosition(mousePos);
          if(snapToGridCheckbox.selected) {
            mousePos.x = round(mousePos.x / STARTING_SCALE) * STARTING_SCALE;
            mousePos.y = round(mousePos.y / STARTING_SCALE) * STARTING_SCALE;
          }
          Vertex newVertex = new Vertex(mousePos.x, mousePos.y, 0.0f);
          vertices.add(newVertex);
          new UndoVertexAddition(newVertex);
        }
        break;
        case VIEW_3D:
        break;
      }
    }
  }
  
  public void mousePressed() {
    if(!processMousePosition())
      return;
    if(mouseButton == LEFT) {
      if(mode == MODE_SELECT_VERTEX || mode == MODE_SELECT_FACE) {
        selecting = true;
      } else if (mode == MODE_MOVE) {
      } else if (mode == MODE_ROTATE) {
      }
    } 
    selectMouseStartX = mX;
    selectMouseStartY = mY;
    selectMouseEndX = mX;
    selectMouseEndY = mY;
  }

  public float getScaleFactor(float start, float end) {
    float diff = end - start;
    float baseScale = 1.0f;
    if(diff > 0.0f) {
      baseScale = pow(GEOM_SCALING_FACTOR, diff);
    } else if (diff < 0.0f) {
      baseScale = (1.0f / pow(GEOM_SCALING_FACTOR, -diff));
    } 
    return baseScale;
  }
  
  public void mouseDragged() {
    if(!processMousePosition())
      return;
    selectMouseEndX = mX;
    selectMouseEndY = mY;
    Vector3f scale = new Vector3f();
    modelViewMatrix.getScale(scale);
    
    float gridOffsetX = 0.0f;
    float gridOffsetY = 0.0f;
    if(viewType == VIEW_3D) {
      c.mouseDragged();
    }
    if(keyPressed && key == ' ') {
      switch(viewType) {
        case VIEW_X:
          modelViewMatrix = modelViewMatrix.translate(0.0f,
            (selectMouseEndY - selectMouseStartY),            
            -(selectMouseEndX - selectMouseStartX)); 
          break;
        case VIEW_Y:
          modelViewMatrix = modelViewMatrix.translate(-(selectMouseEndX - selectMouseStartX),
            0.0f,
            (selectMouseEndY - selectMouseStartY));        
          break;
        case VIEW_Z:
          modelViewMatrix = modelViewMatrix.translate((selectMouseEndX - selectMouseStartX),
            (selectMouseEndY - selectMouseStartY),
            0.0f);
          break;
        case VIEW_3D:
          c.pan((selectMouseEndX - selectMouseStartX),
            -(selectMouseEndY - selectMouseStartY));
          break;
      }
      selectMouseStartX = selectMouseEndX;
      selectMouseStartY = selectMouseEndY;
      selecting = false;
    } else if(mode == MODE_MOVE) {
      boolean needsAdding = (currentUvm == null);
      if(needsAdding) {
        currentUvm = new UndoVertexMovement();
      }
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(v.selected) {
          if(needsAdding) {
            currentUvm.addVertex(v);
          }
          switch(viewType) {
            case VIEW_X:
            { 
              v.z += (selectMouseEndX - selectMouseStartX) * scale.z;
              v.y -= (selectMouseEndY - selectMouseStartY) * scale.z;
              if(snapToGridCheckbox.selected) {
                float vGY = round(v.y / STARTING_SCALE) * STARTING_SCALE;
                float vGZ = round(v.z / STARTING_SCALE) * STARTING_SCALE;
                gridOffsetX = (v.z - vGZ);
                gridOffsetY = -(v.y - vGY);
                v.y = vGY;
                v.z = vGZ;
              }
            }
            break;
            case VIEW_Y:
            { 
              v.x += (selectMouseEndX - selectMouseStartX) * scale.z;
              v.z -= (selectMouseEndY - selectMouseStartY) * scale.z;
              if(snapToGridCheckbox.selected) {
                float vGX = round(v.x / STARTING_SCALE) * STARTING_SCALE;
                float vGZ = round(v.z / STARTING_SCALE) * STARTING_SCALE;
                gridOffsetX = (v.x - vGX);
                gridOffsetY = -(v.z - vGZ);
                v.x = vGX;
                v.z = vGZ;
              }
            }
            break;
            case VIEW_Z:
            { 
              v.x -= (selectMouseEndX - selectMouseStartX) * scale.z;
              v.y -= (selectMouseEndY - selectMouseStartY) * scale.z;
              if(snapToGridCheckbox.selected) {
                float vGX = round(v.x / STARTING_SCALE) * STARTING_SCALE;
                float vGY = round(v.y / STARTING_SCALE) * STARTING_SCALE;
                gridOffsetX = -(v.x - vGX);
                gridOffsetY = -(v.y - vGY);
                v.x = vGX;
                v.y = vGY;
              }
            }
            break;
            case VIEW_3D:
            break;
          }
        }
      }
      updateSelected();
      selectMouseStartX = selectMouseEndX - (gridOffsetX / scale.z);
      selectMouseStartY = selectMouseEndY - (gridOffsetY / scale.z);
    }  else if (mode == MODE_ROTATE) {
      println("hi1");
      for(Vertex v: vertices) {
        if(v.selected) {
          switch(viewType) {
            case VIEW_X:
            { 
              Vector3f ve = new Vector3f(v.x, v.y, v.z);
              ve.rotateX(-((selectMouseStartX - selectMouseEndX) + (selectMouseEndY - selectMouseStartY)) * scale.z * 0.1f);
              //ve.rotateY(-(selectMouseEndX - selectMouseStartX) * scale.z);
              //ve.rotateZ(-(selectMouseEndY - selectMouseStartY) * scale.z);
              v.x = ve.x; v.y = ve.y; v.z = ve.z;
            }
            break;
            case VIEW_Y:
            {
              Vector3f ve = new Vector3f(v.x, v.y, v.z);
              ve.rotateY(-((selectMouseStartX - selectMouseEndX) + (selectMouseEndY - selectMouseStartY)) * scale.z * 0.1f);
              //ve.rotateZ(-(selectMouseEndX - selectMouseStartX) * scale.z);
              //ve.rotateX(-(selectMouseEndY - selectMouseStartY) * scale.z);
              v.x = ve.x; v.y = ve.y; v.z = ve.z;
            }
            break;
            case VIEW_Z:
            {
              Vector3f ve = new Vector3f(v.x, v.y, v.z);
              ve.rotateZ(-((selectMouseStartX - selectMouseEndX) + (selectMouseEndY - selectMouseStartY)) * scale.z * 0.1f);
              //ve.rotateY((selectMouseEndX - selectMouseStartX) * scale.z);
              //ve.rotateX(-(selectMouseEndY - selectMouseStartY) * scale.z);
              v.x = ve.x; v.y = ve.y; v.z = ve.z;
            }
            break;
            case VIEW_3D:
            break;
          }
        }
      }
      selectMouseStartX = selectMouseEndX;
      selectMouseStartY = selectMouseEndY;
    }  else if(mode == MODE_SCALE) {
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(v.selected) {
          switch(viewType) {
            case VIEW_X:
            { 
              float baseScaleZ = getScaleFactor(selectMouseStartX, selectMouseEndX);
              float baseScaleY = getScaleFactor(selectMouseEndY, selectMouseStartY);
              if(ctrlPressed) {
                if(abs(selectMouseStartX - selectMouseEndX) > abs(selectMouseStartY - selectMouseEndY)) {
                  baseScaleY = 1.0f;
                } else {
                  baseScaleZ = 1.0f;
                }
              }
              if(centerOfMassCheckbox.selected) {
                v.y = centerOfMass.y + (v.y - centerOfMass.y) * baseScaleY;
                v.z = centerOfMass.z + (v.z - centerOfMass.z) * baseScaleZ;
              } else {
                v.y *= baseScaleY;
                v.z *= baseScaleZ;
              }
            }
            break;
            case VIEW_Y:
            { 
              float baseScaleX = getScaleFactor(selectMouseStartX, selectMouseEndX);
              float baseScaleZ = getScaleFactor(selectMouseEndY, selectMouseStartY);  
              if(ctrlPressed) {
                if(abs(selectMouseStartX - selectMouseEndX) > abs(selectMouseStartY - selectMouseEndY)) {
                  baseScaleX = 1.0f;
                } else {
                  baseScaleZ = 1.0f;
                }
              }                   
              if(centerOfMassCheckbox.selected) {
                v.x = centerOfMass.x + (v.x - centerOfMass.x) * baseScaleX;
                v.z = centerOfMass.z + (v.z - centerOfMass.z) * baseScaleZ;
              } else {
                v.x *= baseScaleX;
                v.z *= baseScaleZ;
              }
            }
            break;
            case VIEW_Z:
            { 
              float baseScaleX = getScaleFactor(selectMouseStartX, selectMouseEndX);
              float baseScaleY = getScaleFactor(selectMouseEndY, selectMouseStartY);  
              if(ctrlPressed) {
                if(abs(selectMouseStartX - selectMouseEndX) > abs(selectMouseStartY - selectMouseEndY)) {
                  baseScaleX = 1.0f;
                } else {
                  baseScaleY = 1.0f;
                }
              }
              if(centerOfMassCheckbox.selected) {
                v.x = centerOfMass.x + (v.x - centerOfMass.x) * baseScaleX;
                v.y = centerOfMass.y + (v.y - centerOfMass.y) * baseScaleY;
              } else {
                v.x *= baseScaleX;
                v.y *= baseScaleY;
              }
            }
            break;
            case VIEW_3D:
            break;
          }
        }
      }
      updateSelected();
      selectMouseStartX = selectMouseEndX - (gridOffsetX / scale.z);
      selectMouseStartY = selectMouseEndY - (gridOffsetY / scale.z);
    } else if(mode == MODE_SCALE_ALL) {
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(v.selected) {
          switch(viewType) {
            case VIEW_X:
            case VIEW_Y:
            case VIEW_Z:
            { 
              float baseScale = getScaleFactor(selectMouseStartX, selectMouseEndX);
              if(centerOfMassCheckbox.selected) {
                v.x = centerOfMass.x + (v.x - centerOfMass.x) * baseScale;
                v.y = centerOfMass.y + (v.y - centerOfMass.y) * baseScale;
                v.z = centerOfMass.z + (v.z - centerOfMass.z) * baseScale;
              } else {
                v.x *= baseScale;
                v.y *= baseScale;
                v.z *= baseScale;
              }
            }
            break;
            case VIEW_3D:
            break;
          }
        }
      }
      updateSelected();
      selectMouseStartX = selectMouseEndX - (gridOffsetX / scale.z);
      selectMouseStartY = selectMouseEndY - (gridOffsetY / scale.z);
    }
  }
  
  public boolean between(float v, float x1, float x2) {
    return (((v > x1) && (v < x2)) || ((v < x1) && (v > x2)));
  }
   
  public boolean selectHelper(Face f) {
     switch(viewType) {
      case VIEW_X:
      {  
        Vector3f startPos = new Vector3f(0.0f, -selectMouseStartY, selectMouseStartX);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(0.0f, -selectMouseEndY, selectMouseEndX);
        endPos = modelViewMatrix.transformPosition(endPos);        
        return between(f.v1.v.y, startPos.y, endPos.y) && between(f.v1.v.z, startPos.z, endPos.z) &&
               between(f.v2.v.y, startPos.y, endPos.y) && between(f.v2.v.z, startPos.z, endPos.z) &&
               between(f.v3.v.y, startPos.y, endPos.y) && between(f.v3.v.z, startPos.z, endPos.z);
      }
      case VIEW_Y:
      {  
        Vector3f startPos = new Vector3f(selectMouseStartX, 0.0f, -selectMouseStartY);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(selectMouseEndX, 0.0f, -selectMouseEndY);
        endPos = modelViewMatrix.transformPosition(endPos);
        //return between(v.x, startPos.x, endPos.x) && between(v.z, startPos.z, endPos.z);
        return between(f.v1.v.x, startPos.x, endPos.x) && between(f.v1.v.z, startPos.z, endPos.z) &&
               between(f.v2.v.x, startPos.x, endPos.x) && between(f.v2.v.z, startPos.z, endPos.z) &&
               between(f.v3.v.x, startPos.x, endPos.x) && between(f.v3.v.z, startPos.z, endPos.z);
      }
      case VIEW_Z:
      {  
        Vector3f startPos = new Vector3f(-selectMouseStartX, -selectMouseStartY, 0.0f);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(-selectMouseEndX, -selectMouseEndY, 0.0f);
        endPos = modelViewMatrix.transformPosition(endPos);
        //return between(v.x, startPos.x, endPos.x) && between(v.y, startPos.y, endPos.y);
        return between(f.v1.v.x, startPos.x, endPos.x) && between(f.v1.v.y, startPos.y, endPos.y) &&
               between(f.v2.v.x, startPos.x, endPos.x) && between(f.v2.v.y, startPos.y, endPos.y) &&
               between(f.v3.v.x, startPos.x, endPos.x) && between(f.v3.v.y, startPos.y, endPos.y);
      }
      case VIEW_3D:
      { 
        if(!selectBackFacingCheckbox.selected) {
          Vector3f n = faceNormal(f);          
          Vector3f pointOnScreen = unProject(selectMouseStartX, selectMouseStartY);          
          Vector3f ray = new Vector3f(pointOnScreen.x, pointOnScreen.y, pointOnScreen.z);
          ray.normalize();
          println("v = " + (ray.x * n.x + ray.y * n.y + ray.z * n.z));
          if((ray.x * n.x + ray.y * n.y + ray.z * n.z) > 0) {
            return false;
          }
        }
        float vX1 = g.screenX(f.v1.v.x, f.v1.v.y, f.v1.v.z) - w/2;
        float vY1 = g.screenY(f.v1.v.x, f.v1.v.y, f.v1.v.z) - h/2;
        float vX2 = g.screenX(f.v2.v.x, f.v2.v.y, f.v2.v.z) - w/2;
        float vY2 = g.screenY(f.v2.v.x, f.v2.v.y, f.v2.v.z) - h/2;
        float vX3 = g.screenX(f.v3.v.x, f.v3.v.y, f.v3.v.z) - w/2;
        float vY3 = g.screenY(f.v3.v.x, f.v3.v.y, f.v3.v.z) - h/2;
        //print(vX + " , " + vY + " " + selectMouseStartX + " , " + selectMouseStartY + " " + selectMouseEndX + " , " + selectMouseEndY + "\n");
        return between(vX1, selectMouseStartX, selectMouseEndX) && between(vY1, selectMouseStartY, selectMouseEndY) &&
               between(vX2, selectMouseStartX, selectMouseEndX) && between(vY2, selectMouseStartY, selectMouseEndY) &&
               between(vX3, selectMouseStartX, selectMouseEndX) && between(vY3, selectMouseStartY, selectMouseEndY);
      }
     }
     return false;
  }
  
  public boolean selectHelper(Vertex v) {
     switch(viewType) {
      case VIEW_X:
      {  
        Vector3f startPos = new Vector3f(0.0f, -selectMouseStartY, selectMouseStartX);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(0.0f, -selectMouseEndY, selectMouseEndX);
        endPos = modelViewMatrix.transformPosition(endPos);
        return between(v.y, startPos.y, endPos.y) && between(v.z, startPos.z, endPos.z);
      }
      case VIEW_Y:
      {  
        Vector3f startPos = new Vector3f(selectMouseStartX, 0.0f, -selectMouseStartY);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(selectMouseEndX, 0.0f, -selectMouseEndY);
        endPos = modelViewMatrix.transformPosition(endPos);
        return between(v.x, startPos.x, endPos.x) && between(v.z, startPos.z, endPos.z);
      }
      case VIEW_Z:
      {  
        Vector3f startPos = new Vector3f(-selectMouseStartX, -selectMouseStartY, 0.0f);
        startPos = modelViewMatrix.transformPosition(startPos);
        Vector3f endPos = new Vector3f(-selectMouseEndX, -selectMouseEndY, 0.0f);
        endPos = modelViewMatrix.transformPosition(endPos);
        return between(v.x, startPos.x, endPos.x) && between(v.y, startPos.y, endPos.y);
      }
      case VIEW_3D:
      { 
        float vX = g.screenX(v.x, v.y, v.z) - w/2;
        float vY = g.screenY(v.x, v.y, v.z) - h/2;
        //print(vX + " , " + vY + " " + selectMouseStartX + " , " + selectMouseStartY + " " + selectMouseEndX + " , " + selectMouseEndY + "\n");
        return between(vX, selectMouseStartX, selectMouseEndX) && between(vY, selectMouseStartY, selectMouseEndY);
      }
     }
     return false;
  }
  
  public void mouseReleased() {
    currentUvm = null;
    if(!processMousePosition())
      return;
    
    if(selecting && (mode == MODE_SELECT_VERTEX)) {
      if(viewType == VIEW_3D) {
        g.perspective(PI/3.0f, ((float)w) / h, .01f, 10000.0f);
        g.resetMatrix();
        g.applyMatrix(modelViewMatrix.m00(), modelViewMatrix.m10(), modelViewMatrix.m20(), modelViewMatrix.m30(),
          modelViewMatrix.m01(), modelViewMatrix.m11(), modelViewMatrix.m21(), modelViewMatrix.m31(),
          modelViewMatrix.m02(), modelViewMatrix.m12(), modelViewMatrix.m22(), modelViewMatrix.m32(),
          modelViewMatrix.m03(), modelViewMatrix.m13(), modelViewMatrix.m23(), modelViewMatrix.m33());
      }
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(selectHelper(v) ||
           ((keyPressed && keyCode == SHIFT) && v.selected))
        {
          if(keyPressed && keyCode == CONTROL) {
            v.selected = false;
          } else {
            v.selected = true;
          }
        } else {
          if(!(keyPressed && keyCode == CONTROL)) {
            v.selected = false;
          }
        }
      }
      updateSelected();
    } else if(selecting && (mode == MODE_SELECT_FACE)) {
      if(viewType == VIEW_3D) {
        g.perspective(PI/3.0f, ((float)w) / h, .01f, 10000.0f);
        g.resetMatrix();
        g.applyMatrix(modelViewMatrix.m00(), modelViewMatrix.m10(), modelViewMatrix.m20(), modelViewMatrix.m30(),
          modelViewMatrix.m01(), modelViewMatrix.m11(), modelViewMatrix.m21(), modelViewMatrix.m31(),
          modelViewMatrix.m02(), modelViewMatrix.m12(), modelViewMatrix.m22(), modelViewMatrix.m32(),
          modelViewMatrix.m03(), modelViewMatrix.m13(), modelViewMatrix.m23(), modelViewMatrix.m33());
      }
      for (int i = faces.size()-1; i >= 0; i--) {
        Face f = faces.get(i);
        if(selectHelper(f) ||
           ((keyPressed && keyCode == SHIFT) && f.selected))
        {
          if(keyPressed && keyCode == CONTROL) {
            f.selected = false;
          } else {
            f.selected = true;
          }
        } else {
          if(!(keyPressed && keyCode == CONTROL)) {
            f.selected = false;
          }
        }
      }
      updateSelected();
    }
    selecting = false;
  }
  
  public void keyPressed() {   
    if(!processMousePosition())
      return;
    if(viewType == VIEW_3D) {
      c.keyPressed();
    }
  }
  
  public void keyReleased() {   
    if(!processMousePosition())
      return;
    if(viewType == VIEW_3D) {
      c.keyReleased();
      if(key == '`') {
        c.frameModel();
      }
    } else {
      if(key == '`') {
        ArrayList<Vertex> selected = new ArrayList<Vertex>();
        for (Vertex v: vertices) {
          if(v.selected) {
            selected.add(v);
          }
        }
        ArrayList<Face> selectedFaces = new ArrayList<Face>();
        for (Face f: faces) {
          if(f.selected) {
            selectedFaces.add(f);
          }
        }
        Vertex centerOfMass = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex min = new Vertex(MAX_FLOAT, MAX_FLOAT, MAX_FLOAT);
        Vertex max = new Vertex(-MAX_FLOAT, -MAX_FLOAT, -MAX_FLOAT);
        float scale = 1.0f;
        if((selected.size() == 0) && (selectedFaces.size() == 0)) {
          println("hi1");
          for (Vertex v : vertices) {
            centerOfMass.x += v.x * (1.0f / vertices.size());
            centerOfMass.y += v.y * (1.0f / vertices.size());
            centerOfMass.z += v.z * (1.0f / vertices.size());
            min.x = min(min.x, v.x);
            min.y = min(min.y, v.y);
            min.z = min(min.z, v.z);
            max.x = max(max.x, v.x);
            max.y = max(max.y, v.y);
            max.z = max(max.z, v.z);
          }    
        } else if(selected.size() > 0) {
          println("hi2");
          for (Vertex v : selected) {
            centerOfMass.x += v.x * (1.0f / selected.size());
            centerOfMass.y += v.y * (1.0f / selected.size());
            centerOfMass.z += v.z * (1.0f / selected.size());
            min.x = min(min.x, v.x);
            min.y = min(min.y, v.y);
            min.z = min(min.z, v.z);
            max.x = max(max.x, v.x);
            max.y = max(max.y, v.y);
            max.z = max(max.z, v.z);
          }    
        } else {
          println("hi3");
          for (Face f : faces) {
            centerOfMass.x += f.v1.v.x * (0.33333333333f / faces.size());
            centerOfMass.y += f.v1.v.y * (0.33333333333f / faces.size());
            centerOfMass.z += f.v1.v.z * (0.33333333333f / faces.size());
            min.x = min(min.x, f.v1.v.x);
            min.y = min(min.y, f.v1.v.y);
            min.z = min(min.z, f.v1.v.z);
            max.x = max(max.x, f.v1.v.x);
            max.y = max(max.y, f.v1.v.y);
            max.z = max(max.z, f.v1.v.z);
            centerOfMass.x += f.v2.v.x * (0.33333333333f / faces.size());
            centerOfMass.y += f.v2.v.y * (0.33333333333f / faces.size());
            centerOfMass.z += f.v2.v.z * (0.33333333333f / faces.size());
            min.x = min(min.x, f.v2.v.x);
            min.y = min(min.y, f.v2.v.y);
            min.z = min(min.z, f.v2.v.z);
            max.x = max(max.x, f.v2.v.x);
            max.y = max(max.y, f.v2.v.y);
            max.z = max(max.z, f.v2.v.z);
            centerOfMass.x += f.v3.v.x * (0.33333333333f / faces.size());
            centerOfMass.y += f.v3.v.y * (0.33333333333f / faces.size());
            centerOfMass.z += f.v3.v.z * (0.33333333333f / faces.size());
            min.x = min(min.x, f.v3.v.x);
            min.y = min(min.y, f.v3.v.y);
            min.z = min(min.z, f.v3.v.z);
            max.x = max(max.x, f.v3.v.x);
            max.y = max(max.y, f.v3.v.y);
            max.z = max(max.z, f.v3.v.z);
          }
        }    
        scale = max((max.x - min.x), max(max.y - min.y, max.z - min.z));
        if(scale < 0.5f) {
          scale = 0.5f;
        }
        //scale view to look at this
        modelViewMatrix = new Matrix4f();
        if(viewType == VIEW_X) {
          modelViewMatrix.translate(0.0f, centerOfMass.y, centerOfMass.z);
        } else if(viewType == VIEW_Y) {
          modelViewMatrix.translate(centerOfMass.x, 0.0f, centerOfMass.z);
        } else if(viewType == VIEW_Z) {
          modelViewMatrix.translate(centerOfMass.x, centerOfMass.y, 0.0f);
        }  
        modelViewMatrix.scale(VIEW_SCALE * scale * 0.05f, VIEW_SCALE * scale * 0.05f, VIEW_SCALE * scale * 0.05f);
      }
    }
  }
  
  public void drawGrid() {
    Vector3f scale = new Vector3f();
    modelViewMatrix.getScale(scale);
    g.strokeWeight(0.5f * scale.z);
    if(darkModeCheckbox.selected) {
      g.stroke(92, 92, 92);
    } else {
      g.stroke(0, 0, 0);
    }
    Vector3f zero = new Vector3f();
    zero = modelViewMatrix.transformPosition(zero);
    int gridStartX = (int)((zero.x) / STARTING_SCALE);
    gridStartX *= STARTING_SCALE;
    int gridStartY = (int)((zero.y) / STARTING_SCALE);
    gridStartY *= STARTING_SCALE;
    int wG = (int)(((int)(w / STARTING_SCALE)) * STARTING_SCALE);
    int hG = (int)(((int)(h / STARTING_SCALE)) * STARTING_SCALE);    
    switch(viewType) {
      case VIEW_X:
      {                           
        for(int x = (int)(-STARTING_SCALE - wG); x < wG + STARTING_SCALE; x += STARTING_SCALE) {    
          g.line(0.0f, gridStartX + x, -STARTING_SCALE + gridStartY - hG, 
                 0.0f, gridStartX + x, hG + gridStartY + STARTING_SCALE);
        }
        for(int y = (int)(-STARTING_SCALE - hG) ; y < hG + STARTING_SCALE; y += STARTING_SCALE) {
          g.line(0.0f, -STARTING_SCALE + gridStartX - wG, gridStartY + y, 
                 0.0f, wG + gridStartX + STARTING_SCALE, gridStartY + y);
        }
      }      
      break;
      case VIEW_Y:
      {      
        for(int x = (int)(-STARTING_SCALE - wG); x < wG + STARTING_SCALE; x += STARTING_SCALE) {    
          g.line(gridStartX + x, 0.0f, -STARTING_SCALE + gridStartY - hG, 
                 gridStartX + x, 0.0f, hG + gridStartY + STARTING_SCALE);
        }
        for(int y = (int)(-STARTING_SCALE - hG) ; y < hG + STARTING_SCALE; y += STARTING_SCALE) {
          g.line(-STARTING_SCALE + gridStartX - wG, 0.0f, gridStartY + y, 
                 wG + gridStartX + STARTING_SCALE, 0.0f, gridStartY + y);
        }
      }
      break;
      case VIEW_Z:
      {           
        for(int x = (int)(-STARTING_SCALE - wG); x < wG + STARTING_SCALE; x += STARTING_SCALE) {    
          g.line(gridStartX + x, -STARTING_SCALE + gridStartY - hG, 0.0f, 
                 gridStartX + x, hG + gridStartY + STARTING_SCALE, 0.0f);
        }
        for(int y = (int)(-STARTING_SCALE - hG) ; y < hG + STARTING_SCALE; y += STARTING_SCALE) {
          g.line(-STARTING_SCALE + gridStartX - wG, gridStartY + y, 0.0f, 
                 wG + gridStartX + STARTING_SCALE, gridStartY + y, 0.0f);
        }
      }
      break;
      case VIEW_3D:
      break;
    }
  }  
  
  public void draw() {  
    
    if((w <= 0) || (h <= 0)) {
      return;
    }
    if(viewType == VIEW_3D) {
      c.update();
    }
    Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    if(viewType != VIEW_3D) {
      modelViewMatrix.getScale(scale);
    }
    
    g.beginDraw();
    g.pushMatrix();
    g.background(darkModeCheckbox.selected ? 0 : 192);  
    if(viewType == VIEW_Z) {
      g.ortho(-w/2, w/2, -h/2, h/2, -10000, 10000);
      g.camera(0.0f, 0.0f, 10.0f, 
       0.0f, 0.0f, 0.0f, 
       0.0f, -1.0f, 0.0f);
    } else if(viewType == VIEW_Y) { 
      g.ortho(-w/2, w/2, -h/2, h/2, -10000, 10000);     
      g.camera(0.0f, 10.0f, 0.0f, 
       0.0f, 0.0f, 0.0f, 
       0.0f, 0.0f, -1.0f);
    } else if(viewType == VIEW_X) {
      g.ortho(-w/2, w/2, -h/2, h/2, -10000, 10000);      
      g.camera(10.0f, 0.0f, 0.0f, 
       0.0f, 0.0f, 0.0f, 
       0.0f, -1.0f, 0.0f);
    } else if(viewType == VIEW_3D) {
      g.perspective(PI/3.0f, ((float)w) / h, .01f, 10000.0f);
      g.resetMatrix();
      g.applyMatrix(modelViewMatrix.m00(), modelViewMatrix.m10(), modelViewMatrix.m20(), modelViewMatrix.m30(),
        modelViewMatrix.m01(), modelViewMatrix.m11(), modelViewMatrix.m21(), modelViewMatrix.m31(),
        modelViewMatrix.m02(), modelViewMatrix.m12(), modelViewMatrix.m22(), modelViewMatrix.m32(),
        modelViewMatrix.m03(), modelViewMatrix.m13(), modelViewMatrix.m23(), modelViewMatrix.m33());
    }
    
    if(viewType != VIEW_3D) {
      Matrix4f modelViewMatrixInvert = new Matrix4f(modelViewMatrix).invert();
      g.applyMatrix(modelViewMatrixInvert.m00(), modelViewMatrixInvert.m10(), modelViewMatrixInvert.m20(), modelViewMatrixInvert.m30(),
        modelViewMatrixInvert.m01(), modelViewMatrixInvert.m11(), modelViewMatrixInvert.m21(), modelViewMatrixInvert.m31(),
        modelViewMatrixInvert.m02(), modelViewMatrixInvert.m12(), modelViewMatrixInvert.m22(), modelViewMatrixInvert.m32(),
        modelViewMatrixInvert.m03(), modelViewMatrixInvert.m13(), modelViewMatrixInvert.m23(), modelViewMatrixInvert.m33());
    }
    
    g.beginShape(LINES);
    g.strokeWeight(1.0f * scale.z);
    g.stroke(255, 0, 0);
    g.vertex(0.0f, 0.0f, 0.0f);
    g.vertex(5.0f, 0.0f, 0.0f);
    g.stroke(0, 255, 0);
    g.vertex(0.0f, 0.0f, 0.0f);
    g.vertex(0.0f, 5.0f, 0.0f);
    g.stroke(0, 0, 255);
    g.vertex(0.0f, 0.0f, 0.0f);
    g.vertex(0.0f, 0.0f, 5.0f);
    g.endShape();
    
    drawGrid();
    if(!saveNextDraw && showVerticesCheckbox.selected) {
      
      g.strokeCap(PROJECT);
      g.strokeWeight(5.0f * scale.z);
      g.beginShape(POINTS);
      for (int i = vertices.size()-1; i >= 0; i--) {
        Vertex v = vertices.get(i);
        if(v.selected) {        
          g.stroke(255, 0, 0);  
          g.fill(255, 0, 0);
        } else {
          if(darkModeCheckbox.selected) {
            g.stroke(255, 255, 255);  
            g.fill(255, 255, 255);
          } else {
            g.stroke(0, 0, 0);
            g.fill(0, 0, 0);
          }
        }
        g.vertex(v.x, v.y, v.z);
      }
      g.endShape();
      
      /*
      g.beginShape(POINTS);
      g.fill(0, 255, 0);
      g.stroke(0, 255, 0);
      g.vertex(debugPoint.x, debugPoint.y, debugPoint.z);
      g.endShape();
      
      g.beginShape(LINES);      
      g.vertex(debugRayStart.x, debugRayStart.y, debugRayStart.z);
      g.vertex(debugRayStart.x + debugRay.x, debugRayStart.y + debugRay.y, debugRayStart.z + debugRay.z);
      g.stroke(0, 255, 0);
      g.endShape();*/
    }    
    
    
    if(saveNextDraw) { 
      beginRaw(DXF, "output.dxf");
    }
    
    if(showEdgesCheckbox.selected) {
      g.strokeWeight(1.0f * scale.z);
      if(darkModeCheckbox.selected) {
        g.stroke(255, 255, 255);
      } else {
        g.stroke(0, 0, 0);
      }
    } else {
      g.noStroke();
    }
    /*if(showFacesCheckbox.selected) {
      g.fill(128, 128, 128);
    } else {
      g.noFill();
    }*/
    g.beginShape(TRIANGLES);
    if(showLightingCheckbox.selected) {
      g.lights();
    }
    PImage curTexture = null;
    g.textureMode(NORMAL);
    for(int i = faces.size() - 1; i >= 0; i--) {
      Face f = faces.get(i);
      if(darkModeCheckbox.selected) {
        g.fill(128, 128, 128);
        g.ambient(255, 255, 255);
        g.specular(255, 255, 255);
      } else {
        g.fill(64, 64, 64);
        g.ambient(64, 64, 64);
        g.specular(192, 192, 192);
      }
      if(f.m != null) {
        g.ambient(255 * f.m.Ka.x, 255 * f.m.Ka.y, 255 * f.m.Ka.z);
        g.fill(255 * f.m.Kd.x, 255 * f.m.Kd.y, 255 * f.m.Kd.z);
        g.specular(255 * f.m.Ks.x, 255 * f.m.Ks.y, 255 * f.m.Ks.z);
      }
      if(showEdgesCheckbox.selected) {
        g.strokeWeight(1.0f * scale.z);
        if(f.selected) {
          g.stroke(255, 0, 0);
        } else if(darkModeCheckbox.selected) {
          g.stroke(255, 255, 255);
        } else {
          g.stroke(0, 0, 0);
        }
      } else {
        g.noStroke();
      }
      if(f.selected) {
        g.fill(255, 0, 0);
        g.ambient(255, 0, 0);
        g.specular(255, 0, 0);
      }
      if(f.v1.hasNormal) {
        g.normal(f.v1.nx, f.v1.ny, f.v1.nz);
      }
      if(!showFacesCheckbox.selected) {
        g.noFill();
      }
      if(showTexturesCheckbox.selected && f.v1.hasTexture) {
        //println("hasTexture");
        if((f.m != null) && (curTexture != f.m.texture_diffuse)) {
          //println("setTexture " + f.m.texture_diffuse);
          curTexture = f.m.texture_diffuse;    
          //if((f.m != null) && (f.m.texture_diffuse != null)) {
            //println("setting texture " + f.m.texture_diffuse);
            g.endShape();
            g.beginShape(TRIANGLES);
            g.texture(f.m.texture_diffuse);
          //} else {
          //  g.texture(null);
          //}
        } else if ((f.m == null) && (curTexture != null)) {
          curTexture = null;
          g.endShape();
          g.beginShape(TRIANGLES);
          g.texture(null);
        }
        g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z, f.v1.tx, f.v1.ty);
      } else {
        g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z);
      }
      if(f.v2.hasNormal) {
        g.normal(f.v2.nx, f.v2.ny, f.v2.nz);
      }
      if(showTexturesCheckbox.selected && f.v2.hasTexture) {
        g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z, f.v2.tx, f.v2.ty);
      } else {
        g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z);
      }
      if(f.v3.hasNormal) {
        g.normal(f.v3.nx, f.v3.ny, f.v3.nz);
      }
      if(showTexturesCheckbox.selected && f.v3.hasTexture) {
        //println("drawing vertex: " + f.v3.x + " , " + f.v3.y + " , " + f.v3.z + " , " + f.v3.tx + " , " + f.v3.ty);
        g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z, f.v3.tx, f.v3.ty);
      } else {
        g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z);
      }
    }
    g.endShape(); 
    
    if(showNormalsCheckbox.selected) {
      g.beginShape(LINES);
      for (int i = faces.size()-1; i >= 0; i--) {
          Face f = faces.get(i);
          if(f.v1.hasNormal) {
            g.stroke(255, 0, 0);
            g.vertex(f.v1.v.x, f.v1.v.y, f.v1.v.z);
            g.vertex(f.v1.v.x + f.v1.nx * 0.2f, f.v1.v.y + f.v1.ny * 0.2f, f.v1.v.z + f.v1.nz * 0.2f);          
          }
          if(f.v2.hasNormal) {
            g.stroke(255, 0, 0);
            g.vertex(f.v2.v.x, f.v2.v.y, f.v2.v.z);
            g.vertex(f.v2.v.x + f.v2.nx * 0.2f, f.v2.v.y + f.v2.ny * 0.2f, f.v2.v.z + f.v2.nz * 0.2f);          
          }
          if(f.v3.hasNormal) {
            g.stroke(255, 0, 0);
            g.vertex(f.v3.v.x, f.v3.v.y, f.v3.v.z);
            g.vertex(f.v3.v.x + f.v3.nx * 0.2f, f.v3.v.y + f.v3.ny * 0.2f, f.v3.v.z + f.v3.nz * 0.2f);          
          }
          //g.stroke(0, 255, 0);
          //g.vertex((f.v1.v.x + f.v2.v.x + f.v3.v.x) / 3, (f.v1.v.y + f.v2.v.y + f.v3.v.y) / 3, (f.v1.v.z + f.v2.v.z + f.v3.v.z) / 3);
          //g.vertex((f.v1.v.x + f.v2.v.x + f.v3.v.x) / 3 + debugNormal.x, (f.v1.v.y + f.v2.v.y + f.v3.v.y) / 3 + debugNormal.y, (f.v1.v.z + f.v2.v.z + f.v3.v.z) / 3 + debugNormal.z);
          
      }
      g.endShape();
    }
    
    if (saveNextDraw) {
      endRaw();
      saveNextDraw = false;
    }
    
    if(selecting) {
      g.stroke(255, 255, 255);
      g.ambient(255, 255, 255);
      g.specular(255, 255, 255);
      g.fill(255, 228, 228, 92);
      g.pushMatrix();      
      g.resetMatrix();
      g.ortho(-w/2, w/2, -h/2, h/2, -10000, 10000); 
      g.camera(0.0f, 0.0f, 10.0f, 
        0.0f, 0.0f, 0.0f, 
        0.0f, 1.0f, 0.0f);           
      Vector3f startPos = new Vector3f(selectMouseStartX, selectMouseStartY, -10000.0f);
      Vector3f endPos = new Vector3f(selectMouseEndX, selectMouseEndY, -10000.0f);
      g.hint(DISABLE_DEPTH_TEST);
      g.rect(startPos.x, startPos.y, (endPos.x - startPos.x), (endPos.y - startPos.y));
      g.hint(ENABLE_DEPTH_TEST);
      g.popMatrix();
    }
    g.popMatrix();
    g.fill(255, 255, 255);
    g.stroke(255, 255, 255);
    g.endDraw();
    image(g, x, y);
    //saveFrame("test-######.tif");
  }
}


  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Avalanche" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
